/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventCallback;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheWriter;
import java.sql.SQLException;

public final class GfxdCacheListener
implements CacheListener<Object, Object> {
    private final String name;
    private final EventCallback ecb;

    public GfxdCacheListener(String name, EventCallback ecb) {
        this.name = name;
        this.ecb = ecb;
    }

    public void afterCreate(EntryEvent<Object, Object> event) {
        GfxdCacheWriter.callEventCallbackOnEvent((EntryEventImpl)event, this.ecb, Event.Type.AFTER_INSERT);
    }

    public void afterDestroy(EntryEvent<Object, Object> event) {
        GfxdCacheWriter.callEventCallbackOnEvent((EntryEventImpl)event, this.ecb, Event.Type.AFTER_DELETE);
    }

    public void afterInvalidate(EntryEvent<Object, Object> event) {
    }

    public void afterRegionClear(RegionEvent<Object, Object> event) {
    }

    public void afterRegionCreate(RegionEvent<Object, Object> event) {
    }

    public void afterRegionDestroy(RegionEvent<Object, Object> event) {
    }

    public void afterRegionInvalidate(RegionEvent<Object, Object> event) {
    }

    public void afterRegionLive(RegionEvent<Object, Object> event) {
    }

    public void afterUpdate(EntryEvent<Object, Object> event) {
        EntryEventImpl ev = (EntryEventImpl)event;
        if (ev.hasDelta()) {
            GfxdCacheWriter.callEventCallbackOnEvent(ev, this.ecb, Event.Type.AFTER_UPDATE);
        } else {
            GfxdCacheWriter.callEventCallbackOnEvent(ev, this.ecb, Event.Type.AFTER_INSERT);
        }
    }

    public void close() {
        try {
            this.ecb.close();
        }
        catch (SQLException e) {
            Misc.getCacheLogWriter().warning("exception encountered while calling EventCallback.close", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.ecb);
    }
}

