/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index.key;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.ExtractingIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class IndexKeyComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -2636906134615261052L;
    protected final int[] columnOrders;
    protected final int[] keySnapshotPositions;
    protected final int nCols;
    protected final boolean caseSensitive;

    public IndexKeyComparator(int nCols, boolean[] columnOrders, boolean caseSensitive) {
        int i;
        this.nCols = nCols;
        this.columnOrders = new int[columnOrders.length];
        this.keySnapshotPositions = new int[nCols];
        for (i = 0; i < columnOrders.length; ++i) {
            this.columnOrders[i] = columnOrders[i] ? 1 : -1;
        }
        for (i = 0; i < nCols; ++i) {
            this.keySnapshotPositions[i] = i + 1;
        }
        this.caseSensitive = caseSensitive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int compare(Object key, Object mapKey) {
        int[] key2Positions;
        int[] key1Positions;
        RowFormatter ccik2RF;
        RowFormatter ccik1RF;
        byte[] ccik2Bytes;
        byte[] ccik1Bytes;
        DataValueDescriptor[] dvds1;
        DataValueDescriptor dvd1;
        CompactCompositeIndexKey ccik1;
        DataValueDescriptor[] dvds2;
        DataValueDescriptor dvd2;
        CompactCompositeIndexKey ccik2;
        Class<?> keyClass;
        int cmpLen;
        block40: {
            byte[] kbytes;
            int tries;
            ExtraInfo indexInfo;
            block39: {
                block44: {
                    int rowLength;
                    Class<?> mapKeyClass;
                    block45: {
                        block42: {
                            block43: {
                                if (key == mapKey) {
                                    return 0;
                                }
                                cmpLen = this.nCols;
                                keyClass = key.getClass();
                                mapKeyClass = mapKey.getClass();
                                if (mapKeyClass != CompactCompositeIndexKey.class) break block42;
                                ccik2 = (CompactCompositeIndexKey)mapKey;
                                dvd2 = null;
                                dvds2 = null;
                                if (keyClass != CompactCompositeIndexKey.class && keyClass != ExtractingIndexKey.class) break block43;
                                ccik1 = (CompactCompositeIndexKey)key;
                                dvd1 = null;
                                dvds1 = null;
                                break block44;
                            }
                            if (keyClass == DataValueDescriptor[].class) {
                                ccik1 = null;
                                dvd1 = null;
                                dvds1 = (DataValueDescriptor[])key;
                                rowLength = dvds1.length;
                                if (rowLength < cmpLen) {
                                    cmpLen = rowLength;
                                }
                                break block44;
                            } else {
                                ccik1 = null;
                                dvd1 = (DataValueDescriptor)key;
                                dvds1 = null;
                                cmpLen = 1;
                            }
                            break block44;
                        }
                        if (keyClass != CompactCompositeIndexKey.class && keyClass != ExtractingIndexKey.class) break block45;
                        ccik1 = (CompactCompositeIndexKey)key;
                        dvd1 = null;
                        dvds1 = null;
                        if (mapKeyClass == DataValueDescriptor[].class) {
                            ccik2 = null;
                            dvd2 = null;
                            dvds2 = (DataValueDescriptor[])mapKey;
                            rowLength = dvds2.length;
                            if (rowLength < cmpLen || cmpLen <= 0) {
                                cmpLen = rowLength;
                            }
                            break block44;
                        } else {
                            ccik2 = null;
                            dvd2 = (DataValueDescriptor)mapKey;
                            dvds2 = null;
                            cmpLen = 1;
                        }
                        break block44;
                    }
                    ccik1 = null;
                    ccik2 = null;
                    if (keyClass == DataValueDescriptor[].class) {
                        dvd1 = null;
                        dvds1 = (DataValueDescriptor[])key;
                        rowLength = dvds1.length;
                        if (rowLength < cmpLen || cmpLen <= 0) {
                            cmpLen = rowLength;
                        }
                    } else {
                        dvd1 = (DataValueDescriptor)key;
                        dvds1 = null;
                        cmpLen = 1;
                    }
                    if (mapKeyClass == DataValueDescriptor[].class) {
                        dvd2 = null;
                        dvds2 = (DataValueDescriptor[])mapKey;
                        rowLength = dvds2.length;
                        if (rowLength < cmpLen) {
                            cmpLen = rowLength;
                        }
                    } else {
                        dvd2 = (DataValueDescriptor)mapKey;
                        dvds2 = null;
                        cmpLen = 1;
                    }
                }
                ccik1Bytes = null;
                ccik2Bytes = null;
                ccik1RF = null;
                ccik2RF = null;
                key1Positions = null;
                key2Positions = null;
                if (ccik1 != null) {
                    indexInfo = ccik1.tableInfo;
                    if (indexInfo == null) {
                        throw RegionEntryUtils.checkCacheForNullTableInfo("IndexKeyComparator#compare");
                    }
                    tries = 1;
                    do {
                        if ((kbytes = ccik1.getKeyBytes()) != null) {
                            ccik1Bytes = kbytes;
                            ccik1RF = indexInfo.getPrimaryKeyFormatter();
                            key1Positions = this.keySnapshotPositions;
                            break block39;
                        }
                        kbytes = (byte[])ccik1.getRawValueByteSource();
                        if (kbytes != null) {
                            ccik1Bytes = kbytes;
                            ccik1RF = indexInfo.getRowFormatter(kbytes);
                            key1Positions = indexInfo.getPrimaryKeyColumns();
                            break block39;
                        }
                        if (tries++ % 1000 != 0) continue;
                        Thread.yield();
                    } while (tries <= 10000000);
                    throw RegionEntryUtils.checkCacheForNullKeyValue("IndexKeyComparator#compare");
                }
            }
            if (ccik2 != null) {
                indexInfo = ccik2.tableInfo;
                if (indexInfo == null) {
                    throw RegionEntryUtils.checkCacheForNullTableInfo("IndexKeyComparator#compare");
                }
                tries = 1;
                do {
                    if ((kbytes = ccik2.getKeyBytes()) != null) {
                        ccik2Bytes = kbytes;
                        ccik2RF = indexInfo.getPrimaryKeyFormatter();
                        key2Positions = this.keySnapshotPositions;
                        break block40;
                    }
                    kbytes = (byte[])ccik2.getRawValueByteSource();
                    if (kbytes != null) {
                        ccik2Bytes = kbytes;
                        ccik2RF = indexInfo.getRowFormatter(kbytes);
                        key2Positions = indexInfo.getPrimaryKeyColumns();
                        break block40;
                    }
                    if (tries++ % 1000 != 0) continue;
                    Thread.yield();
                } while (tries <= 10000000);
                throw RegionEntryUtils.checkCacheForNullKeyValue("IndexKeyComparator#compare");
            }
        }
        for (int i = 0; i < cmpLen; ++i) {
            try {
                int cmp;
                block41: {
                    ColumnDescriptor cd;
                    if (ccik1 != null) {
                        void rfPos1 = key1Positions[i];
                        cd = ccik1RF.getColumnDescriptor((int)(rfPos1 - true));
                        long offsetWidth1 = ccik1RF.getOffsetAndWidth((int)rfPos1, ccik1Bytes, cd);
                        if (ccik2 != null) {
                            cmp = DataTypeUtilities.compare(ccik1Bytes, ccik2Bytes, offsetWidth1, ccik2RF.getOffsetAndWidth(key2Positions[i], ccik2Bytes, cd), false, this.caseSensitive, cd);
                            break block41;
                        } else {
                            if (dvds2 != null) {
                                dvd2 = dvds2[i];
                            }
                            if ((cmp = DataTypeUtilities.compare(dvd2, ccik1Bytes, offsetWidth1, false, this.caseSensitive, cd)) < 0) {
                                return this.columnOrders[i];
                            }
                            if (cmp <= 0) continue;
                            return -this.columnOrders[i];
                        }
                    }
                    if (dvds1 != null) {
                        dvd1 = dvds1[i];
                    }
                    if (ccik2 != null) {
                        void rfPos2 = key2Positions[i];
                        cd = ccik2RF.getColumnDescriptor((int)(rfPos2 - true));
                        long offsetWidth2 = ccik2RF.getOffsetAndWidth((int)rfPos2, ccik2Bytes, cd);
                        cmp = DataTypeUtilities.compare(dvd1, ccik2Bytes, offsetWidth2, false, this.caseSensitive, cd);
                    } else {
                        if (dvds2 != null) {
                            dvd2 = dvds2[i];
                        }
                        cmp = this.caseSensitive || !(dvd1 instanceof SQLChar) ? dvd1.compare(dvd2) : ((SQLChar)dvd1).compareIgnoreCase(dvd2);
                    }
                }
                if (cmp < 0) {
                    return -this.columnOrders[i];
                }
                if (cmp <= 0) continue;
                return this.columnOrders[i];
            }
            catch (Exception e) {
                GemFireXDRuntimeException re;
                if (key instanceof CompactCompositeIndexKey) {
                    CompactCompositeIndexKey ckey = (CompactCompositeIndexKey)key;
                    re = new GemFireXDRuntimeException("IndexKeyComparator#compare: failed for key=" + ckey + ", value=" + ckey.getTransientValue());
                } else {
                    String keyString = key instanceof DataValueDescriptor[] ? Arrays.toString((DataValueDescriptor[])key) : String.valueOf(key);
                    re = new GemFireXDRuntimeException("IndexKeyComparator#compare: failed for key=" + keyString);
                }
                re.initCause(e);
                throw re;
            }
        }
        if (ccik1 != null && keyClass == ExtractingIndexKey.class && ccik2 != null) {
            ((ExtractingIndexKey)key).afterCompareWith(ccik2);
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" nCols: ").append(this.nCols).append(" columnOrders: ").append(Arrays.toString(this.columnOrders));
        return sb.toString();
    }
}

