/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.pivotal.gemfirexd.internal.engine.Misc;

/**
 * Internal class to send exception caused during function execution on data
 * store.
 * 
 * @author rdubey
 */
public class FunctionExecutionException extends GemFireException {

  private static final long serialVersionUID = 8399012797861994323L;

  /**
   * Constructor.
   * 
   * @param t
   *          the cause.
   */
  public FunctionExecutionException(Throwable t) {
    super("Function execution exception on member [" + getMyIdString() + ']', t);
  }

  private static String getMyIdString() {
    try {
      return Misc.getGemFireCache().getMyId().toString();
    } catch (CacheClosedException ex) {
      return "going down!";
    }
  }
}
