/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot;

import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerMember;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshot;
import java.util.ArrayList;
import java.util.List;

public class GFXDSnapshotExportStat {
    private String serverName;
    private String schemaName;
    private String tableName;
    private String bucketName;
    private String tableType;
    private String fileName;
    private List entryDecodeErrors = new ArrayList();
    private boolean completedFile = true;
    int numValuesDecoded = 0;
    int numValuesNotDecoded = 0;
    private long maxSeqId;
    private int numDdlStmts = 0;
    private long lastModifiedTime = 0L;
    private RegionViewInfoPerMember regionViewInfo;
    private boolean corrupt = false;
    private boolean isQueueExport = false;

    public GFXDSnapshotExportStat(DiskRegionView drv) {
        String regionName = drv.getName();
        String[] names = GFXDSnapshot.getSchemaTableBucketNames(regionName);
        this.schemaName = names[0];
        this.tableName = names[1];
        this.bucketName = names[2];
        this.numValuesDecoded = drv.getRecoveredEntryCount();
    }

    public GFXDSnapshotExportStat(String schemaName, String tableName, String bucketName, RegionViewInfoPerMember regionViewInfo) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.bucketName = bucketName;
        this.regionViewInfo = regionViewInfo;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List getEntryDecodeErrors() {
        return this.entryDecodeErrors;
    }

    public void addEntryDecodeError(String error) {
        this.entryDecodeErrors.add(error);
    }

    public boolean isCompletedFile() {
        return this.completedFile;
    }

    public void setCompletedFile(boolean completedFile) {
        this.completedFile = completedFile;
    }

    public int getNumValuesDecoded() {
        return this.numValuesDecoded;
    }

    public void incrementNumValuesDecoded() {
        ++this.numValuesDecoded;
    }

    public void setNumValuesDecoded(int numValuesDecoded) {
        this.numValuesDecoded = numValuesDecoded;
    }

    public int getNumValuesNotDecoded() {
        return this.numValuesNotDecoded;
    }

    public void incrementNumValuesNotDecoded() {
        ++this.numValuesNotDecoded;
    }

    public String getSchemaTableName() {
        if (this.bucketName == null) {
            return this.schemaName + "_" + this.tableName;
        }
        return this.schemaName + "_" + this.tableName + "_" + this.bucketName;
    }

    public long getMaxSeqId() {
        return this.maxSeqId;
    }

    public void setMaxSeqId(long maxSeqId) {
        this.maxSeqId = maxSeqId;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getNumDdlStmts() {
        return this.numDdlStmts;
    }

    public void setNumDdlStmts(int numOfDdlStmts) {
        this.numDdlStmts = numOfDdlStmts;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableType() {
        return this.tableType;
    }

    public RegionViewInfoPerMember getRegionViewInfo() {
        return this.regionViewInfo;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isSameTableStat(GFXDSnapshotExportStat other) {
        return this.getSchemaTableName().equals(other.getSchemaTableName());
    }

    public boolean isQueueExport() {
        return this.isQueueExport;
    }

    public void setQueueExport(boolean isQueueExport) {
        this.isQueueExport = isQueueExport;
    }
}

