/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.report;

import com.pivotal.gemfirexd.internal.tools.dataextractor.comparators.RegionViewGroupSortComparator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.comparators.RegionViewSortComparator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.comparators.ServerNameComparator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.comparators.TimestampSortComparator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.domain.ServerInfo;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.PersistentView;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import com.pivotal.gemfirexd.internal.tools.dataextractor.utils.ExtractorUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReportGenerator {
    private static String LINE_SEPARATOR;
    private static String SECTION_SEPARATOR;
    Map<String, List<GFXDSnapshotExportStat>> hostToStatsMap;
    Map<String, List<GFXDSnapshotExportStat>> hostToQueueStatsMap;
    private List<String> reportableErrors;
    private String recommendedDDLFile;
    List<List<GFXDSnapshotExportStat>> rankedAndGroupedDdlStats;

    public void setRankedAndGroupDdlsStat(List<List<GFXDSnapshotExportStat>> rankedAndGroupdDDlStats) {
        this.rankedAndGroupedDdlStats = rankedAndGroupdDDlStats;
    }

    public ReportGenerator(List<List<GFXDSnapshotExportStat>> rankedAndGroupedDdlStats, Map<String, List<GFXDSnapshotExportStat>> hostToStatsMap, List<String> reportableErrors) {
        this.rankedAndGroupedDdlStats = rankedAndGroupedDdlStats;
        this.hostToStatsMap = hostToStatsMap;
        this.reportableErrors = reportableErrors;
        this.recommendedDDLFile = rankedAndGroupedDdlStats.get(0).get(0).getFileName();
        this.hostToQueueStatsMap = new HashMap<String, List<GFXDSnapshotExportStat>>();
    }

    public void filterQueueStats() {
        if (!this.hostToStatsMap.isEmpty()) {
            for (Map.Entry<String, List<GFXDSnapshotExportStat>> entry : this.hostToStatsMap.entrySet()) {
                String serverName = entry.getKey();
                List<GFXDSnapshotExportStat> stats = entry.getValue();
                ArrayList<GFXDSnapshotExportStat> qstats = new ArrayList<GFXDSnapshotExportStat>();
                Iterator<GFXDSnapshotExportStat> statsIterator = stats.iterator();
                while (statsIterator.hasNext()) {
                    GFXDSnapshotExportStat stat = statsIterator.next();
                    if (!stat.isQueueExport()) continue;
                    qstats.add(stat);
                    statsIterator.remove();
                }
                if (qstats.isEmpty()) continue;
                this.hostToQueueStatsMap.put(serverName, qstats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printReport(String outputFileName, String recommendedFileName) throws IOException {
        PersistentView pv = PersistentView.getPersistentView(this.hostToStatsMap);
        File file = new File(outputFileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Could not create file:" + file.getAbsolutePath());
        }
        File recommendedFile = new File(recommendedFileName);
        if (!recommendedFile.exists() && !recommendedFile.createNewFile()) {
            throw new IOException("Could not create file:" + recommendedFile.getAbsolutePath());
        }
        PrintWriter pw = new PrintWriter(file);
        PrintWriter recommendedPW = new PrintWriter(recommendedFile);
        try {
            this.printReportableErrors(pw, this.reportableErrors);
            this.printExportDdlSummary(pw);
            this.printExportHdfsQueueSummary(pw);
            Map<String, StatGroup> schemaTableToStatGroup = this.schemaTableNameToStatGroup(this.hostToStatsMap);
            this.sortCSV(pw, schemaTableToStatGroup, new RegionViewGroupSortComparator(new RegionViewSortComparator(new TimestampSortComparator(new ServerNameComparator()))));
            this.printCSVSummary(pw, schemaTableToStatGroup);
            this.printRecommended(recommendedPW, this.recommendedDDLFile, schemaTableToStatGroup);
        }
        finally {
            recommendedPW.close();
            pw.close();
        }
    }

    public static List<List<GFXDSnapshotExportStat>> rankAndGroupDdlStats(Map<ServerInfo, List<GFXDSnapshotExportStat>> hostToDdlMap) {
        PersistentView pv = PersistentView.getPersistentViewForDdlStats(hostToDdlMap);
        ArrayList<GFXDSnapshotExportStat> ddlStats = new ArrayList<GFXDSnapshotExportStat>();
        for (Map.Entry<ServerInfo, List<GFXDSnapshotExportStat>> entry : hostToDdlMap.entrySet()) {
            ServerInfo member = entry.getKey();
            List<GFXDSnapshotExportStat> statList = entry.getValue();
            GFXDSnapshotExportStat stat = statList.get(0);
            stat.setServerName(member.getServerName());
            ddlStats.add(stat);
        }
        ServerNameComparator serverNameComparator = new ServerNameComparator();
        RegionViewSortComparator rvSortComparator = new RegionViewSortComparator(serverNameComparator);
        Collections.sort(ddlStats, rvSortComparator);
        return ExtractorUtils.groupByContent(ddlStats);
    }

    private void printReportableErrors(PrintWriter writer, List<String> reportableErrors) throws IOException {
        if (reportableErrors.size() > 0) {
            writer.write(LINE_SEPARATOR);
            writer.write("[ERRORS AND/OR CONCERNS]" + LINE_SEPARATOR);
            Iterator<String> reportableErrorsIterator = reportableErrors.iterator();
            while (reportableErrorsIterator.hasNext()) {
                writer.write(reportableErrorsIterator.next() + LINE_SEPARATOR);
            }
            writer.write(LINE_SEPARATOR);
            writer.println(SECTION_SEPARATOR);
        }
    }

    public void printExportDdlSummary(PrintWriter writer) throws IOException {
        if (this.rankedAndGroupedDdlStats == null || this.rankedAndGroupedDdlStats.isEmpty()) {
            writer.write("No DDL's to export");
            return;
        }
        writer.write("[DDL EXPORT INFORMATION]");
        writer.println();
        writer.println();
        Iterator<List<GFXDSnapshotExportStat>> rankedDDLIterator = this.rankedAndGroupedDdlStats.iterator();
        int count = 0;
        while (rankedDDLIterator.hasNext()) {
            List<GFXDSnapshotExportStat> ddlStatGroup = rankedDDLIterator.next();
            for (GFXDSnapshotExportStat stat : ddlStatGroup) {
                writer.println("  " + ++count + ". " + stat.getServerName() + " , file : " + stat.getFileName() + " Number of ddl statements : " + stat.getNumDdlStmts());
            }
        }
        writer.println(SECTION_SEPARATOR);
    }

    public void printExportHdfsQueueSummary(PrintWriter writer) throws IOException {
        this.filterQueueStats();
        if (!this.hostToQueueStatsMap.isEmpty()) {
            writer.write("[HDFS QUEUE EXPORT INFORMATION]");
            writer.println();
            for (Map.Entry<String, List<GFXDSnapshotExportStat>> entry : this.hostToQueueStatsMap.entrySet()) {
                String serverName = entry.getKey();
                List<GFXDSnapshotExportStat> qStats = entry.getValue();
                int count = 0;
                writer.println("Server : " + serverName);
                for (GFXDSnapshotExportStat stat : qStats) {
                    writer.println("  " + ++count + ".  file : " + stat.getFileName() + " Number of events : " + stat.getNumValuesDecoded());
                }
                writer.println();
            }
        }
    }

    private void sortCSV(PrintWriter writer, Map<String, StatGroup> schemaTableNameToStatGroup, Comparator<GFXDSnapshotExportStat> fileSortComparator) {
        Collection<StatGroup> statGroups = schemaTableNameToStatGroup.values();
        for (StatGroup statGroup : statGroups) {
            statGroup.sortTally(fileSortComparator);
        }
    }

    private void printCSVSummary(PrintWriter writer, Map<String, StatGroup> schemaTableNameToStatGroup) {
        writer.write("[EXPORT INFORMATION FOR TABLES]");
        writer.println();
        Collection<StatGroup> statGroups = schemaTableNameToStatGroup.values();
        for (StatGroup statGroup : statGroups) {
            statGroup.printTally(writer);
        }
        writer.println(SECTION_SEPARATOR);
    }

    private void printRecommended(PrintWriter writer, String ddlFileName, Map<String, StatGroup> schemaTableNameToStatGroup) {
        writer.write(ddlFileName + LINE_SEPARATOR);
        Collection<StatGroup> statGroups = schemaTableNameToStatGroup.values();
        for (StatGroup statGroup : statGroups) {
            statGroup.printRecommended(writer);
        }
    }

    private Map<String, StatGroup> schemaTableNameToStatGroup(Map<String, List<GFXDSnapshotExportStat>> map) {
        HashMap<String, StatGroup> schemaTableNameToStatGroup = new HashMap<String, StatGroup>();
        for (Map.Entry<String, List<GFXDSnapshotExportStat>> entrySet : map.entrySet()) {
            List<GFXDSnapshotExportStat> listOfStatsForServer = entrySet.getValue();
            this.organizeListOfStatsToStatGroup(schemaTableNameToStatGroup, listOfStatsForServer);
        }
        return schemaTableNameToStatGroup;
    }

    private void organizeListOfStatsToStatGroup(Map<String, StatGroup> schemaTableNameToStatGroup, List<GFXDSnapshotExportStat> listOfStats) {
        for (GFXDSnapshotExportStat stat : listOfStats) {
            String schemaAndTableName = stat.getSchemaTableName();
            StatGroup statGroup = schemaTableNameToStatGroup.get(schemaAndTableName);
            if (statGroup == null) {
                statGroup = new StatGroup(schemaAndTableName);
                schemaTableNameToStatGroup.put(schemaAndTableName, statGroup);
            }
            statGroup.addStat(stat);
        }
    }

    static {
        SECTION_SEPARATOR = LINE_SEPARATOR = System.getProperty("line.separator");
    }

    public static class StatGroup {
        private String schemaAndTableName;
        private ArrayList<GFXDSnapshotExportStat> statsOfRelatedTableFiles = new ArrayList();
        private Map<GFXDSnapshotExportStat, List<GFXDSnapshotExportStat>> tally = new HashMap<GFXDSnapshotExportStat, List<GFXDSnapshotExportStat>>();
        private List<GFXDSnapshotExportStat> sortedTally;

        private StatGroup(String schemaAndTableName) {
            this.schemaAndTableName = schemaAndTableName;
        }

        public String getSchemaAndTableName() {
            return this.schemaAndTableName;
        }

        public void addStat(GFXDSnapshotExportStat stat) {
            this.statsOfRelatedTableFiles.add(stat);
        }

        public Map<GFXDSnapshotExportStat, List<GFXDSnapshotExportStat>> getTalliedStats() {
            return this.tally;
        }

        public void printTally(PrintWriter writer) {
            writer.write("Table:" + this.schemaAndTableName + LINE_SEPARATOR);
            List<GFXDSnapshotExportStat> sortedTally = this.getSortedTally();
            Iterator<GFXDSnapshotExportStat> sortedIterator = sortedTally.iterator();
            int index = 1;
            while (sortedIterator.hasNext()) {
                GFXDSnapshotExportStat stat = sortedIterator.next();
                writer.write("  " + index++ + ". " + stat.getFileName() + " . Number of rows extracted : " + stat.getNumValuesDecoded());
                writer.write(LINE_SEPARATOR);
            }
            writer.write(LINE_SEPARATOR);
        }

        public void printRecommended(PrintWriter writer) {
            List<GFXDSnapshotExportStat> sortedTally = this.getSortedTally();
            Iterator<GFXDSnapshotExportStat> sortedIterator = sortedTally.iterator();
            if (sortedIterator.hasNext()) {
                GFXDSnapshotExportStat stat = sortedIterator.next();
                writer.write(stat.getFileName() + LINE_SEPARATOR);
            }
        }

        public List<GFXDSnapshotExportStat> getSortedTally() {
            return this.sortedTally;
        }

        public List<GFXDSnapshotExportStat> sortTally(Comparator<GFXDSnapshotExportStat> fileSortComparator) {
            this.sortedTally = new ArrayList<GFXDSnapshotExportStat>();
            Iterator<GFXDSnapshotExportStat> iterator = this.statsOfRelatedTableFiles.iterator();
            while (iterator.hasNext()) {
                this.sortedTally.add(iterator.next());
            }
            Collections.sort(this.sortedTally, fileSortComparator);
            return this.sortedTally;
        }
    }
}

