/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.xact;

import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.GlobalTransactionId;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BeginXact
implements Loggable {
    protected int transactionStatus;
    protected GlobalTransactionId xactId;

    public BeginXact(GlobalTransactionId xid, int s) {
        this.xactId = xid;
        this.transactionStatus = s;
    }

    public BeginXact() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.transactionStatus);
        out.writeObject(this.xactId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.transactionStatus = in.readInt();
        this.xactId = (GlobalTransactionId)in.readObject();
    }

    @Override
    public int getTypeFormatId() {
        return 169;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) {
        RawTransaction rt = (RawTransaction)xact;
        if (instant != null) {
            rt.setFirstLogInstant(instant);
            rt.addUpdateTransaction(this.transactionStatus);
        }
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public boolean needsRedo(Transaction xact) {
        return true;
    }

    @Override
    public void releaseResource(Transaction xact) {
    }

    @Override
    public int group() {
        int group = 257;
        return group;
    }

    public String toString() {
        return "BeginXact " + this.xactId + " transactionStatus " + Integer.toHexString(this.transactionStatus);
    }

    public GlobalTransactionId getGlobalId() {
        return this.xactId;
    }
}

