/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseContainerHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.RAFContainer;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.IOException;

class TempRAFContainer
extends RAFContainer {
    protected int inUseCount;

    TempRAFContainer(BaseDataFileFactory factory) {
        super(factory);
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() != -1L) {
            RAFContainer realContainer = new RAFContainer(this.dataFactory);
            return realContainer.setIdent(newIdentity);
        }
        return super.setIdentity(newIdentity);
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() != -1L) {
            RAFContainer realContainer = new RAFContainer(this.dataFactory);
            return realContainer.createIdentity(newIdentity, createParameter);
        }
        return this.createIdent(newIdentity, createParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
        this.pageCache.discard(this.identity);
        TempRAFContainer tempRAFContainer = this;
        synchronized (tempRAFContainer) {
            this.setDroppedState(true);
            this.setCommittedDropState(true);
            this.setDirty(false);
            this.needsSync = false;
        }
        this.removeFile(this.getFileName(this.identity, false, false, false));
    }

    @Override
    protected int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        return 0;
    }

    @Override
    protected void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        if (!this.getDroppedState()) {
            super.writePage(pageNumber, pageData, false);
        }
        this.needsSync = false;
    }

    @Override
    StorageFile getFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) {
        return this.privGetFileName(identity, stub, errorOK, tryAlternatePath);
    }

    @Override
    protected StorageFile privGetFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) {
        return this.dataFactory.storageFactory.newStorageFile(this.dataFactory.storageFactory.getTempDir(), "T" + identity.getContainerId() + ".tmp");
    }

    @Override
    public Page addPage(BaseContainerHandle handle, boolean isOverflow) throws StandardException {
        BasePage newPage = this.newPage(handle, null, handle, isOverflow);
        SanityManager.ASSERT((boolean)newPage.isLatched());
        return newPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(BaseContainerHandle handle) throws StandardException {
        TempRAFContainer tempRAFContainer = this;
        synchronized (tempRAFContainer) {
            this.setDroppedState(true);
            this.setCommittedDropState(true);
            this.setDirty(false);
            this.needsSync = false;
        }
        while (!this.pageCache.discard(this.identity)) {
        }
        this.removeFile(this.getFileName(this.identity, false, true, false));
        this.createIdent(this.identity, this);
        this.addPage(handle, false).unlatch();
    }

    @Override
    protected boolean use(BaseContainerHandle handle, boolean forUpdate, boolean droppedOK) throws StandardException {
        if (super.use(handle, forUpdate, droppedOK)) {
            ++this.inUseCount;
            return true;
        }
        return false;
    }

    @Override
    protected void letGo(BaseContainerHandle handle) {
        --this.inUseCount;
        super.letGo(handle);
    }

    public boolean isSingleUser() {
        return this.inUseCount == 1;
    }
}

