/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheableFactory;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ConglomerateFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.MethodFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.impl.store.access.CacheableConglomerate;
import com.pivotal.gemfirexd.internal.impl.store.access.PropertyConglomerate;
import com.pivotal.gemfirexd.internal.impl.store.access.RAMTransaction;
import com.pivotal.gemfirexd.internal.impl.store.access.RAMTransactionContext;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class RAMAccessManager
implements AccessFactory,
CacheableFactory,
ModuleControl,
PropertySetCallback {
    private RawStoreFactory rawstore;
    private Hashtable implhash = new Hashtable();
    private Hashtable formathash = new Hashtable();
    private Properties serviceProperties;
    LockingPolicy system_default_locking_policy;
    private PropertyConglomerate xactProperties;
    private PropertyFactory pf;
    protected LockingPolicy[] table_level_policy;
    protected LockingPolicy[] record_level_policy;
    protected ConglomerateFactory[] conglom_map;
    private CacheManager conglom_cache;
    private long conglom_nextid = 0L;

    protected LockingPolicy getDefaultLockingPolicy() {
        return this.system_default_locking_policy;
    }

    RawStoreFactory getRawStore() {
        return this.rawstore;
    }

    PropertyConglomerate getTransactionalProperties() {
        return this.xactProperties;
    }

    private void boot_load_conglom_map() throws StandardException {
        this.conglom_map = new ConglomerateFactory[2];
        MethodFactory mfactory = this.findMethodFactoryByImpl("heap");
        if (mfactory == null || !(mfactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", "heap");
        }
        this.conglom_map[0] = (ConglomerateFactory)mfactory;
        mfactory = this.findMethodFactoryByImpl("BTREE");
        if (mfactory == null || !(mfactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", "BTREE");
        }
        this.conglom_map[1] = (ConglomerateFactory)mfactory;
    }

    protected abstract int getSystemLockLevel();

    protected abstract void bootLookupSystemLockLevel(TransactionController var1) throws StandardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextConglomId(int factory_type) throws StandardException {
        long conglomid;
        SanityManager.ASSERT((factory_type >= 0 && factory_type <= 15 ? 1 : 0) != 0);
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            if (this.conglom_nextid == 0L) {
                this.conglom_nextid = (this.rawstore.getMaxContainerId() >> 4) + 1L;
            }
            conglomid = this.conglom_nextid++;
        }
        return conglomid << 4 | (long)factory_type;
    }

    private ConglomerateFactory getFactoryFromConglomId(long conglom_id) throws StandardException {
        try {
            return this.conglom_map[(int)(0xFL & conglom_id)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StandardException.newException("XSAI2.S", new Long(conglom_id));
        }
    }

    private void conglomCacheInit() throws StandardException {
        CacheFactory cf = (CacheFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory");
        this.conglom_cache = cf.newCacheManager(this, "ConglomerateDirectoryCache", 200, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Conglomerate conglomCacheFind(TransactionManager xact_mgr, long conglomid) throws StandardException {
        Conglomerate conglom = null;
        Long conglomid_obj = new Long(conglomid);
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate cache_entry = (CacheableConglomerate)this.conglom_cache.findCached(conglomid_obj);
            if (cache_entry != null) {
                conglom = cache_entry.getConglom();
                this.conglom_cache.release(cache_entry);
            } else {
                conglom = this.getFactoryFromConglomId(conglomid).readConglomerate(xact_mgr, new ContainerKey(0L, conglomid));
                if (conglom != null) {
                    cache_entry = (CacheableConglomerate)this.conglom_cache.create(conglomid_obj, conglom);
                    this.conglom_cache.release(cache_entry);
                }
            }
        }
        return conglom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conglomCacheInvalidate() throws StandardException {
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            this.conglom_cache.ageOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void conglomCacheUpdateEntry(long conglomid, Conglomerate new_conglom) throws StandardException {
        Long conglomid_obj = new Long(conglomid);
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate conglom_entry = (CacheableConglomerate)this.conglom_cache.findCached(conglomid_obj);
            if (conglom_entry != null) {
                this.conglom_cache.remove(conglom_entry);
            }
            conglom_entry = (CacheableConglomerate)this.conglom_cache.create(conglomid_obj, new_conglom);
            this.conglom_cache.release(conglom_entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void conglomCacheAddEntry(long conglomid, Conglomerate conglom) throws StandardException {
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate conglom_entry = (CacheableConglomerate)this.conglom_cache.create(new Long(conglomid), conglom);
            this.conglom_cache.release(conglom_entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void conglomCacheRemoveEntry(long conglomid) throws StandardException {
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate conglom_entry = (CacheableConglomerate)this.conglom_cache.findCached(new Long(conglomid));
            if (conglom_entry != null) {
                this.conglom_cache.remove(conglom_entry);
            }
        }
    }

    @Override
    public void createFinished() throws StandardException {
        this.rawstore.createFinished();
    }

    @Override
    public MethodFactory findMethodFactoryByFormat(UUID format) {
        MethodFactory factory = (MethodFactory)this.formathash.get(format);
        if (factory != null) {
            return factory;
        }
        Enumeration e = this.formathash.elements();
        while (e.hasMoreElements()) {
            factory = (MethodFactory)e.nextElement();
            if (!factory.supportsFormat(format)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public MethodFactory findMethodFactoryByImpl(String impltype) throws StandardException {
        Properties conglomProperties;
        MethodFactory factory;
        block5: {
            factory = (MethodFactory)this.implhash.get(impltype);
            if (factory != null) {
                return factory;
            }
            Enumeration e = this.implhash.elements();
            while (e.hasMoreElements()) {
                factory = (MethodFactory)e.nextElement();
                if (!factory.supportsImplementation(impltype)) continue;
                return factory;
            }
            factory = null;
            conglomProperties = new Properties(this.serviceProperties);
            conglomProperties.put("gemfirexd.access.Conglomerate.type", impltype);
            try {
                factory = (MethodFactory)Monitor.bootServiceModule(false, this, "com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.MethodFactory", impltype, conglomProperties);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("XBM02.D")) break block5;
                throw se;
            }
        }
        conglomProperties = null;
        if (factory != null) {
            this.registerAccessMethod(factory);
            return factory;
        }
        return null;
    }

    @Override
    public LockFactory getLockFactory() {
        return this.rawstore.getLockFactory();
    }

    @Override
    public TransactionController getAndNameTransaction(ContextManager cm, String transName) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionController getTransaction(ContextManager cm) throws StandardException {
        throw new UnsupportedOperationException();
    }

    public TransactionController getTransaction(ContextManager cm, boolean bootTime) throws StandardException {
        return this.getAndNameTransaction(cm, "UserTransaction", bootTime);
    }

    public TransactionController getAndNameTransaction(ContextManager cm, String transName, boolean bootTime) throws StandardException {
        if (cm == null) {
            return null;
        }
        RAMTransactionContext rtc = (RAMTransactionContext)cm.getContext("RAMTransactionContext");
        if (rtc == null) {
            Transaction rawtran = this.rawstore.findUserTransaction(cm, transName);
            RAMTransaction rt = new RAMTransaction(this, rawtran, null);
            rtc = new RAMTransactionContext(cm, "RAMTransactionContext", rt, false);
            RAMTransaction tc = rtc.getTransaction();
            if (this.xactProperties != null) {
                rawtran.setup(tc);
                tc.commit();
            }
            rawtran.setDefaultLockingPolicy(this.system_default_locking_policy);
            tc.commit();
            return tc;
        }
        return rtc.getTransaction();
    }

    @Override
    public Object startXATransaction(ContextManager cm, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        RAMTransaction xa_tc = null;
        SanityManager.ASSERT((global_id != null ? 1 : 0) != 0);
        SanityManager.ASSERT((branch_id != null ? 1 : 0) != 0);
        if (cm == null) {
            return null;
        }
        RAMTransactionContext rtc = (RAMTransactionContext)cm.getContext("RAMTransactionContext");
        if (rtc == null) {
            Transaction rawtran = this.rawstore.startGlobalTransaction(cm, format_id, global_id, branch_id);
            xa_tc = new RAMTransaction(this, rawtran, null);
            rtc = new RAMTransactionContext(cm, "RAMTransactionContext", xa_tc, false);
            if (this.xactProperties != null) {
                rawtran.setup(xa_tc);
                xa_tc.commitNoSync(5);
            }
            rawtran.setDefaultLockingPolicy(this.system_default_locking_policy);
            xa_tc.commitNoSync(5);
        } else {
            SanityManager.THROWASSERT((String)"RAMTransactionContext found on stack.");
        }
        return xa_tc;
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        return this.rawstore.getXAResourceManager();
    }

    @Override
    public void registerAccessMethod(MethodFactory factory) {
        this.implhash.put(factory.primaryImplementationType(), factory);
        this.formathash.put(factory.primaryFormat(), factory);
    }

    @Override
    public boolean isReadOnly() {
        return this.rawstore.isReadOnly();
    }

    private void addPropertySetNotification(PropertySetCallback who, TransactionController tc) {
        this.pf.addPropertySetNotification(who);
        Hashtable d = new Hashtable();
        try {
            this.xactProperties.getProperties(tc, d, false, false);
        }
        catch (StandardException se) {
            return;
        }
        boolean dbOnly = PropertyUtil.isDBOnly(d);
        who.init(dbOnly, d);
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        return this.rawstore.getTransactionInfo();
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws StandardException {
        this.rawstore.startReplicationMaster(dbmaster, host, port, replicationMode);
    }

    @Override
    public void failover(String dbname) throws StandardException {
        this.rawstore.failover(dbname);
    }

    @Override
    public void stopReplicationMaster() throws StandardException {
        this.rawstore.stopReplicationMaster();
    }

    @Override
    public void freeze() throws StandardException {
        this.rawstore.freeze();
    }

    @Override
    public void unfreeze() throws StandardException {
        this.rawstore.unfreeze();
    }

    @Override
    public void backup(String backupDir, boolean wait) throws StandardException {
        this.rawstore.backup(backupDir, wait);
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws StandardException {
        this.rawstore.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws StandardException {
        this.rawstore.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
    }

    @Override
    public void checkpoint() throws StandardException {
        this.rawstore.checkpoint();
    }

    @Override
    public void waitForPostCommitToFinishWork() {
        this.rawstore.getDaemon().waitUntilQueueIsEmpty();
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.serviceProperties = startParams;
        this.boot_load_conglom_map();
        if (create) {
            this.conglom_nextid = 1L;
        }
        this.rawstore = (RawStoreFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory", this.serviceProperties);
        Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory", startParams);
        this.conglomCacheInit();
        RAMTransaction tc = (RAMTransaction)this.getAndNameTransaction(ContextService.getFactory().getCurrentContextManager(), "UserTransaction", true);
        int lock_mode = 2;
        this.system_default_locking_policy = tc.getRawStoreXact().newLockingPolicy(lock_mode, 5, true);
        this.table_level_policy = new LockingPolicy[6];
        this.table_level_policy[0] = tc.getRawStoreXact().newLockingPolicy(2, 0, true);
        this.table_level_policy[1] = tc.getRawStoreXact().newLockingPolicy(2, 1, true);
        this.table_level_policy[2] = tc.getRawStoreXact().newLockingPolicy(2, 2, true);
        this.table_level_policy[3] = tc.getRawStoreXact().newLockingPolicy(2, 3, true);
        this.table_level_policy[4] = tc.getRawStoreXact().newLockingPolicy(2, 4, true);
        this.table_level_policy[5] = tc.getRawStoreXact().newLockingPolicy(2, 5, true);
        this.record_level_policy = new LockingPolicy[6];
        this.record_level_policy[0] = tc.getRawStoreXact().newLockingPolicy(1, 0, true);
        this.record_level_policy[1] = tc.getRawStoreXact().newLockingPolicy(1, 1, true);
        this.record_level_policy[2] = tc.getRawStoreXact().newLockingPolicy(1, 2, true);
        this.record_level_policy[3] = tc.getRawStoreXact().newLockingPolicy(1, 3, true);
        this.record_level_policy[4] = tc.getRawStoreXact().newLockingPolicy(1, 4, true);
        this.record_level_policy[5] = tc.getRawStoreXact().newLockingPolicy(1, 5, true);
        for (int i = 0; i < 5; ++i) {
            SanityManager.ASSERT((this.table_level_policy[i] != null ? 1 : 0) != 0, (String)("table_level_policy[" + i + "] is null"));
            SanityManager.ASSERT((this.record_level_policy[i] != null ? 1 : 0) != 0, (String)("record_level_policy[" + i + "] is null"));
        }
        tc.commit();
        this.pf = (PropertyFactory)Monitor.findServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory");
        this.xactProperties = new PropertyConglomerate(tc, create, startParams, this.pf);
        this.rawstore.getRawStoreProperties(tc);
        this.bootLookupSystemLockLevel(tc);
        lock_mode = this.getSystemLockLevel() == 7 ? 2 : 1;
        this.system_default_locking_policy = tc.getRawStoreXact().newLockingPolicy(lock_mode, 5, true);
        this.addPropertySetNotification(this.getLockFactory(), tc);
        this.addPropertySetNotification(this, tc);
        tc.commit();
        tc.destroy();
        tc = null;
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
    }

    @Override
    public void stop() {
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("encryptionAlgorithm")) {
            throw StandardException.newException("XBCXD.S");
        }
        if (key.equals("encryptionProvider")) {
            throw StandardException.newException("XBCXE.S");
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) throws StandardException {
        return null;
    }

    @Override
    public Cacheable newCacheable(CacheManager cm) {
        return new CacheableConglomerate();
    }
}

