/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class WindowResultSet
extends NoPutResultSetImpl {
    private GeneratedMethod restriction = null;
    private GeneratedMethod row;
    public final NoPutResultSet source;
    public long restrictionTime;
    private FormatableBitSet referencedColumns;
    private ExecRow allocatedRow;
    private int rownumber;
    private int level;

    WindowResultSet(Activation activation, NoPutResultSet source, GeneratedMethod rowAllocator, int resultSetNumber, int level, int erdNumber, GeneratedMethod restriction, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"activation expected to be non-null");
        SanityManager.ASSERT((resultSetNumber >= 0 ? 1 : 0) != 0, (String)"resultSetNumber expected to be >= 0");
        SanityManager.ASSERT((level > 0 ? 1 : 0) != 0, (String)"level expected to be > 0");
        this.restriction = restriction;
        this.source = source;
        this.row = rowAllocator;
        this.allocatedRow = null;
        this.rownumber = 0;
        this.level = level;
        if (erdNumber != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getSavedObject(erdNumber);
        }
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"WindowResultSet already open");
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        this.source.openCore();
        this.rownumber = 0;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"WindowResultSet already open");
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.source.reopenCore();
        this.rownumber = 0;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow sourceRow = null;
        ExecRow retval = null;
        boolean restrict = false;
        long beginRT = 0L;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        ExecRow tmpRow = null;
        TXState localTXState = this.localTXState;
        do {
            if ((sourceRow = this.source.getNextRowCore()) != null) {
                ++this.rownumber;
                tmpRow = this.getAllocatedRow();
                this.populateFromSourceRow(sourceRow, tmpRow);
                this.setCurrentRow(tmpRow);
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                if (this.statisticsTimingOn) {
                    this.restrictionTime += this.getElapsedNanos(beginRT);
                }
                boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                    this.filteredRowLocationPostRead(localTXState);
                }
                ++this.rowsSeen;
                retval = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            retval = null;
        } while (sourceRow != null && !restrict);
        if (localTXState != null && this.isTopResultSet && retval != null && this.isForUpdate()) {
            this.updateRowLocationPostRead();
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return retval;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of WindowResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    public void populateFromSourceRow(ExecRow srcrow, ExecRow destrow) throws StandardException {
        int srcindex = 1;
        int levelCnt = 1;
        try {
            DataValueDescriptor[] columns = destrow.getRowArray();
            for (int index = 0; index < columns.length; ++index) {
                if (this.referencedColumns != null && !this.referencedColumns.get(index)) {
                    if (levelCnt > this.level) continue;
                    columns[index].setValue((long)this.rownumber);
                    ++levelCnt;
                    continue;
                }
                destrow.setColumn(index + 1, srcrow.getColumn(srcindex));
                ++srcindex;
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, 0);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        if (this.allocatedRow == null) {
            this.allocatedRow = (ExecRow)this.row.invoke(this.activation);
        }
        return this.allocatedRow;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        this.restrictionTime = 0L;
        super.resetStatistics();
        this.source.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "WINDOW");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

