/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.FileInfoDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.services.reflect.JarLoader;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.SQLException;

public class JarUtil {
    private LanguageConnectionContext lcc;
    private String schemaName;
    private String sqlName;
    private FileResource fr;
    private DataDictionary dd;
    private DataDescriptorGenerator ddg;

    private JarUtil(LanguageConnectionContext lcc, String schemaName, String sqlName) throws StandardException {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.lcc = lcc;
        this.fr = lcc.getTransactionExecute().getFileHandler();
        this.dd = lcc.getDataDictionary();
        this.ddg = this.dd.getDataDescriptorGenerator();
    }

    public static long install(LanguageConnectionContext lcc, String schemaName, String sqlName, String externalPath) throws StandardException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        InputStream is = null;
        try {
            is = SharedUtils.openURL((String)externalPath);
            long l = jutil.add(is);
            return l;
        }
        catch (IOException fnfe) {
            throw StandardException.newException("46001", (Throwable)fnfe, (Object)externalPath);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long install(LanguageConnectionContext lcc, String schemaName, String sqlName, Blob jarBlob) throws StandardException, SQLException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        InputStream is = null;
        try {
            is = jarBlob.getBinaryStream();
            long l = jutil.add(is);
            return l;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long replace(LanguageConnectionContext lcc, String schemaName, String sqlName, Blob jarBlob) throws StandardException, SQLException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        InputStream is = null;
        try {
            is = jarBlob.getBinaryStream();
            long l = jutil.replace(is);
            return l;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long add(InputStream is) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid != null) {
            throw StandardException.newException("X0Y32.S", fid.getDescriptorType(), (Object)this.sqlName, (Object)fid.getSchemaDescriptor().getDescriptorType(), (Object)this.schemaName);
        }
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        try {
            this.notifyClassPathChange(this.schemaName + "." + this.sqlName, 0);
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            String jarExternalName = this.schemaName + "." + this.sqlName;
            long generationId = this.setJar(jarExternalName, is, true, 0L);
            fid = this.ddg.newFileInfoDescriptor(null, sd, this.sqlName, generationId);
            this.dd.addDescriptor(fid, sd, 12, false, this.lcc.getTransactionExecute());
            long l = generationId;
            return l;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static void drop(LanguageConnectionContext lcc, String schemaName, String sqlName) throws StandardException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        jutil.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        String dbcp_s = PropertyUtil.getServiceProperty(this.lcc.getTransactionExecute(), "gemfirexd.distributedsystem.classpath");
        if (dbcp_s != null) {
            String[][] dbcp = IdUtil.parseDbClassPath(dbcp_s);
            boolean found = false;
            for (int ix = 0; ix < dbcp.length; ++ix) {
                if (dbcp.length != 2 || !dbcp[ix][0].equals(this.schemaName) || !dbcp[ix][1].equals(this.sqlName)) continue;
                found = true;
            }
            if (found) {
                throw StandardException.newException("X0X07.S", (Object)IdUtil.mkQualifiedName(this.schemaName, this.sqlName), (Object)dbcp_s);
            }
        }
        try {
            JarLoader oldLoader = this.closeOldJarLoader(this.schemaName, this.sqlName);
            String fullName = this.schemaName + '.' + this.sqlName;
            this.notifyClassPathChange(fullName, 1);
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            DependencyManager dm = this.dd.getDependencyManager();
            dm.invalidateFor(fid, 17, this.lcc);
            this.dd.dropFileInfoDescriptor(fid);
            this.fr.remove(fullName, fid.getGenerationId(), this.lcc);
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static long replace(LanguageConnectionContext lcc, String schemaName, String sqlName, String externalPath) throws StandardException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        InputStream is = null;
        try {
            is = SharedUtils.openURL((String)externalPath);
            long l = jutil.replace(is);
            return l;
        }
        catch (IOException fnfe) {
            throw StandardException.newException("46001", (Throwable)fnfe, (Object)externalPath);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replace(InputStream is) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        JarLoader oldLoader = null;
        boolean loaderNotified = false;
        try {
            oldLoader = this.closeOldJarLoader(this.schemaName, this.sqlName);
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            this.dd.dropFileInfoDescriptor(fid);
            String jarExternalName = this.schemaName + "." + this.sqlName;
            long generationId = this.setJar(jarExternalName, is, false, fid.getGenerationId());
            this.notifyClassPathChange(this.schemaName + "." + this.sqlName, 2);
            FileInfoDescriptor fid2 = this.ddg.newFileInfoDescriptor(fid.getUUID(), fid.getSchemaDescriptor(), this.sqlName, generationId);
            this.dd.addDescriptor(fid2, fid.getSchemaDescriptor(), 12, false, this.lcc.getTransactionExecute());
            this.notifyLoader(true);
            loaderNotified = true;
            oldLoader.refreshDependents();
            long l = generationId;
            return l;
        }
        finally {
            if (!loaderNotified) {
                this.notifyLoader(true);
            }
        }
    }

    private FileInfoDescriptor getInfo() throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        return this.dd.getFileInfoDescriptor(sd, this.sqlName);
    }

    private void notifyLoader(boolean reload) throws StandardException {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        cf.notifyModifyJar(reload);
    }

    private void notifyClassPathChange(String name, int jar_opType) {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        cf.notifyModifyClasspath(name, jar_opType);
    }

    private JarLoader closeOldJarLoader(String schemaName, String sqlName) {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        return cf.closeJarLoader(schemaName, sqlName);
    }

    private long setJar(final String jarExternalName, final InputStream contents, final boolean add, final long currentGenerationId) throws StandardException {
        try {
            return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    long generationId = add ? JarUtil.this.fr.add(jarExternalName, contents, JarUtil.this.lcc) : JarUtil.this.fr.replace(jarExternalName, currentGenerationId, contents, JarUtil.this.lcc);
                    return generationId;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (StandardException)e.getException();
        }
    }

    public static String mkExternalName(String schemaName, String sqlName, char separatorChar) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("jar");
        sb.append(separatorChar);
        sb.append(schemaName);
        sb.append(separatorChar);
        sb.append(sqlName);
        sb.append(".jar");
        return sb.toString();
    }
}

