/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.db.TriggerExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionStmtValidator;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AutoincrementCounter;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class InternalTriggerExecutionContext
implements TriggerExecutionContext,
ExecutionStmtValidator {
    protected int[] changedColIds;
    protected String[] changedColNames;
    protected int dmlType;
    protected String statementText;
    protected ConnectionContext cc;
    protected UUID targetTableId;
    protected String targetTableName;
    protected LanguageConnectionContext lcc;
    protected CursorResultSet beforeResultSet;
    protected CursorResultSet afterResultSet;
    protected ExecRow afterRow;
    protected boolean cleanupCalled;
    protected TriggerEvent event;
    protected TriggerDescriptor triggerd;
    private Vector resultSetVector;
    private Vector aiCounters;
    private Hashtable aiHT;

    public InternalTriggerExecutionContext(LanguageConnectionContext lcc, ConnectionContext cc, String statementText, int dmlType, int[] changedColIds, String[] changedColNames, UUID targetTableId, String targetTableName, Vector aiCounters) throws StandardException {
        this.dmlType = dmlType;
        this.changedColIds = changedColIds;
        this.changedColNames = changedColNames;
        this.statementText = statementText;
        this.cc = cc;
        this.lcc = lcc;
        this.targetTableId = targetTableId;
        this.targetTableName = targetTableName;
        this.resultSetVector = new Vector();
        this.aiCounters = aiCounters;
        if (changedColIds == null != (changedColNames == null)) {
            SanityManager.THROWASSERT((String)("bad changed cols, (changedColsIds == null) = " + (changedColIds == null) + "  (changedColsNames == null) = " + (changedColNames == null)));
        }
        if (changedColIds != null) {
            SanityManager.ASSERT((changedColIds.length == changedColNames.length ? 1 : 0) != 0, (String)"different number of changed col ids vs names");
        }
        lcc.pushTriggerExecutionContext(this);
    }

    void setBeforeResultSet(CursorResultSet rs) {
        this.beforeResultSet = rs;
    }

    void setAfterResultSet(CursorResultSet rs) throws StandardException {
        this.afterResultSet = rs;
        if (this.aiCounters != null) {
            if (this.triggerd.isRowTrigger()) {
                rs.open();
                this.afterRow = rs.getNextRow();
                rs.close(false);
            } else if (!this.triggerd.isBeforeTrigger()) {
                this.resetAICounters(false);
            }
        }
    }

    void setCurrentTriggerEvent(TriggerEvent event) {
        this.event = event;
    }

    void clearCurrentTriggerEvent() {
        this.event = null;
    }

    void setTrigger(TriggerDescriptor triggerd) {
        this.triggerd = triggerd;
    }

    void clearTrigger() throws StandardException {
        this.event = null;
        this.triggerd = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close(false);
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close(false);
            this.beforeResultSet = null;
        }
    }

    protected void cleanup(boolean cleanupOnError) throws StandardException {
        this.lcc.popTriggerExecutionContext(this);
        Enumeration e = this.resultSetVector.elements();
        while (e.hasMoreElements()) {
            ResultSet rs = (ResultSet)e.nextElement();
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        this.resultSetVector = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close(cleanupOnError);
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close(cleanupOnError);
            this.beforeResultSet = null;
        }
        this.lcc = null;
        this.cleanupCalled = true;
    }

    private void ensureProperContext() throws SQLException {
        if (this.cleanupCalled) {
            throw new SQLException(MessageService.getTextMessage("XCL31.S"), "XCL31", 20000);
        }
    }

    @Override
    public void validateStatement(ConstantAction constantAction) throws StandardException {
        if (constantAction instanceof DDLConstantAction) {
            throw StandardException.newException("X0Y69.S", (Object)this.triggerd.getName(), (Object)constantAction.toString());
        }
    }

    @Override
    public String getTargetTableName() {
        return this.targetTableName;
    }

    @Override
    public UUID getTargetTableId() {
        return this.targetTableId;
    }

    @Override
    public int getEventType() {
        return this.dmlType;
    }

    @Override
    public String getEventStatementText() {
        return this.statementText;
    }

    @Override
    public String[] getModifiedColumns() {
        return this.changedColNames;
    }

    @Override
    public boolean wasColumnModified(String columnName) {
        if (this.changedColNames == null) {
            return true;
        }
        for (int i = 0; i < this.changedColNames.length; ++i) {
            if (!this.changedColNames[i].equals(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasColumnModified(int columnNumber) {
        if (this.changedColIds == null) {
            return true;
        }
        for (int i = 0; i < this.changedColNames.length; ++i) {
            if (this.changedColIds[i] != columnNumber) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResultSet getOldRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.beforeResultSet == null) {
            return null;
        }
        try {
            CursorResultSet brs = this.beforeResultSet;
            if (brs instanceof TemporaryRowHolderResultSet) {
                brs = (CursorResultSet)((TemporaryRowHolderResultSet)brs).clone();
            } else if (brs instanceof TableScanResultSet) {
                brs = (CursorResultSet)((TableScanResultSet)brs).clone();
            }
            brs.open();
            ResultSet rs = this.cc.getResultSet(brs);
            this.resultSetVector.addElement(rs);
            return rs;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public ResultSet getNewRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.afterResultSet == null) {
            return null;
        }
        try {
            CursorResultSet ars = this.afterResultSet;
            if (ars instanceof TemporaryRowHolderResultSet) {
                ars = (CursorResultSet)((TemporaryRowHolderResultSet)ars).clone();
            } else if (ars instanceof TableScanResultSet) {
                ars = (CursorResultSet)((TableScanResultSet)ars).clone();
            }
            ars.open();
            ResultSet rs = this.cc.getResultSet(ars);
            this.resultSetVector.addElement(rs);
            return rs;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public ResultSet getOldRow() throws SQLException {
        ResultSet rs = this.getOldRowSet();
        if (rs != null) {
            rs.next();
        }
        return rs;
    }

    @Override
    public ResultSet getNewRow() throws SQLException {
        ResultSet rs = this.getNewRowSet();
        if (rs != null) {
            rs.next();
        }
        return rs;
    }

    public Long getAutoincrementValue(String identity) {
        Long value;
        if (this.aiHT != null && (value = (Long)this.aiHT.get(identity)) != null) {
            return value;
        }
        if (this.aiCounters != null) {
            for (int i = 0; i < this.aiCounters.size(); ++i) {
                AutoincrementCounter aic = (AutoincrementCounter)this.aiCounters.elementAt(i);
                if (!identity.equals(aic.getIdentity())) continue;
                return aic.getCurrentValue();
            }
        }
        return null;
    }

    public void copyHashtableToAIHT(Map from) {
        if (from == null) {
            return;
        }
        if (this.aiHT == null) {
            this.aiHT = new Hashtable();
        }
        this.aiHT.putAll(from);
    }

    public void resetAICounters(boolean begin) {
        if (this.aiCounters == null) {
            return;
        }
        this.afterRow = null;
        int size = this.aiCounters.size();
        for (int i = 0; i < size; ++i) {
            AutoincrementCounter aic = (AutoincrementCounter)this.aiCounters.elementAt(i);
            aic.reset(begin);
        }
    }

    public void updateAICounters() throws StandardException {
        if (this.aiCounters == null) {
            return;
        }
        int size = this.aiCounters.size();
        for (int i = 0; i < size; ++i) {
            AutoincrementCounter aic = (AutoincrementCounter)this.aiCounters.elementAt(i);
            DataValueDescriptor dvd = this.afterRow.getColumn(aic.getColumnPosition());
            aic.update(dvd.getLong());
        }
    }

    public String toString() {
        return this.triggerd.getName();
    }
}

