/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;

public class TableName
extends QueryTreeNode {
    String tableName;
    String schemaName;
    private boolean hasSchema;

    @Override
    public void init(Object schemaName, Object tableName) {
        this.hasSchema = schemaName != null;
        this.schemaName = (String)schemaName;
        this.tableName = (String)tableName;
    }

    @Override
    public void init(Object schemaName, Object tableName, Object tokBeginOffset, Object tokEndOffset) {
        this.init(schemaName, tableName);
        this.setBeginOffset((Integer)tokBeginOffset);
        this.setEndOffset((Integer)tokEndOffset);
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        this.hasSchema = schemaName != null;
    }

    public String getFullTableName() {
        return Misc.getFullTableName(this.schemaName, this.tableName, this.lcc);
    }

    public String getFullTableNameAsRegionPath() {
        return Misc.getRegionPath(this.schemaName, this.tableName, this.lcc);
    }

    @Override
    public String toString() {
        if (this.hasSchema) {
            return this.getFullTableName();
        }
        return this.tableName;
    }

    public boolean equals(TableName otherTableName) {
        if (otherTableName == null) {
            return false;
        }
        String fullTableName = this.getFullTableName();
        if (fullTableName == null) {
            return true;
        }
        if (this.schemaName == null || otherTableName.getSchemaName() == null) {
            return this.tableName.equals(otherTableName.getTableName());
        }
        return fullTableName.equals(otherTableName.getFullTableName());
    }

    public boolean equals(String otherSchemaName, String otherTableName) {
        String fullTableName = this.getFullTableName();
        if (fullTableName == null) {
            return true;
        }
        if (this.schemaName == null || otherSchemaName == null) {
            return this.tableName.equals(otherTableName);
        }
        return fullTableName.equals(otherSchemaName + "." + otherTableName);
    }

    public void bind(DataDictionary dataDictionary) throws StandardException {
        this.schemaName = this.getSchemaDescriptor(this.schemaName).getSchemaName();
    }

    public int hashCode() {
        return this.getFullTableName().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TableName)) {
            return false;
        }
        TableName that = (TableName)other;
        return this.getFullTableName().equals(that.getFullTableName());
    }
}

