/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributionDefinitionNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FKConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ModifyColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNodeVector;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class TableElementList
extends QueryTreeNodeVector {
    private int numColumns;
    private TableDescriptor td;

    public void addTableElement(TableElementNode tableElement) {
        this.addElement(tableElement);
        if (tableElement instanceof ColumnDefinitionNode || tableElement.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("");
        for (int index = 0; index < this.size(); ++index) {
            buffer.append(this.elementAt(index).toString()).append("\n");
        }
        return buffer.toString();
    }

    void setCollationTypesOnCharacterStringColumns(SchemaDescriptor sd) {
        int size = this.size();
        int collationType = sd.getCollationType();
        for (int index = 0; index < size; ++index) {
            ColumnDefinitionNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof ColumnDefinitionNode) || !(cdn = (ColumnDefinitionNode)this.elementAt(index)).getType().getTypeId().isStringTypeId()) continue;
            cdn.setCollationType(collationType);
        }
    }

    void validate(DDLStatementNode ddlStmt, DataDictionary dd, TableDescriptor td) throws StandardException {
        ConstraintDescriptorList cdl;
        this.td = td;
        int numAutoCols = 0;
        ArrayList<Integer> elementsToBeRemoved = new ArrayList<Integer>();
        int size = this.size();
        Hashtable columnHT = new Hashtable(size + 2, 0.999f);
        Hashtable constraintHT = new Hashtable(size + 2, 0.999f);
        Vector<Object> constraintsVector = new Vector<Object>();
        if (td != null && (cdl = dd.getConstraintDescriptors(td)) != null) {
            for (int i = 0; i < cdl.size(); ++i) {
                ConstraintDescriptor cd = cdl.elementAt(i);
                if (cd.getConstraintType() != 2 && cd.getConstraintType() != 3) continue;
                constraintsVector.addElement(cd);
            }
        }
        int tableType = 0;
        if (ddlStmt instanceof CreateTableNode) {
            tableType = ((CreateTableNode)ddlStmt).tableType;
        }
        for (int index = 0; index < size; ++index) {
            String dropConstraintName;
            TableElementNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (tableElement instanceof ColumnDefinitionNode) {
                cdn = (ColumnDefinitionNode)this.elementAt(index);
                if (tableType == 3 && (((ColumnDefinitionNode)cdn).getType().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)cdn).getType().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)cdn).getColumnName());
                }
                this.checkForDuplicateColumns(ddlStmt, columnHT, ((ColumnDefinitionNode)cdn).getColumnName());
                ((ColumnDefinitionNode)cdn).checkUserType(td);
                ((ColumnDefinitionNode)cdn).bindAndValidateDefault(dd, td);
                ((ColumnDefinitionNode)cdn).validateAutoincrement(dd, td, tableType);
                if (tableElement instanceof ModifyColumnNode) {
                    ModifyColumnNode mcdn = (ModifyColumnNode)cdn;
                    mcdn.checkExistingConstraints(td);
                    mcdn.useExistingCollation(td);
                } else if (((ColumnDefinitionNode)cdn).isAutoincrementColumn()) {
                    ++numAutoCols;
                }
            } else if (tableElement.getElementType() == 7) {
                String colName = tableElement.getName();
                if (td.getColumnDescriptor(colName) != null) break;
                throw StandardException.newException("42X14", (Object)colName, (Object)td.getQualifiedName());
            }
            if (!tableElement.hasConstraint()) continue;
            cdn = (ConstraintDefinitionNode)tableElement;
            try {
                ((ConstraintDefinitionNode)cdn).bind(ddlStmt, dd);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("X0Y46.S")) {
                    LanguageConnectionContext currentLcc = null;
                    try {
                        currentLcc = ConnectionUtil.getCurrentLCC();
                    }
                    catch (SQLException e) {
                        throw StandardException.newException(e.getSQLState(), e);
                    }
                    if (currentLcc.getDroppedFKConstraints() != null && currentLcc.getDroppedFKConstraints().contains(((ConstraintDefinitionNode)cdn).getConstraintMoniker())) {
                        elementsToBeRemoved.add(index);
                        continue;
                    }
                    throw se;
                }
                throw se;
            }
            if (((ConstraintDefinitionNode)cdn).getConstraintType() == 2 || ((ConstraintDefinitionNode)cdn).getConstraintType() == 3) {
                String destName = null;
                String[] destColumnNames = null;
                for (int i = 0; i < constraintsVector.size(); ++i) {
                    Object destConstraint = constraintsVector.elementAt(i);
                    if (destConstraint instanceof ConstraintDefinitionNode) {
                        ConstraintDefinitionNode destCDN = (ConstraintDefinitionNode)destConstraint;
                        destName = destCDN.getConstraintMoniker();
                        destColumnNames = destCDN.getColumnList().getColumnNames();
                    } else if (destConstraint instanceof ConstraintDescriptor) {
                        ConstraintDescriptor destCD = (ConstraintDescriptor)destConstraint;
                        destName = destCD.getConstraintName();
                        destColumnNames = destCD.getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)cdn).getColumnList().getColumnNames(), destColumnNames)) continue;
                    throw StandardException.newException("42Z93", (Object)((ConstraintDefinitionNode)cdn).getConstraintMoniker(), (Object)destName);
                }
                constraintsVector.addElement(cdn);
            }
            if (cdn instanceof ConstraintDefinitionNode) {
                this.checkForDuplicateConstraintNames(ddlStmt, constraintHT, ((ConstraintDefinitionNode)cdn).getConstraintMoniker());
            }
            if (((ConstraintDefinitionNode)cdn).getConstraintType() == 5 && (dropConstraintName = ((ConstraintDefinitionNode)cdn).getConstraintMoniker()) != null) {
                String dropSchemaName = ((ConstraintDefinitionNode)cdn).getDropSchemaName();
                SchemaDescriptor sd = dropSchemaName == null ? td.getSchemaDescriptor() : this.getSchemaDescriptor(dropSchemaName);
                ConstraintDescriptor cd = dd.getConstraintDescriptorByName(td, sd, dropConstraintName, false);
                if (cd == null) {
                    throw StandardException.newException("42X86", (Object)(sd.getSchemaName() + "." + dropConstraintName), (Object)td.getQualifiedName());
                }
                this.getCompilerContext().createDependency(cd);
            }
            if (((ConstraintDefinitionNode)cdn).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
                if (td == null) {
                    this.setColumnListToNotNull((ConstraintDefinitionNode)cdn);
                } else {
                    this.checkForNullColumns((ConstraintDefinitionNode)cdn, td);
                }
                this.checkForLOBOrUDTColumns((ConstraintDefinitionNode)cdn, td);
                continue;
            }
            if (((ConstraintDefinitionNode)cdn).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
                if (!dd.checkVersion(160, null)) {
                    this.checkForNullColumns((ConstraintDefinitionNode)cdn, td);
                }
                this.checkForLOBOrUDTColumns((ConstraintDefinitionNode)cdn, td);
                continue;
            }
            if (!((ConstraintDefinitionNode)cdn).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
        }
        if (numAutoCols > 1) {
            throw StandardException.newException("428C1");
        }
        int numElementsRemoved = 0;
        for (Integer i : elementsToBeRemoved) {
            this.removeElementAt(i - numElementsRemoved);
            ++numElementsRemoved;
        }
    }

    public int countConstraints(int constraintType) {
        int numConstraints = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDefinitionNode cdn;
            TableElementNode element = (TableElementNode)this.elementAt(index);
            if (!(element instanceof ConstraintDefinitionNode) || constraintType != (cdn = (ConstraintDefinitionNode)element).getConstraintType()) continue;
            ++numConstraints;
        }
        return numConstraints;
    }

    public int countNumberOfColumns() {
        return this.numColumns;
    }

    public int genColumnInfos(ColumnInfo[] colInfos) {
        int numConstraints = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((TableElementNode)this.elementAt(index)).getElementType() == 7) {
                String columnName = ((TableElementNode)this.elementAt(index)).getName();
                colInfos[index] = new ColumnInfo(columnName, this.td.getColumnDescriptor(columnName).getType(), null, null, null, null, 1, 0L, false, false, 0L, 0L);
                break;
            }
            if (!(this.elementAt(index) instanceof ColumnDefinitionNode)) {
                SanityManager.ASSERT((boolean)(this.elementAt(index) instanceof ConstraintDefinitionNode), (String)"elementAt(index) expected to be instanceof ConstraintDefinitionNode");
                ++numConstraints;
                continue;
            }
            ColumnDefinitionNode coldef = (ColumnDefinitionNode)this.elementAt(index);
            colInfos[index - numConstraints] = new ColumnInfo(coldef.getColumnName(), coldef.getType(), coldef.getDefaultValue(), coldef.getDefaultInfo(), null, coldef.getOldDefaultUUID(), coldef.getAction(), coldef.isAutoincrementColumn() ? coldef.getAutoincrementStart() : 0L, coldef.isAutoincrementColumn() ? coldef.hasAutoIncrementInc : false, coldef.isGeneratedByDefault() ? coldef.isGeneratedByDefault : false, coldef.isAutoincrementColumn() ? coldef.getAutoincrementIncrement() : 0L, coldef.isAutoincrementColumn() ? coldef.getAutoinc_create_or_modify_Start_Increment() : -1L);
            if (!coldef.hasConstraint()) continue;
            ++numConstraints;
        }
        return numConstraints;
    }

    public void appendNewColumnsToRCL(FromBaseTable table) throws StandardException {
        int size = this.size();
        ResultColumnList rcl = table.getResultColumns();
        TableName exposedName = table.getTableName();
        for (int index = 0; index < size; ++index) {
            if (!(this.elementAt(index) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode cdn = (ColumnDefinitionNode)this.elementAt(index);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, cdn.getColumnName(), exposedName, cdn.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, cdn.getType(), valueNode, this.getContextManager());
            resultColumn.setName(cdn.getColumnName());
            rcl.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable table = (FromBaseTable)fromList.elementAt(0);
        int size = this.size();
        CompilerContext cc = this.getCompilerContext();
        Vector aggregateVector = new Vector();
        for (int index = 0; index < size; ++index) {
            ConstraintDefinitionNode cdn;
            TableElementNode element = (TableElementNode)this.elementAt(index);
            if (!(element instanceof ConstraintDefinitionNode) || (cdn = (ConstraintDefinitionNode)element).getConstraintType() != 4) continue;
            ValueNode checkTree = cdn.getCheckCondition();
            int previousReliability = cc.getReliability();
            try {
                ProviderList apl = new ProviderList();
                ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.setReliability(1657);
                checkTree = checkTree.bindExpression(fromList, null, aggregateVector);
                if (aggregateVector.size() != 0) {
                    throw StandardException.newException("42Y01", cdn.getConstraintText());
                }
                checkTree = checkTree.checkIsBoolean();
                cdn.setCheckCondition(checkTree);
                if (apl.size() > 0) {
                    cdn.setAuxiliaryProviderList(apl);
                }
                cc.setCurrentAuxiliaryProviderList(prevAPL);
            }
            finally {
                cc.setReliability(previousReliability);
            }
            ResultColumnList rcl = table.getResultColumns();
            int numReferenced = rcl.countReferencedColumns();
            int[] checkColumnReferences = new int[numReferenced];
            rcl.recordColumnReferences(checkColumnReferences, 1);
            cdn.setCheckColumnReferences(checkColumnReferences);
            ResultColumnList refRCL = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            rcl.copyReferencedColumnsToNewList(refRCL);
            if (cdn.getColumnList() != null) {
                String colName = ((ResultColumn)cdn.getColumnList().elementAt(0)).getName();
                if (numReferenced > 1 || !colName.equals(((ResultColumn)refRCL.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", colName);
                }
            }
            cdn.setColumnList(refRCL);
            rcl.clearColumnReferences();
        }
    }

    void genConstraintActions(boolean forCreateTable, ConstraintConstantAction[] conActions, String tableName, SchemaDescriptor tableSd, DataDictionary dd) throws StandardException {
        int size = this.size();
        int conActionIndex = 0;
        for (int index = 0; index < size; ++index) {
            String[] columnNames = null;
            TableElementNode ten = (TableElementNode)this.elementAt(index);
            IndexConstantAction indexAction = null;
            if (!ten.hasConstraint() || ten instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDN = (ConstraintDefinitionNode)ten;
            if (constraintDN.getColumnList() != null) {
                columnNames = new String[constraintDN.getColumnList().size()];
                constraintDN.getColumnList().exportNames(columnNames);
            }
            int constraintType = constraintDN.getConstraintType();
            String constraintText = constraintDN.getConstraintText();
            String constraintName = constraintDN.getConstraintMoniker();
            if (constraintDN.requiresBackingIndex()) {
                if (constraintDN.constraintType == 3 && dd.checkVersion(160, null)) {
                    boolean contains_nullable_columns = this.areColumnsNullable(constraintDN, this.td);
                    boolean unique = !contains_nullable_columns;
                    boolean uniqueWithDuplicateNulls = contains_nullable_columns;
                    indexAction = this.genIndexAction(forCreateTable, unique, uniqueWithDuplicateNulls, null, constraintDN, columnNames, true, tableSd, tableName, constraintType, dd);
                } else {
                    indexAction = this.genIndexAction(forCreateTable, constraintDN.requiresUniqueIndex(), false, null, constraintDN, columnNames, true, tableSd, tableName, constraintType, dd);
                }
            }
            if (constraintType == 5) {
                SanityManager.ASSERT((!forCreateTable ? 1 : 0) != 0);
                conActions[conActionIndex] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(constraintName, constraintDN.getDropSchemaName(), tableName, this.td.getUUID(), tableSd.getSchemaName(), indexAction, constraintDN.getDropBehavior(), constraintDN.getVerifyType());
                continue;
            }
            ProviderList apl = constraintDN.getAuxiliaryProviderList();
            ConstraintInfo refInfo = null;
            ProviderInfo[] providerInfos = null;
            if (constraintDN instanceof FKConstraintDefinitionNode) {
                refInfo = ((FKConstraintDefinitionNode)constraintDN).getReferencedConstraintInfo();
            }
            if (apl != null && apl.size() > 0) {
                DependencyManager dm = dd.getDependencyManager();
                providerInfos = dm.getPersistentProviderInfos(apl);
            } else {
                providerInfos = new ProviderInfo[]{};
            }
            conActions[conActionIndex++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(constraintName, constraintType, forCreateTable, tableName, this.td != null ? this.td.getUUID() : (UUID)null, tableSd.getSchemaName(), columnNames, indexAction, constraintText, true, refInfo, providerInfos);
        }
    }

    private boolean columnsMatch(String[] columnNames1, String[] columnNames2) {
        boolean match = true;
        if (columnNames1.length != columnNames2.length) {
            return false;
        }
        int srcSize = columnNames1.length;
        int destSize = columnNames2.length;
        for (int srcCount = 0; srcCount < srcSize; ++srcCount) {
            match = false;
            for (int destCount = 0; destCount < destSize; ++destCount) {
                if (!columnNames1[srcCount].equals(columnNames2[destCount])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean forCreateTable, boolean isUnique, boolean isUniqueWithDuplicateNulls, String indexName, ConstraintDefinitionNode cdn, String[] columnNames, boolean isConstraint, SchemaDescriptor sd, String tableName, int constraintType, DataDictionary dd) throws StandardException {
        if (indexName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(constraintType).append("__").append(tableName);
            for (int cols = 0; cols < columnNames.length; ++cols) {
                sb.append("__" + columnNames[cols]);
            }
            indexName = sb.toString();
        }
        if (constraintType == 5) {
            if (forCreateTable) {
                SanityManager.THROWASSERT((String)"DROP INDEX with forCreateTable true");
            }
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, indexName, tableName, sd.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId(), false);
        }
        boolean[] isAscending = new boolean[columnNames.length];
        for (int i = 0; i < isAscending.length; ++i) {
            isAscending[i] = true;
        }
        Properties properties = null;
        properties = cdn.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(GfxdConstants.PROPERTY_CONSTRAINT_TYPE, Integer.toString(constraintType));
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(forCreateTable, isUnique, isUniqueWithDuplicateNulls, "LOCALSORTEDMAP", sd.getSchemaName(), indexName, tableName, this.td != null ? this.td.getUUID() : (UUID)null, columnNames, isAscending, isConstraint, cdn.getBackingIndexUUID(), properties);
    }

    private void checkForDuplicateColumns(DDLStatementNode ddlStmt, Hashtable ht, String colName) throws StandardException {
        String object = ht.put(colName, colName);
        if (object != null && ddlStmt instanceof CreateTableNode) {
            throw StandardException.newException("42X12", colName);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode ddlStmt, Hashtable ht, String constraintName) throws StandardException {
        if (constraintName == null) {
            return;
        }
        String object = ht.put(constraintName, constraintName);
        if (object != null && ddlStmt instanceof CreateTableNode) {
            throw StandardException.newException("42X91", constraintName);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode ddlStmt, ConstraintDefinitionNode cdn) throws StandardException {
        String invalidColName;
        if (ddlStmt instanceof CreateTableNode && (invalidColName = cdn.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", (Object)ddlStmt.getRelativeName(), (Object)invalidColName);
        }
        invalidColName = cdn.getColumnList().verifyUniqueNames(false);
        if (invalidColName != null) {
            throw StandardException.newException("42X92", invalidColName);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode cdn) {
        ResultColumnList rcl = cdn.getColumnList();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            String colName = ((ResultColumn)rcl.elementAt(index)).getName();
            this.findColumnDefinition(colName).setNullability(false);
        }
    }

    private boolean areColumnsNullable(ConstraintDefinitionNode cdn, TableDescriptor td) {
        ResultColumnList rcl = cdn.getColumnList();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            String colName = ((ResultColumn)rcl.elementAt(index)).getName();
            DataTypeDescriptor dtd = td == null ? this.getColumnDataTypeDescriptor(colName) : this.getColumnDataTypeDescriptor(colName, td);
            if (dtd == null || !dtd.isNullable()) continue;
            return true;
        }
        return false;
    }

    private void checkForNullColumns(ConstraintDefinitionNode cdn, TableDescriptor td) throws StandardException {
        ResultColumnList rcl = cdn.getColumnList();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            String colName = ((ResultColumn)rcl.elementAt(index)).getName();
            DataTypeDescriptor dtd = td == null ? this.getColumnDataTypeDescriptor(colName) : this.getColumnDataTypeDescriptor(colName, td);
            if (dtd == null || !dtd.isNullable()) continue;
            throw StandardException.newException("42831", colName);
        }
    }

    private void checkForLOBOrUDTColumns(ConstraintDefinitionNode cdn, TableDescriptor td) throws StandardException {
        ResultColumnList rcl = cdn.getColumnList();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            TypeId typeId;
            String colName = ((ResultColumn)rcl.elementAt(index)).getName();
            DataTypeDescriptor dtd = td == null ? this.getColumnDataTypeDescriptor(colName) : this.getColumnDataTypeDescriptor(colName, td);
            if (dtd == null || !(typeId = dtd.getTypeId()).isLOBTypeId() && !typeId.isXMLTypeId() && !typeId.isUserDefinedTypeId()) continue;
            throw StandardException.newException("42832", (Object)colName, (Object)typeId.getSQLTypeName());
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String colName) {
        ColumnDefinitionNode col = this.findColumnDefinition(colName);
        if (col != null) {
            return col.getType();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String colName, TableDescriptor td) {
        ColumnDescriptor cd = td.getColumnDescriptor(colName);
        if (cd != null) {
            return cd.getType();
        }
        return this.getColumnDataTypeDescriptor(colName);
    }

    public ColumnDefinitionNode findColumnDefinition(String colName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnDefinitionNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof ColumnDefinitionNode) || !colName.equals((cdn = (ColumnDefinitionNode)tableElement).getName())) continue;
            return cdn;
        }
        return null;
    }

    public ColumnDefinitionNode getFirstNonNullableColumn() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnDefinitionNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof ColumnDefinitionNode) || (cdn = (ColumnDefinitionNode)tableElement).getType().isNullable()) continue;
            return cdn;
        }
        return null;
    }

    public boolean containsColumnName(String colName) {
        return this.findColumnDefinition(colName) != null;
    }

    public DistributionDescriptor validateAndResolveDistributionPolicy() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof DistributionDefinitionNode)) continue;
            this.remove(index);
            return ((DistributionDefinitionNode)tableElement).bind(this, this.getDataDictionary());
        }
        SanityManager.THROWASSERT((String)"No partition definition node generated!");
        return null;
    }
}

