/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;

public class SystemColumnImpl
implements SystemColumn {
    private final String name;
    private final DataTypeDescriptor type;

    public static SystemColumn getColumn(String name, int jdbcTypeId, boolean nullability) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullability));
    }

    public static SystemColumn getColumn(String name, int jdbcTypeId, boolean nullability, int maxLength) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullability, maxLength));
    }

    static SystemColumn getIdentifierColumn(String name, boolean nullability) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, nullability, 128));
    }

    public static SystemColumn getUUIDColumn(String name, boolean nullability) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, nullability, 36));
    }

    static SystemColumn getIndicatorColumn(String name) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, false, 1));
    }

    static SystemColumn getJavaColumn(String name, String javaClassName, boolean nullability) throws StandardException {
        TypeId typeId = TypeId.getUserDefinedTypeId(javaClassName, false);
        DataTypeDescriptor dtd = new DataTypeDescriptor(typeId, nullability);
        return new SystemColumnImpl(name, dtd);
    }

    private SystemColumnImpl(String name, DataTypeDescriptor type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.type;
    }
}

