/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class SYSVIEWSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSVIEWS";
    protected static final int SYSVIEWS_COLUMN_COUNT = 4;
    protected static final int SYSVIEWS_TABLEID = 1;
    protected static final int SYSVIEWS_VIEWDEFINITION = 2;
    protected static final int SYSVIEWS_CHECKOPTION = 3;
    protected static final int SYSVIEWS_COMPILATION_SCHEMAID = 4;
    protected static final int SYSVIEWS_TABLEID_WIDTH = 36;
    protected static final int SYSVIEWS_INDEX1_ID = 0;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"8000004d-00d0-fd77-3ed8-000a0a0b1900", "80000050-00d0-fd77-3ed8-000a0a0b1900", "8000004f-00d0-fd77-3ed8-000a0a0b1900"};

    SYSVIEWSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String tableID = null;
        String compSchemaId = null;
        String viewText = null;
        String checkSType = null;
        if (td != null) {
            ViewDescriptor vd = (ViewDescriptor)td;
            UUID tableUUID = vd.getUUID();
            if (tableUUID == null) {
                tableUUID = this.getUUIDFactory().createUUID();
                vd.setUUID(tableUUID);
            }
            tableID = tableUUID.toString();
            viewText = vd.getViewText();
            int checkIType = vd.getCheckOptionType();
            if (checkIType != 0) {
                SanityManager.THROWASSERT((String)("checkIType expected to be 0, not " + checkIType));
            }
            checkSType = "N";
            UUID tmpId = vd.getCompSchemaId();
            compSchemaId = tmpId == null ? null : tmpId.toString();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(4);
        row.setColumn(1, new SQLChar(tableID));
        row.setColumn(2, this.dvf.getLongvarcharDataValue(viewText));
        row.setColumn(3, new SQLChar(checkSType));
        row.setColumn(4, new SQLChar(compSchemaId));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        ViewDescriptor vd = null;
        SanityManager.ASSERT((row.nColumns() == 4 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSVIEWS row");
        UUID compSchemaUUID = null;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String tableID = col.getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableID);
        col = row.getColumn(2);
        String viewDefinition = col.getString();
        col = row.getColumn(3);
        String checkSType = col.getString();
        if (!checkSType.equals("N")) {
            SanityManager.THROWASSERT((String)("checkSType expected to be 'N', not " + checkSType));
        }
        int checkIType = 0;
        col = row.getColumn(4);
        String compSchemaId = col.getString();
        if (compSchemaId != null) {
            compSchemaUUID = this.getUUIDFactory().recreateUUID(compSchemaId);
        }
        vd = ddg.newViewDescriptor(tableUUID, null, viewDefinition, checkIType, compSchemaUUID);
        return vd;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getColumn("VIEWDEFINITION", -1, false, 32700), SystemColumnImpl.getIndicatorColumn("CHECKOPTION"), SystemColumnImpl.getUUIDColumn("COMPILATIONSCHEMAID", true)};
    }
}

