/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TableKey;

class SPSNameCacheable
implements Cacheable {
    private TableKey identity;
    private SPSDescriptor spsd;
    private final DataDictionaryImpl dd;

    SPSNameCacheable(DataDictionaryImpl dd) {
        this.dd = dd;
    }

    @Override
    public void clearIdentity() {
        if (this.spsd != null) {
            this.dd.spsCacheEntryRemoved(this.spsd);
            if (SanityManager.DEBUG_ON((String)"SPSNameCacheTrace")) {
                System.out.println("SPSCACHE: clearIdentity() on " + this.spsd.getName());
            }
            this.spsd = null;
            this.identity = null;
        }
    }

    @Override
    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) {
        if (!(key instanceof TableKey)) {
            SanityManager.THROWASSERT((String)("Key for a SPSNameCacheElement is a " + key.getClass().getName() + " instead of a TableKey"));
        }
        if (!(createParameter instanceof SPSDescriptor)) {
            SanityManager.THROWASSERT((String)("Create parameter for a SPSNameCacheElement is a " + createParameter.getClass().getName() + "instead of a SPSDescriptorImpl"));
        }
        this.identity = (TableKey)key;
        this.spsd = (SPSDescriptor)createParameter;
        if (this.spsd != null) {
            if (SanityManager.DEBUG_ON((String)"SPSNameCacheTrace")) {
                System.out.println("SPSCACHE: createIdentity() on " + this.spsd.getName());
            }
            this.dd.spsCacheEntryAdded(this.spsd);
            try {
                this.spsd.loadGeneratedClass();
            }
            catch (StandardException e) {
                System.out.println("Error loading class for " + this.spsd.getName());
                System.out.println(e);
                e.printStackTrace();
            }
            return this;
        }
        return null;
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        if (!(key instanceof TableKey)) {
            SanityManager.THROWASSERT((String)("Key for a SPSNameCacheable Element is a " + key.getClass().getName() + " instead of a TableKey"));
        }
        this.identity = (TableKey)key;
        this.spsd = this.dd.getUncachedSPSDescriptor(this.identity);
        if (this.spsd != null) {
            if (SanityManager.DEBUG_ON((String)"SPSNameCacheTrace")) {
                System.out.println("SPSCACHE: setIdentity() on " + this.spsd.getName());
            }
            this.dd.spsCacheEntryAdded(this.spsd);
            try {
                this.spsd.loadGeneratedClass();
            }
            catch (StandardException e) {
                System.out.println("Error loading class for " + this.spsd.getName());
                System.out.println(e);
                e.printStackTrace();
            }
            return this;
        }
        return null;
    }

    @Override
    public void clean(boolean forRemove) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    public SPSDescriptor getSPSDescriptor() {
        return this.spsd;
    }

    private boolean checkConsistency(SPSDescriptor uncachedSpsd, Object identity, HeaderPrintWriter reportInconsistent) throws StandardException {
        boolean retval = true;
        if (uncachedSpsd == null) {
            reportInconsistent.println("Inconsistent SPSNameCacheable: identity = " + identity + ", uncached table descriptor not found.");
            retval = false;
        } else if (!(uncachedSpsd.getText().equals(this.spsd.getText()) && uncachedSpsd.getUsingText().equals(this.spsd.getUsingText()) && uncachedSpsd.getQualifiedName().equals(this.spsd.getQualifiedName()))) {
            reportInconsistent.println("Inconsistent SPSNameCacheable: identity = " + identity + ", cached  SPS = " + this.spsd + ", uncached SPS = " + uncachedSpsd);
            retval = false;
        }
        return retval;
    }
}

