/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.text.RuleBasedCollator;

public class SQLVarchar
extends SQLChar {
    @Override
    public String getTypeName() {
        return "VARCHAR";
    }

    @Override
    public DataValueDescriptor getClone() {
        try {
            return new SQLVarchar(this.getString());
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception", se);
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarchar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLVarchar s = new CollatorSQLVarchar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public int getTypeFormatId() {
        return 85;
    }

    public SQLVarchar() {
    }

    public SQLVarchar(String val) {
        super(val);
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, source.getString());
    }

    @Override
    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        int sourceWidth = sourceValue.length();
        if (sourceWidth > desiredWidth) {
            this.hasNonBlankChars(sourceValue, desiredWidth, sourceWidth);
            sourceValue = sourceValue.substring(0, desiredWidth);
        }
        this.setValue(sourceValue);
    }

    @Override
    public int typePrecedence() {
        return 10;
    }

    @Override
    protected final int growBy() {
        return 4096;
    }

    @Override
    public byte getTypeId() {
        return 42;
    }

    static final String getAsString(byte[] inBytes, int offset, int columnWidth) {
        char[] chars = new char[columnWidth];
        int strlen = SQLVarchar.readIntoCharsFromByteArray(inBytes, offset, columnWidth, chars);
        if (columnWidth == strlen) {
            return ClientSharedUtils.newWrappedString((char[])chars, (int)0, (int)strlen);
        }
        assert (columnWidth > strlen) : "width=" + columnWidth + ", len=" + strlen;
        char[] trimmed = new char[strlen];
        System.arraycopy(chars, 0, trimmed, 0, strlen);
        return ClientSharedUtils.newWrappedString((char[])trimmed, (int)0, (int)strlen);
    }

    static final String getAsString(long memOffset, int columnWidth, OffHeapByteSource bs) {
        char[] chars = new char[columnWidth];
        int strlen = SQLVarchar.readIntoCharsFromByteSource(UnsafeHolder.getUnsafe(), memOffset, columnWidth, bs, chars);
        if (columnWidth == strlen) {
            return ClientSharedUtils.newWrappedString((char[])chars, (int)0, (int)strlen);
        }
        assert (columnWidth > strlen) : "width=" + columnWidth + ", len=" + strlen;
        char[] trimmed = new char[strlen];
        System.arraycopy(chars, 0, trimmed, 0, strlen);
        return ClientSharedUtils.newWrappedString((char[])trimmed, (int)0, (int)strlen);
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        int index;
        char[] data;
        assert (!this.isNull());
        try {
            data = this.getCharArray(true);
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception", se);
        }
        int strlen = this.rawLength != -1 ? this.rawLength : data.length;
        for (index = strlen - 1; index >= 0 && data[index] == ' '; --index) {
        }
        hash = ResolverUtils.getComputeHashOfCharArrayData((int)hash, (int)(index + 1), (char[])data, (int)this.getTypeFormatId());
        return hash;
    }
}

