/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.JSONFormatterException;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.internal.PdxInstanceImpl;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class JSON
extends SQLClob {
    byte[] jsonPdxInstanceBytes = null;

    public JSON() {
    }

    public JSON(String val) throws StandardException {
        this.setValue(val);
    }

    @Override
    public String getTypeName() {
        return "JSON";
    }

    @Override
    public int getTypeFormatId() {
        return 478;
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.rawLength = -1;
        if (theValue != null) {
            PdxInstance jsonPdxInstance1 = null;
            try {
                jsonPdxInstance1 = JSONFormatter.fromJSON((String)theValue);
            }
            catch (JSONFormatterException je) {
                String s = theValue;
                if (theValue.length() > 255) {
                    s = theValue.substring(0, 255);
                }
                throw StandardException.newException("22029", je, (Object)s, (Object)255);
            }
            this.jsonPdxInstanceBytes = ((PdxInstanceImpl)jsonPdxInstance1).toBytes();
        } else {
            this.jsonPdxInstanceBytes = null;
        }
        this.rawData = null;
    }

    public byte[] getPdxInstanceBytes() {
        return this.jsonPdxInstanceBytes;
    }

    public PdxInstance getPdxInstance() {
        byte[] jsonBytes = this.jsonPdxInstanceBytes;
        return jsonBytes != null ? InternalDataSerializer.readPdxInstance((byte[])jsonBytes, (GemFireCacheImpl)GemFireCacheImpl.getForPdx((String)"Could not read PdxInstance bytes")) : null;
    }

    @Override
    public String getString() {
        byte[] jsonBytes = this.jsonPdxInstanceBytes;
        if (jsonBytes != null) {
            PdxInstance jPdxInstance = InternalDataSerializer.readPdxInstance((byte[])jsonBytes, (GemFireCacheImpl)GemFireCacheImpl.getForPdx((String)"Could not read PdxInstance bytes"));
            return JSONFormatter.toJSON((PdxInstance)jPdxInstance);
        }
        return null;
    }

    @Override
    public Object getObject() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return this;
    }

    @Override
    public void setObject(Object obj) throws StandardException {
        this.setValue(((JSON)obj).getString());
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new JSON();
    }

    @Override
    public DataValueDescriptor getClone() {
        try {
            return new JSON(this.getString());
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception", se);
        }
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        switch (theValue.getTypeFormatId()) {
            case 478: {
                this.jsonPdxInstanceBytes = ((JSON)theValue).getPdxInstanceBytes();
                break;
            }
            default: {
                this.setValue(theValue.getString());
            }
        }
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.setFrom(source);
    }

    @Override
    final void writeData(DataOutput out, boolean createArray) throws IOException {
        this.toDataForOptimizedResultHolder(out);
    }

    @Override
    final void readData(DataInput in, boolean reuseArrayIfPossible) throws IOException {
        int length = in.readUnsignedShort();
        byte[] b = new byte[length];
        in.readFully(b);
        try {
            this.setValue(new String(b));
        }
        catch (StandardException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isNull = this.isNull();
        out.writeBoolean(isNull);
        if (!isNull) {
            this.toDataForOptimizedResultHolder(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        boolean isNull = in.readBoolean();
        if (!isNull) {
            this.fromDataForOptimizedResultHolder(in);
            return;
        }
        this.setToNull();
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            this.toDataForOptimizedResultHolder(out);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromData(DataInput in) throws IOException {
        this.fromDataForOptimizedResultHolder(in);
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeInt(this.jsonPdxInstanceBytes.length);
        dos.write(this.jsonPdxInstanceBytes);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException {
        int length = dis.readInt();
        this.jsonPdxInstanceBytes = new byte[length];
        dis.readFully(this.jsonPdxInstanceBytes);
    }

    @Override
    public byte getTypeId() {
        return 103;
    }

    @Override
    public final boolean isNull() {
        return this.jsonPdxInstanceBytes == null;
    }

    @Override
    public void restoreToNull() {
        this.jsonPdxInstanceBytes = null;
    }

    @Override
    public int getLength() {
        if (!this.isNull()) {
            return this.jsonPdxInstanceBytes.length;
        }
        return 0;
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) {
        return this.getLength();
    }

    @Override
    public int writeBytes(byte[] bytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        System.arraycopy(this.jsonPdxInstanceBytes, 0, bytes, offset, this.jsonPdxInstanceBytes.length);
        return this.jsonPdxInstanceBytes.length;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        assert (inBytes.length == columnWidth);
        this.jsonPdxInstanceBytes = new byte[columnWidth];
        System.arraycopy(inBytes, offset, this.jsonPdxInstanceBytes, 0, columnWidth);
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        this.jsonPdxInstanceBytes = new byte[columnWidth];
        UnsafeMemoryChunk.readUnsafeBytes((long)memOffset, (byte[])this.jsonPdxInstanceBytes, (int)columnWidth);
        return columnWidth;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNull()) {
            sb.append("NULL");
            return sb.toString();
        }
        String str = this.getString();
        if (str.length() > 4096) {
            sb.append("string value(first 4096 chars)=");
            sb.append(str.substring(0, 4096));
            sb.append("...<clipped>");
        } else {
            sb.append(str);
        }
        return sb.toString();
    }
}

