/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import io.snappydata.thrift.BlobChunk;
import io.snappydata.thrift.common.BufferedBlob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;

public class HarmonySerialBlob
implements Blob,
BufferedBlob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8144641928112860441L;
    private byte[] buf;
    private int len;

    public HarmonySerialBlob(byte[] buf) {
        this.buf = new byte[buf.length];
        this.len = buf.length;
        System.arraycopy(buf, 0, this.buf, 0, this.len);
    }

    public HarmonySerialBlob(OffHeapByteSource ohbs) {
        this.buf = ohbs.getRowBytes();
        this.len = this.buf.length;
    }

    private HarmonySerialBlob(byte[] buf, int len) {
        this.buf = buf;
        this.len = len;
    }

    public static HarmonySerialBlob wrapBytes(byte[] buf) {
        return new HarmonySerialBlob(buf, buf.length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidation();
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkValidation();
        if (pos < 1L || pos > (long)(this.len + 1)) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(pos)});
        }
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Integer(length)});
        }
        if ((long)length > (long)this.len - pos + 1L) {
            length = (int)((long)this.len - pos + 1L);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.buf, (int)pos - 1, copiedArray, 0, length);
        return copiedArray;
    }

    @Override
    public long length() throws SQLException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkValidation();
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkValidation();
        if (start < 1L || (long)this.len - (start - 1L) < (long)pattern.length) {
            return -1L;
        }
        for (int i = (int)(start - 1L); i <= this.len - pattern.length; ++i) {
            if (!this.match(this.buf, i, pattern)) continue;
            return i + 1;
        }
        return -1L;
    }

    private boolean match(byte[] bytes, int start, byte[] subBytes) {
        int i = 0;
        while (i < subBytes.length) {
            if (bytes[start++] == subBytes[i++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkValidation();
        throw Util.generateCsSQLException("0A000.S", "SerialBlob: setBinaryStream");
    }

    @Override
    public int setBytes(long pos, byte[] theBytes) throws SQLException {
        return this.setBytes(pos, theBytes, 0, theBytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] theBytes, int offset, int length) throws SQLException {
        this.checkValidation();
        if (pos < 1L || length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(pos)});
        }
        if (pos > (long)(this.len + 1)) {
            throw HarmonySerialBlob.makeSQLException("XJ076.S", new Object[]{new Long(pos)});
        }
        if (offset < 0 || length < 0 || offset > theBytes.length - length) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", new Object[]{new Integer(offset)});
        }
        if (pos > (long)(this.len - length + 1)) {
            long newLen = (long)length + pos - 1L;
            if (newLen > Integer.MAX_VALUE) {
                throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{newLen});
            }
            byte[] newBuf = new byte[(int)newLen];
            System.arraycopy(this.buf, 0, newBuf, 0, this.len);
            this.buf = newBuf;
            this.len = (int)newLen;
        }
        System.arraycopy(theBytes, offset, this.buf, (int)pos - 1, length);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.checkValidation();
        if (length > (long)this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{new Long(this.len)});
        }
        if (length < (long)this.len) {
            this.buf = this.getBytes(1L, (int)length);
            this.len = (int)length;
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1) {
            this.len = -1;
            this.buf = null;
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkValidation();
        if (this.len < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Long(this.len)});
        }
        if (length < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Long(length)});
        }
        if (pos < 1L || pos + length > (long)this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ087.S", new Object[]{new Long(pos), new Long(length)});
        }
        return new ByteArrayInputStream(this.buf, (int)(pos - 1L), (int)length);
    }

    public static SQLException makeSQLException(String messageID, Object[] args) {
        StandardException se = StandardException.newException(messageID, args);
        return new SQLException(se.getMessage(), se.getSQLState());
    }

    public BlobChunk getAsLastChunk() throws SQLException {
        return new BlobChunk(ByteBuffer.wrap(this.buf, 0, this.len), true);
    }

    private void checkValidation() throws SQLException {
        if (this.len == -1) {
            throw HarmonySerialBlob.makeSQLException("XJ215.S", null);
        }
    }
}

