/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

public class StatementSchemaPermission
extends StatementPermission {
    private String schemaName;
    private String aid;
    private int privType;

    public StatementSchemaPermission(String schemaName, String aid, int privType) {
        this.schemaName = schemaName;
        this.aid = aid;
        this.privType = privType;
    }

    @Override
    public void check(LanguageConnectionContext lcc, String authid, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        switch (this.privType) {
            case 17: 
            case 18: {
                SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, false);
                if (sd == null) {
                    return;
                }
                String schemaAuthId = sd.getAuthorizationId();
                if (Misc.checkLDAPGroupOwnership(this.schemaName, schemaAuthId, authid) || authid.equals(schemaAuthId)) break;
                throw StandardException.newException("42507", (Object)authid, (Object)this.schemaName);
            }
            case 16: {
                if (this.schemaName.equals(authid) && (this.aid == null || this.aid.equals(authid))) break;
                throw StandardException.newException("42508", (Object)authid, (Object)this.schemaName);
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected value (" + this.privType + ") for privType"));
            }
        }
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return null;
    }
}

