/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoutinePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID routineUUID) {
        this.routineUUID = routineUUID;
    }

    @Override
    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        if (!dd.bypassRoutineAuthorization(this.routineUUID)) {
            StatementRoutinePermission.check(this.routineUUID, authorizationId, forGrant, dd, tc);
        }
    }

    public static void check(UUID routineUUID, String authorizationId, boolean forGrant, DataDictionary dd, TransactionController tc) throws StandardException {
        RoutinePermsDescriptor perms = dd.getRoutinePermissions(routineUUID, authorizationId);
        if (perms == null || !perms.getHasExecutePermission()) {
            perms = dd.getRoutinePermissions(routineUUID, "PUBLIC");
        }
        if (perms == null || !perms.getHasExecutePermission()) {
            AliasDescriptor ad = dd.getAliasDescriptor(routineUUID);
            if (ad == null) {
                throw StandardException.newException("4250E", "routine");
            }
            SchemaDescriptor sd = dd.getSchemaDescriptor(ad.getSchemaUUID(), tc);
            if (sd == null) {
                throw StandardException.newException("4250E", "schema");
            }
            throw StandardException.newException(forGrant ? "42505" : "42504", authorizationId, (Object)ad.getDescriptorType(), (Object)"", (Object)sd.getSchemaName(), (Object)ad.getDescriptorName());
        }
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return dd.getRoutinePermissions(this.routineUUID, authid);
    }
}

