/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.IndexDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.IndexDescriptorImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IndexRowGenerator
implements IndexDescriptor,
Formatable {
    private IndexDescriptor id;
    private ExecutionFactory ef;

    public IndexRowGenerator(String indexType, boolean isUnique, int[] baseColumnPositions, boolean[] isAscending, int numberOfOrderedColumns) {
        this.id = new IndexDescriptorImpl(indexType, isUnique, false, baseColumnPositions, isAscending, numberOfOrderedColumns);
        SanityManager.ASSERT((baseColumnPositions != null ? 1 : 0) != 0, (String)"baseColumnPositions are null");
    }

    public IndexRowGenerator(String indexType, boolean isUnique, boolean isUniqueWithDuplicateNulls, int[] baseColumnPositions, boolean[] isAscending, int numberOfOrderedColumns) {
        this.id = new IndexDescriptorImpl(indexType, isUnique, isUniqueWithDuplicateNulls, baseColumnPositions, isAscending, numberOfOrderedColumns);
        SanityManager.ASSERT((baseColumnPositions != null ? 1 : 0) != 0, (String)"baseColumnPositions are null");
    }

    public IndexRowGenerator(IndexDescriptor indexDescriptor) {
        this.id = indexDescriptor;
    }

    public ExecIndexRow getIndexRowTemplate() {
        return this.getExecutionFactory().getIndexableRow(this.id.baseColumnPositions().length + 1);
    }

    public void getIndexRow(ExecRow baseRow, RowLocation rowLocation, ExecIndexRow indexRow, FormatableBitSet bitSet) throws StandardException {
        int[] baseColumnPositions = this.id.baseColumnPositions();
        int colCount = baseColumnPositions.length;
        if (bitSet == null) {
            for (int i = 0; i < colCount; ++i) {
                indexRow.setColumn(i + 1, baseRow.getColumn(baseColumnPositions[i]));
            }
        } else {
            SanityManager.ASSERT((!bitSet.get(0) ? 1 : 0) != 0, (String)"element zero of the bitSet passed into getIndexRow() is not false, bitSet should be 1 based");
            for (int i = 0; i < colCount; ++i) {
                int fullColumnNumber = baseColumnPositions[i];
                int partialColumnNumber = 0;
                for (int index = 1; index <= fullColumnNumber; ++index) {
                    if (!bitSet.get(index)) continue;
                    ++partialColumnNumber;
                }
                indexRow.setColumn(i + 1, baseRow.getColumn(partialColumnNumber));
            }
        }
        indexRow.setColumn(colCount + 1, rowLocation);
    }

    public int[] getColumnCollationIds(ColumnDescriptorList columnList) throws StandardException {
        int[] base_cols = this.id.baseColumnPositions();
        int[] collation_ids = new int[base_cols.length + 1];
        for (int i = 0; i < base_cols.length; ++i) {
            collation_ids[i] = columnList.elementAt(base_cols[i] - 1).getType().getCollationType();
        }
        collation_ids[collation_ids.length - 1] = 0;
        return collation_ids;
    }

    public IndexDescriptor getIndexDescriptor() {
        return this.id;
    }

    public IndexRowGenerator() {
    }

    @Override
    public boolean isUniqueWithDuplicateNulls() {
        return this.id.isUniqueWithDuplicateNulls();
    }

    @Override
    public boolean isUnique() {
        return this.id.isUnique();
    }

    @Override
    public int[] baseColumnPositions() {
        return this.id.baseColumnPositions();
    }

    @Override
    public Integer getKeyColumnPosition(Integer heapColumnPosition) {
        return this.id.getKeyColumnPosition(heapColumnPosition);
    }

    @Override
    public int getKeyColumnPosition(int heapColumnPosition) {
        return this.id.getKeyColumnPosition(heapColumnPosition);
    }

    @Override
    public int numberOfOrderedColumns() {
        return this.id.numberOfOrderedColumns();
    }

    @Override
    public String indexType() {
        return this.id.indexType();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean isAscending(Integer keyColumnPosition) {
        return this.id.isAscending(keyColumnPosition);
    }

    @Override
    public boolean isDescending(Integer keyColumnPosition) {
        return this.id.isDescending(keyColumnPosition);
    }

    @Override
    public boolean[] isAscending() {
        return this.id.isAscending();
    }

    @Override
    public void setBaseColumnPositions(int[] baseColumnPositions) {
        this.id.setBaseColumnPositions(baseColumnPositions);
    }

    @Override
    public void setIsAscending(boolean[] isAscending) {
        this.id.setIsAscending(isAscending);
    }

    @Override
    public void setNumberOfOrderedColumns(int numberOfOrderedColumns) {
        this.id.setNumberOfOrderedColumns(numberOfOrderedColumns);
    }

    public boolean equals(Object other) {
        return this.id.equals(other);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private ExecutionFactory getExecutionFactory() {
        if (this.ef == null) {
            ExecutionContext ec = (ExecutionContext)ContextService.getContext("ExecutionContext");
            this.ef = ec.getExecutionFactory();
        }
        return this.ef;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (IndexDescriptor)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
    }

    @Override
    public int getTypeFormatId() {
        return 268;
    }
}

