/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.KeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConstraintDescriptorList
extends CopyOnWriteArrayList {
    private boolean scanned;

    public void setScanned(boolean scanned) {
        this.scanned = scanned;
    }

    public boolean getScanned() {
        return this.scanned;
    }

    public ConstraintDescriptor getConstraintDescriptor(UUID indexUUID) {
        ConstraintDescriptor retCD = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            KeyConstraintDescriptor keyCD;
            ConstraintDescriptor cd = this.elementAt(index);
            if (!(cd instanceof KeyConstraintDescriptor) || !(keyCD = (KeyConstraintDescriptor)cd).getIndexId().equals(indexUUID)) continue;
            retCD = cd;
            break;
        }
        return retCD;
    }

    public ConstraintDescriptor getConstraintDescriptorById(UUID uuid) {
        ConstraintDescriptor returnCD = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (!cd.getUUID().equals(uuid)) continue;
            returnCD = cd;
            break;
        }
        return returnCD;
    }

    public ConstraintDescriptor dropConstraintDescriptorById(UUID uuid) {
        ConstraintDescriptor cd = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            cd = this.elementAt(index);
            if (!cd.getUUID().equals(uuid)) continue;
            this.remove(cd);
            break;
        }
        return cd;
    }

    public ConstraintDescriptor getConstraintDescriptorByName(SchemaDescriptor sd, String name) {
        ConstraintDescriptor retCD = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (!cd.getConstraintName().equals(name) || sd != null && !sd.equals(cd.getSchemaDescriptor())) continue;
            retCD = cd;
            break;
        }
        return retCD;
    }

    public ReferencedKeyConstraintDescriptor getPrimaryKey() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (cd.getConstraintType() != 2) continue;
            return (ReferencedKeyConstraintDescriptor)cd;
        }
        return null;
    }

    public ConstraintDescriptorList getConstraintDescriptorList(boolean enabled) {
        ConstraintDescriptorList cdl = new ConstraintDescriptorList();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor cd = this.elementAt(index);
            if (cd.isEnabled() != enabled) continue;
            cdl.add(cd);
        }
        return cdl;
    }

    public ConstraintDescriptor elementAt(int n) {
        return (ConstraintDescriptor)this.get(n);
    }

    public ConstraintDescriptorList getSubList(int type) {
        ConstraintDescriptor cd = null;
        ConstraintDescriptorList cdl = new ConstraintDescriptorList();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            cd = this.elementAt(index);
            if (cd.getConstraintType() != type) continue;
            cdl.add(cd);
        }
        return cdl;
    }
}

