/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.property;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PersistentSet;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyUtil {
    public static final String[] servicePropertyList = new String[]{"gemfirexd.engineType", "gemfirexd.distributedsystem.noAutoBoot", "gemfirexd.storage.tempDirectory", "encryptionProvider", "encryptionAlgorithm", "restoreFrom", "logDevice", "gemfirexd.storage.logArchiveMode"};
    public static final int SET_IN_JVM = 0;
    public static final int SET_IN_DATABASE = 1;
    public static final int SET_IN_APPLICATION = 2;
    public static final int NOT_SET = -1;
    public static boolean isSQLFire = false;

    public static int whereSet(String key, Dictionary set) {
        boolean dbOnly = PropertyUtil.isDBOnly(set);
        if (!dbOnly && Monitor.getMonitor().getJVMProperty(key) != null) {
            return 0;
        }
        if (set != null && set.get(key) != null) {
            return 1;
        }
        if (!dbOnly && PropertyUtil.getSystemProperty(key) != null) {
            return 2;
        }
        return -1;
    }

    public static boolean isDBOnly(Dictionary set) {
        if (set == null) {
            return false;
        }
        String value = (String)set.get("gemfirexd.distributedsystem.propertiesOnly");
        boolean dbOnly = Boolean.valueOf(value != null ? value.trim() : value);
        return dbOnly;
    }

    public static boolean isDBOnly(Properties set) {
        if (set == null) {
            return false;
        }
        String value = set.getProperty("gemfirexd.distributedsystem.propertiesOnly");
        boolean dbOnly = Boolean.valueOf(value != null ? value.trim() : value);
        return dbOnly;
    }

    public static String getSystemProperty(String key) {
        return PropertyUtil.getSystemProperty(key, null);
    }

    public static Object setSystemProperty(String key, Object value) {
        ModuleFactory monitor = Monitor.getMonitorLite();
        if (monitor.getApplicationProperties() != null) {
            return monitor.getApplicationProperties().put(key, value);
        }
        return monitor.setJVMProperty(key, (String)value);
    }

    public static Object clearSystemProperty(String key) {
        ModuleFactory monitor = Monitor.getMonitorLite();
        if (monitor.getApplicationProperties() != null) {
            return monitor.getApplicationProperties().remove(key);
        }
        return monitor.clearJVMProperty(key);
    }

    public static final boolean getBooleanProperty(String propName, String sysPropName, Properties info, boolean def, ModuleFactory monitor) {
        String infoVal = PropertyUtil.findAndGetProperty(info, propName, sysPropName, monitor);
        return infoVal == null ? def : infoVal.equalsIgnoreCase("true");
    }

    public static String findAndGetProperty(Properties set, String key, String systemKey) {
        return PropertyUtil.findAndGetProperty(set, key, systemKey, null);
    }

    public static Map<String, String> findAndGetPropertiesWithPrefix(Properties set, String keyNamePrefix) {
        Set<String> keys = set.stringPropertyNames();
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String key : keys) {
            if (!key.startsWith(keyNamePrefix)) continue;
            mappings.put(key, set.getProperty(key));
        }
        return mappings;
    }

    public static String findAndGetProperty(Properties set, String key, String systemKey, ModuleFactory monitor) {
        Properties fileProps;
        String value;
        ModuleFactory monitorLite = monitor;
        if (monitor == null) {
            monitor = Monitor.getMonitor();
        }
        String string = value = systemKey != null ? monitor.getJVMProperty(systemKey) : null;
        if (value != null && value.trim().length() > 0) {
            return value;
        }
        if (set != null && (value = set.getProperty(key)) != null && value.trim().length() > 0) {
            return value;
        }
        if (monitorLite == null) {
            monitorLite = Monitor.getMonitorLite();
        }
        if ((fileProps = monitorLite.getApplicationProperties()) != null) {
            value = fileProps.getProperty(key);
        }
        return value;
    }

    public static String getSystemProperty(String key, String defaultValue) {
        Properties applicationProperties;
        ModuleFactory monitor = Monitor.getMonitorLite();
        String value = monitor.getJVMProperty(key);
        if (value == null && (applicationProperties = monitor.getApplicationProperties()) != null) {
            value = applicationProperties.getProperty(key);
        }
        return value == null ? defaultValue : value;
    }

    public static String getPropertyFromSet(Properties set, String key) {
        boolean dbOnly = set != null ? PropertyUtil.isDBOnly(set) : false;
        return PropertyUtil.getPropertyFromSet(dbOnly, set, key);
    }

    public static Serializable getPropertyFromSet(Dictionary set, String key) {
        boolean dbOnly = set != null ? PropertyUtil.isDBOnly(set) : false;
        return PropertyUtil.getPropertyFromSet(dbOnly, set, key);
    }

    public static Serializable getPropertyFromSet(boolean dbOnly, Dictionary set, String key) {
        if (set != null) {
            Object value;
            if (!dbOnly && (value = Monitor.getMonitor().getJVMProperty(key)) != null) {
                return value;
            }
            value = (Serializable)set.get(key);
            if (value != null) {
                return value;
            }
            if (dbOnly) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(key);
    }

    public static String getPropertyFromSet(boolean dbOnly, Properties set, String key) {
        if (set != null) {
            String value;
            if (!dbOnly && (value = Monitor.getMonitor().getJVMProperty(key)) != null) {
                return value;
            }
            value = set.getProperty(key);
            if (value != null) {
                return value;
            }
            if (dbOnly) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(key);
    }

    public static String getDatabaseProperty(PersistentSet set, String key) throws StandardException {
        if (set == null) {
            return null;
        }
        Serializable obj = set.getProperty(key);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static String getServiceProperty(PersistentSet set, String key, String defaultValue) throws StandardException {
        String value = PropertyUtil.getDatabaseProperty(set, "gemfirexd.distributedsystem.propertiesOnly");
        boolean dbOnly = Boolean.valueOf(value != null ? value.trim() : value);
        if (!dbOnly && (value = Monitor.getMonitor().getJVMProperty(key)) != null) {
            return value;
        }
        value = PropertyUtil.getDatabaseProperty(set, key);
        if (value != null) {
            return value;
        }
        if (dbOnly) {
            return defaultValue;
        }
        return PropertyUtil.getSystemProperty(key, defaultValue);
    }

    public static String getServiceProperty(PersistentSet set, String key) throws StandardException {
        return PropertyUtil.getServiceProperty(set, key, null);
    }

    public static boolean getSystemBoolean(String key) {
        return PropertyUtil.getSystemBoolean(key, false);
    }

    public static boolean getSystemBoolean(String key, boolean defaultValue) {
        String value = PropertyUtil.getSystemProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value.trim());
    }

    public static boolean getServiceBoolean(PersistentSet set, String key, boolean defValue) throws StandardException {
        String value = PropertyUtil.getServiceProperty(set, key);
        return PropertyUtil.booleanProperty(key, (Serializable)((Object)value), defValue);
    }

    public static int getSystemInt(String key, int min, int max, int defaultValue) {
        return PropertyUtil.handleInt(PropertyUtil.getSystemProperty(key), min, max, defaultValue);
    }

    public static int getServiceInt(PersistentSet set, String key, int min, int max, int defaultValue) throws StandardException {
        return PropertyUtil.handleInt(PropertyUtil.getServiceProperty(set, key), min, max, defaultValue);
    }

    public static int getServiceInt(PersistentSet set, Properties props, String key, int min, int max, int defaultValue) throws StandardException {
        String value = null;
        if (props != null) {
            value = props.getProperty(key);
        }
        if (value == null) {
            value = PropertyUtil.getServiceProperty(set, key);
        }
        return PropertyUtil.handleInt(value, min, max, defaultValue);
    }

    public static int getSystemInt(String key, int defaultValue) {
        return PropertyUtil.getSystemInt(key, 0, Integer.MAX_VALUE, defaultValue);
    }

    public static int handleInt(String value, int min, int max, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue >= min && intValue <= max) {
                return intValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean booleanProperty(String p, Serializable v, boolean defaultValue) throws StandardException {
        if (v == null) {
            return defaultValue;
        }
        String vS = ((String)((Object)v)).trim();
        if ("TRUE".equals(StringUtil.SQLToUpperCase(vS))) {
            return true;
        }
        if ("FALSE".equals(StringUtil.SQLToUpperCase(vS))) {
            return false;
        }
        throw StandardException.newException("XCY00.S", (Object)p, (Object)vS);
    }

    public static int intPropertyValue(String p, Serializable v, int minValue, int maxValue, int defaultValue) throws StandardException {
        if (v == null) {
            return defaultValue;
        }
        String vs = ((String)((Object)v)).trim();
        try {
            int result = Integer.parseInt(vs);
            if (result < minValue || result > maxValue) {
                throw StandardException.newException("XCY00.S", (Object)p, (Object)vs);
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("XCY00.S", (Object)p, (Object)vs);
        }
    }

    public static boolean isServiceProperty(String key) {
        for (int i = 0; i < servicePropertyList.length; ++i) {
            if (!key.equals(servicePropertyList[i])) continue;
            return true;
        }
        return false;
    }

    public static final void setSQLFire() {
        isSQLFire = true;
    }
}

