/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.types;

import com.pivotal.gemfirexd.internal.engine.types.SqlXmlHelper;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;

public final class SqlXmlHelperFactory {
    private static final boolean useSun5 = SqlXmlHelperFactory.sun5XalanClasses();

    public static final SqlXmlHelper newInstance() throws StandardException {
        try {
            if (useSun5) {
                return (SqlXmlHelper)Class.forName("com.pivotal.gemfirexd.internal.engine.types.SqlXmlHelperSun5").newInstance();
            }
            return (SqlXmlHelper)Class.forName("com.pivotal.gemfirexd.internal.engine.types.SqlXmlHelperXalan").newInstance();
        }
        catch (InstantiationException ie) {
            throw StandardException.newException("XML01", (Throwable)ie, (Object)ie.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            throw StandardException.newException("XML01", (Throwable)iae, (Object)iae.getLocalizedMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw StandardException.newException("XML00", "SQLXMLHELPER");
        }
        catch (LinkageError err) {
            throw StandardException.newException("XML00", (Throwable)err, (Object)"XALAN");
        }
    }

    public static final boolean sun5XalanClasses() {
        try {
            Class.forName("com.sun.org.apache.xml.internal.serializer.DOMSerializer");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }
}

