/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;

public class RemapSubqueryVisitor
extends VisitorAdaptor {
    private final boolean remap;
    private final JBitSet outerTables;
    private final boolean finalRemap;

    public RemapSubqueryVisitor(boolean remap, JBitSet outerTables, boolean finalRemap) {
        this.remap = remap;
        this.outerTables = outerTables;
        this.finalRemap = finalRemap;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        ColumnReference cr;
        if (node instanceof ColumnReference && !(cr = (ColumnReference)node).getFinalRemapDoneForSubqueryPred()) {
            int crTableNum;
            ResultColumn rc = cr.getSource();
            if (rc == null || (crTableNum = rc.getTableNumber()) == -1) {
                crTableNum = cr.getTableNumber();
            }
            if (crTableNum < this.outerTables.size() && crTableNum >= 0 && this.outerTables.get(crTableNum)) {
                if (this.remap) {
                    cr.remapColumnReferences();
                    if (this.finalRemap) {
                        cr.setFinalRemapDoneForSubqueryPred();
                    }
                } else {
                    cr.unRemapColumnReferences();
                }
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }
}

