/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.catalog;

import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;

public abstract class ExtraInfo {
    protected RowFormatter pkFormatter;
    protected int[] primaryKeyColumns;
    protected int[] primaryKeyFixedColumns;
    protected int[] primaryKeyVarColumns;

    protected final void setPrimaryKeyFormatter(GemFireContainer container, TableDescriptor td, int[] pkColumns) {
        TIntArrayList fixedCols = new TIntArrayList(pkColumns.length);
        TIntArrayList varCols = new TIntArrayList(pkColumns.length);
        this.pkFormatter = this.getRowFormatter(pkColumns, container, td, fixedCols, varCols, 0, true);
        this.primaryKeyFixedColumns = (int[])(fixedCols.size() > 0 ? fixedCols.toNativeArray() : null);
        this.primaryKeyVarColumns = (int[])(varCols.size() > 0 ? varCols.toNativeArray() : null);
    }

    protected final RowFormatter getRowFormatter(int[] columnPositions, GemFireContainer container, TableDescriptor td, TIntArrayList fixedCols, TIntArrayList varCols, int schemaVersion, boolean isPrimaryKeyFormatter) {
        RowFormatter formatter = container.getRowFormatter(columnPositions, td, schemaVersion, isPrimaryKeyFormatter);
        for (int index = 0; index < columnPositions.length; ++index) {
            if (formatter.getColumnDescriptor((int)index).fixedWidth > 0) {
                fixedCols.add(columnPositions[index]);
                continue;
            }
            varCols.add(columnPositions[index]);
        }
        return formatter;
    }

    public final RowFormatter getPrimaryKeyFormatter() {
        return this.pkFormatter;
    }

    public final int[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public final int[] getPrimaryKeyFixedColumns() {
        return this.primaryKeyFixedColumns;
    }

    public final int[] getPrimaryKeyVarColumns() {
        return this.primaryKeyVarColumns;
    }

    public final boolean regionKeyPartOfValue() {
        return this.pkFormatter != null;
    }

    public void dropColumnForPrimaryKeyFormatter(int columnPos) {
        if (this.pkFormatter != null) {
            GemFireXDUtils.dropColumnAdjustColumnPositions(this.primaryKeyColumns, columnPos);
            GemFireXDUtils.dropColumnAdjustColumnPositions(this.primaryKeyFixedColumns, columnPos);
            GemFireXDUtils.dropColumnAdjustColumnPositions(this.primaryKeyVarColumns, columnPos);
            this.pkFormatter.dropColumnAdjustPositionInCD(columnPos);
        }
    }

    public abstract RowFormatter getRowFormatter(byte[] var1);

    public abstract RowFormatter getRowFormatter(OffHeapByteSource var1);

    public abstract RowFormatter getRowFormatter(long var1, OffHeapByteSource var3);
}

