/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.internal.admin.remote.ShutdownAllRequest;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class GfxdShutdownAllRequest
extends ShutdownAllRequest
implements GfxdSerializable {
    protected void shutdownSelf(DM dm, boolean hadCache) throws SQLException {
        this.processShutDown(null);
        InternalDistributedSystem ids = dm.getSystem();
        if (ids != null && ids.isConnected()) {
            ids.disconnect();
        }
    }

    protected boolean isDedicatedLocator() {
        return super.isDedicatedLocator() || GemFireXDUtils.getMyVMKind() == GemFireStore.VMKind.LOCATOR;
    }

    protected void processShutDown(DistributionManager dm) throws SQLException {
        FabricServiceImpl fabricService = (FabricServiceImpl)FabricServiceManager.currentFabricServiceInstance();
        if (fabricService != null) {
            boolean isLocator;
            boolean bl = isLocator = GemFireXDUtils.getMyVMKind() == GemFireStore.VMKind.LOCATOR;
            if (isLocator) {
                NetView view;
                long waitMillis = 30000L;
                long start = System.currentTimeMillis();
                InternalDistributedMember myId = dm.getDistributionManagerId();
                while (System.currentTimeMillis() - start < 30000L && (view = dm.getMembershipManager().getView()) != null) {
                    boolean hasNewerMembers = false;
                    boolean foundMyId = false;
                    boolean hasNonLocatorMembers = false;
                    for (Object m : view) {
                        if (foundMyId && !hasNewerMembers && GemFireXDUtils.getVMKind((DistributedMember)m) == GemFireStore.VMKind.LOCATOR) {
                            hasNewerMembers = true;
                            continue;
                        }
                        if (!foundMyId && myId.equals(m)) {
                            foundMyId = true;
                            continue;
                        }
                        GemFireStore.VMKind vmKind = GemFireXDUtils.getVMKind((DistributedMember)m);
                        if (vmKind == null || !vmKind.isAccessorOrStore()) continue;
                        hasNonLocatorMembers = true;
                    }
                    if (!hasNewerMembers && !hasNonLocatorMembers) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            final SQLException[] failure = new SQLException[1];
            Thread stopThr = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FabricServiceImpl fabricService = (FabricServiceImpl)FabricServiceManager.currentFabricServiceInstance();
                    if (fabricService != null) {
                        try {
                            FabricServiceImpl fabricServiceImpl = fabricService;
                            synchronized (fabricServiceImpl) {
                                fabricService.setShutdownAllIdentifier();
                                fabricService.stop(null);
                            }
                        }
                        catch (SQLException sqle) {
                            failure[0] = sqle;
                        }
                    }
                }
            });
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            try {
                FabricService.State status = fabricService.status();
                int waitTime = status != null && status == FabricService.State.RUNNING ? 15000 : 5000;
                stopThr.start();
                stopThr.join(waitTime);
                if (stopThr.isAlive()) {
                    if (cache != null) {
                        cache.shutDownAll();
                    }
                    stopThr.join();
                }
                if (failure[0] != null) {
                    throw failure[0];
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final int getDSFID() {
        return -20;
    }

    public byte getGfxdID() {
        return 44;
    }

    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    public static void dummy() {
    }
}

