/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DirectReplyMessage;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.THashMapWithCreate;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.tcp.DirectReplySender;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessageProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollectorHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdWaitingReplyProcessorBase;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.jdbc.GfxdDDLReplayInProgressException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.XPLAINDistPropsDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class GfxdFunctionMessage<T>
extends GfxdMessage
implements InternalResultSender {
    protected transient ResultCollector<Object, T> userCollector;
    protected transient GfxdResultCollector<T> gfxdCollector;
    protected transient GfxdFunctionReplyMessageProcessor<T> processor;
    protected transient boolean orderedReplies;
    protected transient Set<DistributedMember> failedNodes;
    protected transient boolean abortOnLowMemory = true;
    protected transient DistributionManager dm;
    private transient int replySequenceId;
    private transient TXStateProxy replyTX;
    private static final int TERMINAL_REPLY_SEQID = -1;
    protected transient short messageRetryCount = 0;
    protected transient Timestamp begin_scatter_time = null;
    protected transient long root_msg_send_time;
    protected transient long self_execution_time;
    protected transient ArrayList<GfxdFunctionMessage<T>> membersMsgsSent;
    protected final transient List<GfxdFunctionReplyMessage> replyReceivedMsgs;
    protected transient List<GfxdFunctionReplyMessage> replySentMsgs;

    protected GfxdFunctionMessage(boolean ignored) {
        this.userCollector = null;
        this.gfxdCollector = null;
        this.replyReceivedMsgs = null;
        this.construct_time = null;
        this.replySentMsgs = null;
    }

    protected GfxdFunctionMessage(ResultCollector<Object, T> collector, TXStateInterface tx, boolean timeStatsEnabled, boolean abortOnLowMemory) {
        super(tx, timeStatsEnabled);
        this.abortOnLowMemory = abortOnLowMemory;
        if (this.timeStatsEnabled) {
            this.replyReceivedMsgs = Collections.synchronizedList(new ArrayList());
            this.replySentMsgs = Collections.synchronizedList(new ArrayList());
        } else {
            this.replyReceivedMsgs = null;
            this.replySentMsgs = null;
        }
        assert (collector != null) : "unexpected null ResultCollector";
        this.userCollector = collector;
        this.gfxdCollector = GfxdFunctionMessage.getGfxdResultCollector(collector);
    }

    protected GfxdFunctionMessage(GfxdFunctionMessage<T> other) {
        super(other);
        this.processor = other.processor;
        assert (other.userCollector != null) : "unexpected null ResultCollector";
        this.userCollector = other.userCollector;
        this.gfxdCollector = other.gfxdCollector;
        this.abortOnLowMemory = other.abortOnLowMemory;
        if (this.timeStatsEnabled) {
            this.membersMsgsSent = other.membersMsgsSent;
            this.replyReceivedMsgs = other.replyReceivedMsgs;
            this.replySentMsgs = other.replySentMsgs;
        } else {
            this.replyReceivedMsgs = null;
            this.replySentMsgs = null;
        }
    }

    public static final TXStateInterface getCurrentTXState(LanguageConnectionContext lcc) {
        GemFireTransaction tc;
        if (lcc != null && (tc = (GemFireTransaction)lcc.getTransactionExecute()) != null) {
            return tc.getActiveTXState();
        }
        return TXManagerImpl.getCurrentTXState();
    }

    protected static final boolean getTimeStatsSettings(LanguageConnectionContext lcc) {
        return lcc != null && (lcc.statsEnabled() || lcc.getStatisticsTiming());
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        if (this.timeStatsEnabled) {
            this.replySentMsgs = Collections.synchronizedList(new ArrayList());
        }
    }

    protected static final <T> GfxdResultCollector<T> getGfxdResultCollector(ResultCollector<Object, T> collector) {
        if (collector instanceof GfxdResultCollector) {
            return (GfxdResultCollector)collector;
        }
        return null;
    }

    public final T executeFunction() throws StandardException, SQLException {
        return this.executeFunction(false, false, null, false, true);
    }

    public final T executeFunction(boolean enableStreaming, boolean isPossibleDuplicate, AbstractGemFireResultSet rs, boolean orderedReplies) throws StandardException, SQLException {
        return this.executeFunction(enableStreaming, isPossibleDuplicate, rs, orderedReplies, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T executeFunction(boolean enableStreaming, boolean isPossibleDuplicate, AbstractGemFireResultSet rs, boolean orderedReplies, boolean getResult) throws StandardException, SQLException {
        TXStateInterface tx;
        long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.process_time == 0L ? (this.process_time = -1L) : -2L) : 0L;
        int retryCnt = 10000;
        this.orderedReplies = orderedReplies;
        if (this.requiresTXFlushBeforeExecution() && (tx = this.getTXState()) != null) {
            tx.flushPendingOps(null);
        }
        Object msg = this;
        while (true) {
            ResultCollector<Object, T> collector = null;
            long viewVersion = -1L;
            DistributionAdvisor advisor = null;
            ((GfxdMessage)msg).setPossibleDuplicate(isPossibleDuplicate);
            try {
                if (msg.containsRegionContentChange() && (advisor = ((GfxdFunctionMessage)msg).getDistributionAdvisor()) != null) {
                    viewVersion = advisor.startOperation();
                    if (TXStateProxy.LOG_VERSIONS) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ArrayUtils.objectRefString((Object)msg) + " dispatching operation in view version " + viewVersion));
                    }
                }
                ((GfxdFunctionMessage)msg).executeFunction(enableStreaming);
                if (viewVersion != -1L) {
                    advisor.endOperation(viewVersion);
                    if (TXStateProxy.LOG_VERSIONS) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ArrayUtils.objectRefString((Object)msg) + " done dispatching operation in view version " + viewVersion));
                    }
                    viewVersion = -1L;
                }
                Object object = collector = enableStreaming || ((GfxdFunctionMessage)msg).processor == null ? ((GfxdFunctionMessage)msg).userCollector : ((GfxdFunctionMessage)msg).processor;
                if (getResult) {
                    Object result = collector.getResult();
                    if (rs != null) {
                        rs.setup(result, ((GfxdFunctionMessage)msg).getNumRecipients());
                    }
                    this.process_time = this.timeStatsEnabled ? XPLAINUtil.recordTiming(begintime) : 0L;
                    Object object2 = result;
                    return (T)object2;
                }
                this.process_time = this.timeStatsEnabled ? XPLAINUtil.recordTiming(begintime) : 0L;
                T result = null;
                return result;
            }
            catch (StandardException | RuntimeException | SQLException e) {
                boolean retry;
                if (collector == null) {
                    collector = enableStreaming || ((GfxdFunctionMessage)msg).processor == null ? ((GfxdFunctionMessage)msg).userCollector : ((GfxdFunctionMessage)msg).processor;
                }
                collector.clearResults();
                Misc.checkIfCacheClosing(e);
                if (Monitor.inShutdown()) {
                    throw StandardException.newException("XJ015.M");
                }
                if (rs != null) {
                    rs.checkCancellationFlag();
                }
                if ((retry = ((GfxdFunctionMessage)msg).isHA()) && GemFireXDUtils.retryToBeDone(e, this.messageRetryCount)) {
                    if (((GfxdFunctionMessage)msg).optimizeForWrite() && msg.isTransactional()) {
                        throw StandardException.newException("40XD0", e, (Object)StandardException.getSenderFromExceptionOrSelf(e), (Object)"");
                    }
                    short s = this.messageRetryCount;
                    this.messageRetryCount = (short)(s + 1);
                    if (s >= 10000) {
                        SanityManager.DEBUG_PRINT((String)"info:TraceFunctionException", (String)"executeFunctionMessage: retry cnt: 10000 exhausted and throwing exception: ", (Throwable)e);
                        throw e;
                    }
                    GemFireXDUtils.sleepForRetry(this.messageRetryCount);
                    GfxdFunctionReplyMessageProcessor<T> processor = ((GfxdFunctionMessage)msg).processor;
                    if (processor != null) {
                        processor.addToFailedNodes((GfxdFunctionMessage<?>)msg);
                    }
                    Set<DistributedMember> failedNodes = ((GfxdFunctionMessage)msg).failedNodes;
                    msg = ((GfxdFunctionMessage)msg).clone();
                    ((GfxdFunctionMessage)msg).processor = null;
                    if (((GfxdFunctionMessage)msg).gfxdCollector != null) {
                        ((GfxdFunctionMessage)msg).gfxdCollector = ((GfxdFunctionMessage)msg).gfxdCollector.cloneCollector();
                        ((GfxdFunctionMessage)msg).userCollector = ((GfxdFunctionMessage)msg).gfxdCollector;
                        if (GemFireXDUtils.TraceRSIter || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("#executeFunction: recreated collector: " + ((GfxdFunctionMessage)msg).gfxdCollector));
                        }
                    }
                    if (rs != null) {
                        rs.reset(((GfxdFunctionMessage)msg).gfxdCollector);
                    }
                    ((GfxdFunctionMessage)msg).reset();
                    ((GfxdFunctionMessage)msg).failedNodes = failedNodes;
                    isPossibleDuplicate = true;
                    continue;
                }
                if (GemFireXDUtils.TraceFunctionException) {
                    SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("executeFunctionMessage: retry cnt: 10000 retry is false: " + e), e instanceof RuntimeException ? (e instanceof FunctionExecutionException || e instanceof FunctionInvocationTargetException ? e.getCause() : e) : null);
                }
                throw e;
            }
            finally {
                if (viewVersion == -1L) continue;
                advisor.endOperation(viewVersion);
                if (TXStateProxy.LOG_VERSIONS) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ArrayUtils.objectRefString((Object)msg) + " done dispatching operation in view version " + viewVersion));
                }
                viewVersion = -1L;
                continue;
            }
            break;
        }
    }

    public int getNumRecipients() {
        if (!this.forAll()) {
            InternalDistributedMember[] recipients = this.getRecipients();
            return recipients != null ? recipients.length : 0;
        }
        return -1;
    }

    public DistributionAdvisor getDistributionAdvisor() {
        return null;
    }

    protected abstract void executeFunction(boolean var1) throws StandardException, SQLException;

    public abstract boolean isHA();

    public abstract boolean optimizeForWrite();

    public boolean isSecondaryCopy() {
        return false;
    }

    protected GemFireCacheImpl getGemFireCache() {
        return GemFireCacheImpl.getExisting();
    }

    @Override
    public void reset() {
        super.reset();
        this.replySequenceId = 0;
        this.dm = null;
        this.replyTX = null;
    }

    protected final boolean requiresSync() {
        return this.gfxdCollector == null;
    }

    public final GfxdResultCollector<T> getGfxdResultCollector() {
        return this.gfxdCollector;
    }

    protected boolean allowExecutionOnAdminMembers() {
        return false;
    }

    protected final void executeOnMembers(InternalDistributedSystem sys, DM dm, Set<DistributedMember> members, boolean enableStreaming) throws StandardException, SQLException {
        boolean toSelf;
        this.failedNodes = null;
        int numRecipients = members.size();
        if (numRecipients == 0) {
            this.userCollector.endResults();
            return;
        }
        this.validateExecution(members);
        InternalDistributedMember myId = dm.getDistributionManagerId();
        if (numRecipients == 1) {
            toSelf = members.contains(myId);
            if (toSelf) {
                if (this.processor == null) {
                    this.setProcessor(this.createReplyProcessor(dm, myId));
                }
                this.setRecipients(Collections.emptySet());
                numRecipients = 0;
            } else {
                InternalDistributedMember member = (InternalDistributedMember)members.iterator().next();
                if (this.processor == null) {
                    this.setProcessor(this.createReplyProcessor(dm, member));
                }
                this.setRecipient(member);
            }
        } else {
            if (this.processor == null) {
                this.setProcessor(this.createReplyProcessor(dm, members));
            }
            toSelf = members.remove(myId);
            numRecipients = members.size();
            if (numRecipients > 1) {
                this.setRecipients(members);
            } else {
                this.setRecipient((InternalDistributedMember)members.iterator().next());
            }
        }
        if (numRecipients > 0) {
            this.processor.registerProcessor();
        }
        this.send(sys, dm, this.processor, false, toSelf);
    }

    protected final void executeOnMember(InternalDistributedSystem sys, DM dm, InternalDistributedMember member, boolean toSelf, boolean enableStreaming) throws StandardException, SQLException {
        this.validateExecution(member);
        if (this.processor == null) {
            this.failedNodes = null;
            this.setProcessor(this.createReplyProcessor(dm, member));
        }
        if (!toSelf) {
            this.setRecipient(member);
            this.processor.registerProcessor();
        } else {
            this.setRecipients(Collections.emptySet());
        }
        this.send(sys, dm, this.processor, false, toSelf);
    }

    protected final void validateExecution(Set<DistributedMember> members) {
        GemFireCacheImpl cache = this.getGemFireCache();
        HeapMemoryMonitor hmm = cache.getResourceManager().getHeapMonitor();
        Set<DistributedMember> tgtMembers = members;
        if (this.optimizeForWrite() && this.abortOnLowMemory && hmm.containsHeapCriticalMembers(tgtMembers) && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            Set hcm = cache.getResourceAdvisor().adviseCriticalMembers();
            THashSet sm = new THashSet(4);
            GemFireXDUtils.setIntersect(hcm, tgtMembers, sm);
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(new Object[]{this.getClass().getName(), sm}), (Set)sm);
        }
    }

    protected final void validateExecution(InternalDistributedMember m) {
        HeapMemoryMonitor hmm = this.getGemFireCache().getResourceManager().getHeapMonitor();
        if (this.optimizeForWrite() && !MemoryThresholds.isLowMemoryExceptionDisabled() && this.abortOnLowMemory && hmm.isMemberHeapCritical(m)) {
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(new Object[]{this.getClass().getName(), m}), Collections.singleton(m));
        }
    }

    protected GfxdFunctionReplyMessageProcessor<T> createReplyProcessor(DM dm, Set<DistributedMember> members) {
        return this.orderedReplies ? new GfxdFunctionOrderedReplyMessageProcessor(dm, members, this) : new GfxdFunctionReplyMessageProcessor(dm, members, this);
    }

    protected GfxdFunctionReplyMessageProcessor<T> createReplyProcessor(DM dm, InternalDistributedMember member) {
        return this.orderedReplies ? new GfxdFunctionOrderedReplyMessageProcessor(dm, member, this) : new GfxdFunctionReplyMessageProcessor(dm, member, this);
    }

    @Override
    protected final void beforeWaitForReplies(GfxdReplyMessageProcessor processor, boolean toSelf) throws ReplyException {
        long begintime;
        long l = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.process_time == 0L ? (this.process_time = -1L) : -2L) : (begintime = 0L);
        assert (processor == this.processor);
        if (toSelf) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GfxdFunctionMessage#beforeWaitForReplies: executing message in this JVM: " + this.toString()));
            }
            this.setSender(Misc.getMyId());
            this.replySequenceId = 1;
            this.process(null);
        }
        this.self_execution_time = this.timeStatsEnabled ? XPLAINUtil.recordTiming(begintime) : 0L;
    }

    protected final void setProcessor(GfxdFunctionReplyMessageProcessor<T> processor) {
        if (this.gfxdCollector != null) {
            this.gfxdCollector.setProcessor((ReplyProcessor21)processor);
        }
        this.processor = processor;
    }

    public final GfxdFunctionReplyMessageProcessor<T> getReplyProcessor() {
        return this.processor;
    }

    @Override
    protected final void handleReplyException(String exPrefix, ReplyException ex, GfxdReplyMessageProcessor processor) throws SQLException, StandardException {
        ((GfxdFunctionReplyMessageProcessor)processor).handleReplyException(exPrefix, ex, this);
    }

    @Override
    protected final void handleProcessorReplyException(String exPrefix, ReplyException replyEx) throws SQLException, StandardException {
        GfxdFunctionMessage.handleProcessorReplyException(exPrefix, replyEx.getCause());
    }

    static final void handleProcessorReplyException(String exPrefix, Throwable cause) throws SQLException, StandardException {
        GemFireXDRuntimeException.throwSQLOrRuntimeException(exPrefix + ": unexpected exception", cause);
    }

    @Override
    protected final void preProcessMessage(DistributionManager dm) {
        this.replySequenceId = 1;
        this.replyTX = null;
        if (dm != null) {
            this.dm = dm;
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": sender created for source " + this.getSender()));
            }
        } else {
            this.dm = null;
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": sender created for local node."));
            }
        }
    }

    @Override
    protected void processMessage(DistributionManager dm) throws GemFireCheckedException {
        TXStateProxy txProxy = this.getTXProxy();
        if (txProxy != null && !txProxy.skipBatchFlushOnCoordinator() && this.requiresTXFlushAfterExecution()) {
            this.setReplyTXState(txProxy);
        }
        if (this.isHA() && !Misc.initialDDLReplayDone() && dm != null) {
            throw new GfxdDDLReplayInProgressException("Node is in a transient state while executing " + this.toString());
        }
        try {
            this.execute();
        }
        catch (GemFireCheckedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ".processMessage: exception caught"), (Throwable)ex);
            }
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ex);
            if (GemFireXDUtils.retryToBeDone(ex)) {
                Throwable cause;
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("StatementQueryExecutorFunction: wrapping exception: " + ex + " into InternalFunctionInvocationTargetException so that retry happens"));
                }
                if (((cause = ex.getCause()) instanceof SQLException || cause instanceof StandardException) && cause.getCause() instanceof FunctionInvocationTargetException) {
                    throw (FunctionInvocationTargetException)cause.getCause();
                }
                throw new InternalFunctionInvocationTargetException((Throwable)ex);
            }
            if (ex instanceof GemFireException) {
                throw (GemFireException)((Object)ex);
            }
            throw new FunctionExecutionException(ex);
        }
    }

    @Override
    protected final void sendReply(ReplyException ex, DistributionManager dm) {
        if (ex != null) {
            this.sendException(ex, this);
        }
    }

    public boolean canStartRemoteTransaction() {
        return true;
    }

    public boolean useTransactionProxy() {
        return this.optimizeForWrite();
    }

    protected boolean requiresTXFlushBeforeExecution() {
        return this.optimizeForWrite();
    }

    protected boolean requiresTXFlushAfterExecution() {
        return this.optimizeForWrite();
    }

    @Override
    public int getMessageProcessorType() {
        return 80;
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return false;
    }

    protected abstract void execute() throws Exception;

    protected abstract GfxdFunctionMessage<T> clone();

    public final short getNumRetryDone() {
        return this.messageRetryCount;
    }

    protected final void setReplyTXState(TXStateProxy txProxy) {
        if (txProxy != null) {
            this.replyTX = txProxy;
            if (TXStateProxy.LOG_FINE) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GfxdFunctionMessage: set reply " + txProxy));
            }
        }
    }

    public final void sendResult(Object oneResult) {
        if (GemFireXDUtils.TraceRSIter | SanityManager.isFinerEnabled) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdFunctionMessage: sending result to recipient " + this.getSenderForReply() + ": " + oneResult));
        }
        GfxdFunctionReplyMessage replyMsg = new GfxdFunctionReplyMessage(oneResult, this.replySequenceId, false, this.processorId, this, false, false);
        this.putReply(replyMsg);
    }

    public final void sendException(Throwable t) {
        this.sendException(new ReplyException(t), this);
    }

    public final void setException(Throwable t) {
        this.sendException(new ReplyException(t), this);
    }

    final void sendException(ReplyException replyEx, GfxdFunctionMessage<?> fnMsg) {
        if (GemFireXDUtils.TraceRSIter | SanityManager.isFinerEnabled) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdFunctionMessage: sending exception to recipient " + this.getSenderForReply() + ": " + (Object)((Object)replyEx)));
        }
        GfxdFunctionReplyMessage replyMsg = new GfxdFunctionReplyMessage(fnMsg);
        replyMsg.setException(replyEx);
        replyMsg.setProcessorId(this.processorId);
        this.putReply(replyMsg);
    }

    public final void lastResult(Object oneResult) {
        this.lastResult(oneResult, true, !this.isSecondaryCopy(), true);
    }

    public final void lastResult(Object oneResult, boolean doTXFlush, boolean sendTXChanges, boolean finishTXRead) {
        TXManagerImpl.TXContext txContext;
        TXStateProxy txProxy;
        if (doTXFlush && (txProxy = this.replyTX) != null) {
            txProxy.flushPendingOps((DM)this.dm);
        } else if (this.txProxy == null && (txContext = TXManagerImpl.currentTXContext()) != null) {
            txContext.waitForPendingCommit();
        }
        if (GemFireXDUtils.TraceRSIter | SanityManager.isFinerEnabled) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdFuntionMessage: sending last result to recipient " + this.getSenderForReply() + " with " + this.getTXState() + ": " + oneResult));
        }
        this.checkAllBucketsHosted();
        GfxdFunctionReplyMessage replyMsg = new GfxdFunctionReplyMessage(oneResult, this.replySequenceId, true, this.processorId, this, sendTXChanges, finishTXRead);
        this.putReply(replyMsg);
        this.replySequenceId = -1;
    }

    public abstract void checkAllBucketsHosted() throws BucketMovedException;

    public final void enableOrderedResultStreaming(boolean enable) {
        Assert.fail((Object)"ordering expected to be invoked on sender and not receiver");
    }

    private void putReply(GfxdFunctionReplyMessage replyMsg) {
        if (this.dm != null) {
            replyMsg.setRecipient(this.getSenderForReply());
            ReplySender sender = this.getReplySender((DM)this.dm);
            if (this.replySequenceId != -1 || !(sender instanceof DirectReplySender)) {
                sender.putOutgoing((DistributionMessage)replyMsg);
            }
        } else {
            replyMsg.setSender(Misc.getMyId());
            this.processor.process((DistributionMessage)replyMsg);
        }
        if (this.replySequenceId != -1) {
            ++this.replySequenceId;
        }
    }

    public final InternalDistributedMember getSenderForReply() {
        return this.dm != null ? this.sender : Misc.getMyId();
    }

    public final boolean isLocallyExecuted() {
        return this.dm == null;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";isLocallyExecuted=" + this.isLocallyExecuted());
    }

    public final boolean isLastResultReceived() {
        return this.replySequenceId == -1;
    }

    public void setDistributionStatistics(XPLAINDistPropsDescriptor distdesc, boolean processReplySend) {
        distdesc.locallyExecuted = this.isLocallyExecuted();
        distdesc.setDistObjectName(this.getClass().getName());
        distdesc.setQueryRetryCount(this.messageRetryCount);
        distdesc.setMemberMappingRetryCount(this.mapping_retry_count);
        distdesc.setBeginScatterTime(this.begin_scatter_time);
        distdesc.setMemberMappingTime(this.member_mapping_time);
        distdesc.setSerDeSerTime(this.ser_deser_time);
        distdesc.setProcessTime(this.process_time);
        distdesc.setThrottleTime(0L);
        distdesc.processMemberSentMessages(this.membersMsgsSent, this);
        distdesc.setPrunedMembers(distdesc.getRecipients((DistributionMessage)this, true));
        if (this.replySentMsgs != null && this.replyReceivedMsgs != null) {
            if (processReplySend) {
                distdesc.processMemberReplyMessages(this.replySentMsgs);
            } else {
                distdesc.processMemberReplyMessages(this.replyReceivedMsgs);
            }
        } else {
            distdesc.processMemberReplyMessages(this.replySentMsgs);
            distdesc.processMemberReplyMessages(this.replyReceivedMsgs);
        }
    }

    public final Timestamp getConstructTime() {
        return this.construct_time;
    }

    public final long getSerializeDeSerializeTime() {
        return this.ser_deser_time;
    }

    public final long getProcessTime() {
        return this.process_time;
    }

    public final long getRootMessageSendTime() {
        return this.root_msg_send_time;
    }

    public void setSendToAllReplicates(boolean includeAdmin) {
    }

    protected static class GfxdFunctionOrderedReplyMessageProcessor<T>
    extends GfxdFunctionReplyMessageProcessor<T> {
        protected final THashMapWithCreate pendingReplies = new THashMapWithCreate();
        static final THashMapWithCreate.ValueCreator pendingListCreator = new THashMapWithCreate.ValueCreator(){

            public final Object create(Object key, Object params) {
                return new ListOfReplies(0);
            }
        };

        public GfxdFunctionOrderedReplyMessageProcessor(DM dm, Set<DistributedMember> members, GfxdFunctionMessage<T> msg) {
            super(dm, members, msg);
        }

        public GfxdFunctionOrderedReplyMessageProcessor(DM dm, InternalDistributedMember member, GfxdFunctionMessage<T> msg) {
            super(dm, member, msg);
        }

        @Override
        protected synchronized boolean addResult(GfxdFunctionReplyMessage replyMsg, GfxdResponseCode responseCode) {
            InternalDistributedMember sender = replyMsg.getSender();
            boolean isLastResult = responseCode.isGrant();
            if (isLastResult || responseCode.isWaiting()) {
                Object replies = this.pendingReplies.create((Object)sender, pendingListCreator, null);
                if (replies != Token.DESTROYED) {
                    return ((ListOfReplies)replies).add(this, (DistributedMember)sender, replyMsg.singleResult, isLastResult ? responseCode.grantedSequenceId() : responseCode.waitingSequenceId(), isLastResult);
                }
                return true;
            }
            if (!responseCode.isException()) {
                Assert.fail((Object)("GfxdFunctionOrderedReplyMessageProcessor: unexpected responseCode=" + responseCode));
            }
            this.pendingReplies.put((Object)sender, (Object)Token.DESTROYED);
            if (this.latch == null) {
                this.addResult((DistributedMember)sender, (Object)replyMsg.getException());
            }
            return false;
        }

        protected static final class ListOfReplies {
            protected int expectedReplies;
            protected int lastFlushedId;
            private static final Object[] zeroLenArray = new Object[0];
            private Object[] elementData;
            private int size;

            public ListOfReplies(int capacity) {
                this.elementData = capacity == 0 ? zeroLenArray : new Object[capacity];
            }

            public boolean add(GfxdFunctionReplyMessageProcessor<?> processor, DistributedMember memberId, Object resultOfSingleExecution, int sequenceId, boolean isLastResult) {
                assert (sequenceId > 0);
                if (isLastResult) {
                    this.expectedReplies = sequenceId;
                }
                int size = this.size;
                if (sequenceId == this.lastFlushedId + 1) {
                    processor.addResult(memberId, resultOfSingleExecution);
                    ++this.lastFlushedId;
                    if (size > 0) {
                        int pos = 0;
                        for (Object result : this.elementData) {
                            if (result != null) {
                                if (GemFireXDUtils.TraceQuery | SanityManager.isFineEnabled | GemFireXDUtils.TraceNCJ) {
                                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ListOfReplies for " + processor.getProcessorId() + ": processing previously unordered message with sequence " + (this.lastFlushedId + 1) + ", expectedReplies=" + this.expectedReplies));
                                }
                                processor.addResult(memberId, result);
                                ++pos;
                                ++this.lastFlushedId;
                                continue;
                            }
                            if (pos != 0) break;
                            ++pos;
                        }
                        if (pos > 0) {
                            this.removeTo(pos);
                        }
                    }
                    assert (this.expectedReplies == 0 || this.lastFlushedId <= this.expectedReplies) : "lastFlushedId=" + this.lastFlushedId + ", expectedReplies=" + this.expectedReplies;
                    return this.lastFlushedId != this.expectedReplies;
                }
                int insertIndex = sequenceId - this.lastFlushedId - 1;
                if (insertIndex >= size) {
                    int newSize = insertIndex + 1;
                    this.ensureCapacity(newSize);
                    this.size = newSize;
                }
                if (GemFireXDUtils.TraceQuery | SanityManager.isFineEnabled) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ListOfReplies for " + processor.getProcessorId() + ": queueing unordered message with sequence " + sequenceId + " (lastFlushedId=" + this.lastFlushedId + ") at index " + insertIndex));
                }
                this.elementData[insertIndex] = resultOfSingleExecution;
                return true;
            }

            private void removeTo(int toIndex) {
                int newSize = this.size - toIndex;
                if (newSize > 0) {
                    System.arraycopy(this.elementData, toIndex, this.elementData, 0, newSize);
                }
                for (int index = newSize; index < this.size; ++index) {
                    this.elementData[index] = null;
                }
                this.size = newSize;
            }

            private void ensureCapacity(int minCapacity) {
                int oldCapacity = this.elementData.length;
                if (oldCapacity == 0) {
                    int newCapacity = 4;
                    if (newCapacity < minCapacity) {
                        newCapacity = minCapacity;
                    }
                    this.elementData = new Object[newCapacity];
                } else if (minCapacity > oldCapacity) {
                    int newCapacity = oldCapacity * 3 / 2 + 1;
                    if (newCapacity < minCapacity) {
                        newCapacity = minCapacity;
                    }
                    this.elementData = Arrays.copyOf(this.elementData, newCapacity);
                }
            }
        }
    }

    protected static class GfxdFunctionReplyMessageProcessor<T>
    extends GfxdWaitingReplyProcessorBase
    implements GfxdResultCollector<T> {
        protected ResultCollector<Object, T> userCollector;
        protected final boolean recordStats;
        protected final boolean allowExecutionOnAdminMembers;
        protected final List<GfxdFunctionReplyMessage> replyReceivedMsgs;
        protected volatile Set<DistributedMember> failedNodes;
        protected final boolean isDirectReplyMessage;
        protected final StoppableCountDownLatch latch;
        protected final GfxdResultCollectorHelper helper;

        public GfxdFunctionReplyMessageProcessor(DM dm, Set<DistributedMember> members, GfxdFunctionMessage<T> msg) {
            super(dm, members, false);
            this.userCollector = msg.userCollector;
            this.recordStats = ((GfxdFunctionMessage)msg).timeStatsEnabled;
            this.replyReceivedMsgs = msg.replyReceivedMsgs;
            this.allowExecutionOnAdminMembers = msg.allowExecutionOnAdminMembers();
            this.isDirectReplyMessage = msg instanceof DirectReplyMessage && ((DirectReplyMessage)msg).supportsDirectAck();
            this.latch = msg.requiresSync() ? new StoppableCountDownLatch(dm.getCancelCriterion(), 1) : null;
            this.helper = new GfxdResultCollectorHelper();
        }

        public GfxdFunctionReplyMessageProcessor(DM dm, InternalDistributedMember member, GfxdFunctionMessage<T> msg) {
            super(dm, member, false);
            this.userCollector = msg.userCollector;
            this.recordStats = ((GfxdFunctionMessage)msg).timeStatsEnabled;
            this.replyReceivedMsgs = msg.replyReceivedMsgs;
            this.allowExecutionOnAdminMembers = msg.allowExecutionOnAdminMembers();
            this.isDirectReplyMessage = msg instanceof DirectReplyMessage && ((DirectReplyMessage)msg).supportsDirectAck();
            this.latch = msg.requiresSync() ? new StoppableCountDownLatch(dm.getCancelCriterion(), 1) : null;
            this.helper = new GfxdResultCollectorHelper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(DistributionMessage msg) {
            boolean waiting = false;
            try {
                ReplyMessage replyMsg;
                if (msg instanceof GfxdFunctionReplyMessage) {
                    long begintime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
                    GfxdFunctionReplyMessage replyMsg2 = (GfxdFunctionReplyMessage)msg;
                    GfxdResponseCode responseCode = replyMsg2.getResponseCode();
                    waiting = this.addResult(replyMsg2, responseCode);
                    if (begintime != 0L) {
                        this.replyReceivedMsgs.add(replyMsg2);
                        replyMsg2.process_time = XPLAINUtil.recordTiming(begintime);
                    }
                } else if (msg instanceof ReplyMessage && (replyMsg = (ReplyMessage)msg).getException() != null && this.latch == null) {
                    this.addResult((DistributedMember)replyMsg.getSender(), (Object)replyMsg.getException());
                }
            }
            finally {
                if (!waiting) {
                    super.process(msg);
                }
            }
        }

        protected boolean addResult(GfxdFunctionReplyMessage replyMsg, GfxdResponseCode responseCode) {
            if (responseCode.isGrant() || responseCode.isWaiting()) {
                this.addResult((DistributedMember)replyMsg.getSender(), replyMsg.singleResult);
            } else {
                if (!responseCode.isException()) {
                    Assert.fail((Object)("GfxdFunctionReplyMessageProcessor: unexpected responseCode=" + responseCode));
                }
                if (this.latch == null) {
                    this.addResult((DistributedMember)replyMsg.getSender(), (Object)replyMsg.getException());
                }
            }
            return this.processResponseCode(replyMsg, responseCode);
        }

        protected final boolean allowReplyFromSender() {
            return true;
        }

        public final void registerProcessor() {
            if (this.processorId == 0 && !this.isDirectReplyMessage) {
                super.register();
            }
        }

        protected boolean isDirectReplyProcessor() {
            return this.isDirectReplyMessage;
        }

        public final boolean isExpectingDirectReply() {
            return this.isDirectReplyMessage && this.processorId == 0;
        }

        public void memberDeparted(InternalDistributedMember member, boolean crashed) {
            if (member != null && this.waitingOnMember(member)) {
                ReplyException replyEx = new ReplyException((Throwable)new CacheClosedException(LocalizedStrings.MemberMessage_MEMBERRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(new Object[]{member, String.valueOf(crashed)})));
                if (this.latch == null) {
                    this.addResult((DistributedMember)member, (Object)replyEx);
                }
                this.processExceptionFromMember(member, replyEx);
            }
            super.memberDeparted(member, crashed);
        }

        @Override
        protected void addGrantedMember(DistributedMember member) {
        }

        @Override
        protected final void postFinish() {
            if (!this.isExpectingDirectReply()) {
                this.endResults();
            }
            super.postFinish();
        }

        @Override
        protected final Set<DistributedMember> virtualReset() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addResult(DistributedMember memberId, Object resultOfSingleExecution) {
            ResultCollector<Object, T> userCollector = this.userCollector;
            if (this.latch == null) {
                userCollector.addResult(memberId, resultOfSingleExecution);
            } else {
                ResultCollector<Object, T> resultCollector = userCollector;
                synchronized (resultCollector) {
                    if (!(resultOfSingleExecution instanceof Throwable)) {
                        this.helper.addResultMember(memberId);
                    }
                    userCollector.addResult(memberId, resultOfSingleExecution);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T getResult() throws FunctionException {
            this.waitForResult();
            if (this.latch == null) {
                return (T)this.userCollector.getResult();
            }
            ResultCollector<Object, T> resultCollector = this.userCollector;
            synchronized (resultCollector) {
                return (T)this.userCollector.getResult();
            }
        }

        public final T getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            this.waitForResult();
            return (T)this.userCollector.getResult(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void endResults() {
            ResultCollector<Object, T> userCollector = this.userCollector;
            if (this.latch != null) {
                ResultCollector<Object, T> resultCollector = userCollector;
                synchronized (resultCollector) {
                    userCollector.endResults();
                }
                this.latch.countDown();
            } else {
                userCollector.endResults();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearResults() {
            if (this.startedWaiting) {
                this.endWait();
            }
            ResultCollector<Object, T> userCollector = this.userCollector;
            if (this.latch != null) {
                ResultCollector<Object, T> resultCollector = userCollector;
                synchronized (resultCollector) {
                    userCollector.clearResults();
                }
            } else {
                userCollector.clearResults();
            }
            this.failedNodes = null;
        }

        protected final void waitForResult() throws FunctionException {
            try {
                if (this.isExpectingDirectReply()) {
                    this.endResults();
                } else {
                    this.waitForReplies();
                    if (this.latch != null) {
                        this.latch.await();
                    }
                }
                ReplyException replyEx = this.exception;
                if (replyEx != null) {
                    throw replyEx;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.getDistributionManager().getCancelCriterion().checkCancelInProgress((Throwable)ie);
            }
            catch (ReplyException ex) {
                try {
                    this.handleReplyException(this.toString(), ex, null);
                }
                catch (StandardException se) {
                    throw new FunctionException((Throwable)se);
                }
                catch (SQLException se) {
                    throw new FunctionException((Throwable)se);
                }
            }
            finally {
                if (this.startedWaiting) {
                    this.postWait();
                }
            }
        }

        protected synchronized void handleReplyException(String exPrefix, ReplyException ex, GfxdFunctionMessage<?> fnMsg) throws SQLException, StandardException {
            Map<DistributedMember, ReplyException> exceptions = this.getReplyExceptions();
            if (exceptions != null) {
                ReplyException failureException = null;
                for (Map.Entry<DistributedMember, ReplyException> entry : exceptions.entrySet()) {
                    ReplyException replyEx = entry.getValue();
                    if (!GemFireXDUtils.retryToBeDone(replyEx.getCause())) continue;
                    if (GemFireXDUtils.nodeFailureException(replyEx.getCause())) {
                        if (this.failedNodes == null) {
                            this.failedNodes = new THashSet(5);
                        }
                        this.failedNodes.add(entry.getKey());
                    }
                    failureException = replyEx;
                }
                this.addToFailedNodes(fnMsg);
                if (failureException != null) {
                    GfxdFunctionMessage.handleProcessorReplyException(exPrefix, failureException.getCause());
                }
                for (ReplyException replyEx : exceptions.values()) {
                    GfxdFunctionMessage.handleProcessorReplyException(exPrefix, replyEx.getCause());
                }
            }
            GfxdFunctionMessage.handleProcessorReplyException(exPrefix, ex.getCause());
        }

        protected final synchronized void addToFailedNodes(GfxdFunctionMessage<?> fnMsg) {
            if (fnMsg != null && this.failedNodes != null) {
                if (fnMsg.failedNodes == null) {
                    fnMsg.failedNodes = new THashSet();
                }
                fnMsg.failedNodes.addAll(this.failedNodes);
            }
        }

        protected final Set<?> addListenerAndGetMembers() {
            if (!this.allowExecutionOnAdminMembers) {
                return this.getDistributionManager().addMembershipListenerAndGetDistributionManagerIds((MembershipListener)this);
            }
            return this.getDistributionManager().addAllMembershipListenerAndGetAllIds((MembershipListener)this);
        }

        protected final void removeListener() {
            try {
                if (!this.allowExecutionOnAdminMembers) {
                    this.getDistributionManager().removeMembershipListener((MembershipListener)this);
                } else {
                    this.getDistributionManager().removeAllMembershipListener((MembershipListener)this);
                }
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }

        public final void setProcessor(ReplyProcessor21 processor) {
        }

        public final ReplyProcessor21 getProcessor() {
            return this;
        }

        @Override
        public final void setResultMembers(Set<DistributedMember> members) {
            this.helper.setResultMembers(members);
        }

        @Override
        public final Set<DistributedMember> getResultMembers() {
            return this.helper.getResultMembers();
        }

        @Override
        public final boolean setupContainersToClose(Collection<GemFireContainer> containers, GemFireTransaction tran) throws StandardException {
            GfxdResultCollector<T> gfxdCollector;
            if (this.latch == null && (gfxdCollector = GfxdFunctionMessage.getGfxdResultCollector(this.userCollector)) != null) {
                return gfxdCollector.setupContainersToClose(containers, tran);
            }
            return false;
        }

        @Override
        public final void setNumRecipients(int n) {
        }

        @Override
        public final GfxdResultCollectorHelper getStreamingHelper() {
            return null;
        }

        public final void setException(Throwable exception) {
            throw new GemFireXDRuntimeException("not expected to be invoked in GemFireXD");
        }

        @Override
        public GfxdResultCollector<T> cloneCollector() {
            if (this.userCollector instanceof GfxdResultCollector) {
                this.userCollector = ((GfxdResultCollector)this.userCollector).cloneCollector();
            }
            return this;
        }
    }

    public static final class GfxdFunctionReplyMessage
    extends GfxdReplyMessage {
        Object singleResult;
        GfxdResponseCode responseCode;
        protected Timestamp construct_time;
        protected long ser_deser_time;
        protected long process_time;
        protected long[] single_result_statistics;

        public GfxdFunctionReplyMessage() {
            this(null);
        }

        public GfxdFunctionReplyMessage(GfxdFunctionMessage<?> fnMsg) {
            super(fnMsg, true, true, false);
            this.construct_time = this.timeStatsEnabled ? XPLAINUtil.currentTimeStamp() : null;
            this.singleResult = null;
            this.responseCode = GfxdResponseCode.EXCEPTION;
        }

        GfxdFunctionReplyMessage(Object result, int sequenceId, boolean isLast, int processorId, GfxdFunctionMessage<?> fnMsg, boolean sendTXChanges, boolean finishTXRead) {
            super(fnMsg, sendTXChanges, finishTXRead, false);
            if (this.timeStatsEnabled) {
                this.construct_time = XPLAINUtil.currentTimeStamp();
                if (!isLast && result instanceof ResultHolder) {
                    this.single_result_statistics = ((ResultHolder)result).snapshotStatistics();
                }
                fnMsg.replySentMsgs.add(this);
            } else {
                this.construct_time = null;
            }
            this.singleResult = result;
            this.responseCode = isLast ? GfxdResponseCode.GRANT(sequenceId) : GfxdResponseCode.WAITING(sequenceId);
            this.processorId = processorId;
        }

        @Override
        public GfxdResponseCode getResponseCode() {
            return this.responseCode;
        }

        public void setException(ReplyException ex) {
            super.setException(ex);
            this.responseCode = GfxdResponseCode.EXCEPTION;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            if (!this.timeStatsEnabled) {
                this.responseCode.toData(out);
                DataSerializer.writeObject((Object)this.singleResult, (DataOutput)out);
            } else {
                long begintime = XPLAINUtil.recordTiming(-1L);
                this.responseCode.toData(out);
                DataSerializer.writeObject((Object)this.singleResult, (DataOutput)out);
                this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
            }
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            if (!this.timeStatsEnabled) {
                this.responseCode = GfxdResponseCode.fromData(in);
                this.singleResult = DataSerializer.readObject((DataInput)in);
            } else {
                this.construct_time = XPLAINUtil.currentTimeStamp();
                this.responseCode = GfxdResponseCode.fromData(in);
                this.singleResult = DataSerializer.readObject((DataInput)in);
                this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
            }
        }

        @Override
        public byte getGfxdID() {
            return 27;
        }

        protected StringBuilder getStringBuilder() {
            return super.getStringBuilder().append(" with responseCode=").append(this.responseCode).append(" singleResult=").append(this.singleResult);
        }

        public final Timestamp getConstructTime() {
            return this.construct_time;
        }

        public final long getSerializeDeSerializeTime() {
            return this.ser_deser_time;
        }

        public final long getProcessTime() {
            return this.process_time;
        }

        public final Object getSingleResult() {
            return this.singleResult;
        }

        public long[] getSingleResultStatistics() {
            return this.single_result_statistics;
        }
    }
}

