/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.execute.EmptyRegionFunctionException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NoDataStoreAvailableException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TIntHashSet;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.gemstone.gnu.trove.TObjectObjectProcedure;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.collection.IntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class ReferencedKeyCheckerMessage
extends MemberExecutorMessage<ArrayList<List<Object>>> {
    private String schemaName;
    private String tableName;
    private ArrayList<DataValueDescriptor[]> keyColumnDVDs;
    private int numColumns;
    private ArrayList<byte[]> keyRows;
    private long connectionId;
    private final transient ArrayList<RowLocation> keyColumnLocations;
    private transient GemFireContainer container;
    private final transient GemFireContainer[] refContainers;
    private final transient THashMap hostedBuckets;
    private boolean forUpdate;
    private int[] refImpactedCols;
    private transient FormatableBitSet refColsUpdtdBits;
    private transient int[] refCol2DVDPosMapping;
    private final transient IntObjectHashMap<TIntHashSet> refColUpdtd2DependentCols;
    private final transient TIntIntHashMap refCol2IndexMap;
    private transient IntObjectHashMap<byte[]> refColSameAfterModBitsMapping;
    private transient GfxdConnectionWrapper wrapperForMarkUnused;
    private static final TObjectObjectProcedure postExecutionProc = new TObjectObjectProcedure(){

        public final boolean execute(Object key, Object value) {
            GemFireContainer gfc = (GemFireContainer)key;
            RegionExecutorMessage.HashMapOrSet beforeExecutionState = (RegionExecutorMessage.HashMapOrSet)((Object)value);
            final PartitionedRegion pr = (PartitionedRegion)gfc.getRegion();
            RegionAdvisor advisor = pr.getRegionAdvisor();
            final RegionExecutorMessage.HashMapOrSet afterExecutionState = new RegionExecutorMessage.HashMapOrSet(true, (LocalRegion)pr);
            advisor.accept(RegionExecutorMessage.collectPrimaries, (Object)afterExecutionState);
            if (afterExecutionState.size() != beforeExecutionState.size()) {
                for (Object m : beforeExecutionState.keySet()) {
                    if (afterExecutionState.remove(m) != null) continue;
                    BitSetSet movedBuckets = (BitSetSet)beforeExecutionState.get(m);
                    throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), movedBuckets.nextSetBit(0, 0), pr.getFullPath());
                }
                if (afterExecutionState.size() > 0) {
                    BitSetSet movedBuckets = (BitSetSet)afterExecutionState.values().iterator().next();
                    throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), movedBuckets.nextSetBit(0, 0), pr.getFullPath());
                }
            }
            beforeExecutionState.forEachEntry(new TObjectObjectProcedure(){

                public final boolean execute(Object key, Object value) {
                    DistributedMember member = (DistributedMember)key;
                    BitSetSet beforeBitSetSet = (BitSetSet)value;
                    BitSetSet afterBitSetSet = (BitSetSet)afterExecutionState.get(member);
                    if (afterBitSetSet == null || beforeBitSetSet.size() != afterBitSetSet.size()) {
                        if (afterBitSetSet != null) {
                            beforeBitSetSet.removeAll(afterBitSetSet);
                        }
                        throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), beforeBitSetSet.nextSetBit(0, 0), pr.getFullPath());
                    }
                    int valBefore = beforeBitSetSet.nextSetBit(0, 0);
                    int valAfter = afterBitSetSet.nextSetBit(0, 0);
                    while (valBefore != -1) {
                        if (valBefore != valAfter) {
                            throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), valBefore, pr.getFullPath());
                        }
                        valBefore = beforeBitSetSet.nextSetBit(valBefore + 1);
                        valAfter = afterBitSetSet.nextSetBit(valAfter + 1);
                    }
                    return true;
                }
            });
            return true;
        }
    };

    public ReferencedKeyCheckerMessage() {
        super(true);
        this.keyColumnLocations = null;
        this.refContainers = null;
        this.hostedBuckets = null;
        this.refColUpdtd2DependentCols = null;
        this.refCol2IndexMap = null;
    }

    public ReferencedKeyCheckerMessage(ReferencedKeyResultCollector rc, TXStateInterface tx, LanguageConnectionContext lcc, GemFireContainer container, ArrayList<DataValueDescriptor[]> keyColumnValues, ArrayList<RowLocation> keyColumnLocations, GemFireContainer[] refContainers, boolean forUpdate, int[] refImpactedCols, FormatableBitSet refColsUpdtdBits, IntObjectHashMap<TIntHashSet> refColUpdtd2DependentCols, TIntIntHashMap refCol2IndexMap, int[] colToDVDPosMapping) {
        super(rc, tx, ReferencedKeyCheckerMessage.getTimeStatsSettings(lcc), true);
        this.container = container;
        this.schemaName = container.getSchemaName();
        if (this.schemaName == null) {
            this.schemaName = Misc.getDefaultSchemaName(lcc);
        }
        this.tableName = container.getTableName();
        this.keyColumnDVDs = keyColumnValues;
        this.keyColumnLocations = keyColumnLocations;
        this.connectionId = lcc.getConnectionId();
        this.refContainers = refContainers;
        this.hostedBuckets = new THashMap();
        this.forUpdate = forUpdate;
        this.refImpactedCols = refImpactedCols;
        this.refColsUpdtdBits = refColsUpdtdBits;
        this.refCol2DVDPosMapping = colToDVDPosMapping;
        this.refColUpdtd2DependentCols = refColUpdtd2DependentCols;
        this.refCol2IndexMap = refCol2IndexMap;
    }

    protected ReferencedKeyCheckerMessage(ReferencedKeyCheckerMessage other) {
        super(other);
        this.container = other.container;
        this.schemaName = other.schemaName;
        this.tableName = other.tableName;
        this.keyColumnDVDs = other.keyColumnDVDs;
        this.keyColumnLocations = other.keyColumnLocations;
        this.connectionId = other.connectionId;
        this.refContainers = other.refContainers;
        this.hostedBuckets = new THashMap();
        this.forUpdate = other.forUpdate;
        this.refImpactedCols = other.refImpactedCols;
        this.refColsUpdtdBits = other.refColsUpdtdBits;
        this.refCol2DVDPosMapping = other.refCol2DVDPosMapping;
        this.refColUpdtd2DependentCols = other.refColUpdtd2DependentCols;
        this.refCol2IndexMap = other.refCol2IndexMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws SQLException, StandardException {
        this.container = (GemFireContainer)Misc.getRegionByPath(Misc.getRegionPath(this.schemaName, this.tableName, null), true).getUserAttribute();
        if (this.keyColumnDVDs == null && this.keyRows != null) {
            int columns = this.numColumns;
            int numRows = this.keyRows.size();
            this.keyColumnDVDs = new ArrayList(numRows);
            ExtraTableInfo tableInfo = this.container.getExtraTableInfo();
            RowFormatter rf = tableInfo.getReferencedKeyRowFormatter();
            int[] keyPositions = tableInfo.getReferencedKeyColumns();
            assert (columns == keyPositions.length) : "numKeys=" + keyPositions.length + ", read=" + columns;
            for (int index = 0; index < numRows; ++index) {
                byte[] rowBytes = this.keyRows.get(index);
                if (rowBytes == null) continue;
                DataValueDescriptor[] row = new DataValueDescriptor[columns];
                for (int col = 1; col <= columns; ++col) {
                    row[col - 1] = rf.getColumn(col, rowBytes);
                }
                this.keyColumnDVDs.add(row);
            }
            this.keyRows = null;
        }
        LanguageConnectionContext lcc = null;
        GemFireTransaction tc = null;
        GemFireContainer container = this.container;
        boolean setRowsInLCC = false;
        boolean contextSet = false;
        this.wrapperForMarkUnused = null;
        GfxdConnectionWrapper wrapper = GfxdConnectionHolder.getOrCreateWrapper(null, this.connectionId, false, null);
        EmbedConnection conn = wrapper.getConnectionForSynchronization();
        int syncVersion = -1;
        Object object = conn.getConnectionSynchronization();
        synchronized (object) {
            boolean oldPosDup = false;
            try {
                syncVersion = wrapper.convertToHardReference(conn);
                conn.getTR().setupContextStack();
                contextSet = true;
                lcc = wrapper.getLanguageConnectionContext();
                oldPosDup = lcc.isPossibleDuplicate();
                lcc.setPossibleDuplicate(this.isPossibleDuplicate());
                FormatableBitSet colsToWritePerRowLocal = null;
                if (this.isLocallyExecuted()) {
                    if (this.forUpdate) {
                        colsToWritePerRowLocal = new FormatableBitSet(this.refImpactedCols.length);
                    }
                    for (GemFireContainer refContainer : this.refContainers) {
                        if (container != refContainer) continue;
                        THashSet rows = new THashSet(this.keyColumnLocations);
                        lcc.setReferencedKeyCheckRows((Collection<RowLocation>)rows);
                        setRowsInLCC = true;
                        break;
                    }
                }
                DataDictionary dd = lcc.getDataDictionary();
                tc = (GemFireTransaction)lcc.getTransactionExecute();
                GfxdConnectionWrapper.checkForTransaction(conn, tc, this.getTXState());
                ExtraTableInfo tableInfo = container.getExtraTableInfo();
                int[] columnPositions = this.forUpdate ? this.refImpactedCols : tableInfo.getReferencedKeyColumns();
                int rowCount = this.keyColumnDVDs != null ? this.keyColumnDVDs.size() : this.keyColumnLocations.size();
                HashMap<int[], long[]> keyColumns2IndexNumbers = tableInfo.getReferencedKeyColumns2IndexNumbers();
                TIntIntHashMap columnPositions2Index = this.buildColumnPosition2ArrayIndex(columnPositions);
                for (int rowNumber = 0; rowNumber < rowCount; ++rowNumber) {
                    GemFireXDUtils.Pair<Long, RowLocation> failPosition;
                    Object[] dvdRow = this.getKeyColumnValues(rowNumber);
                    if (dvdRow == null) continue;
                    if (this.isLocallyExecuted() && this.forUpdate) {
                        colsToWritePerRowLocal.clear();
                        this.identifyUpdatedColsUnchangedAndColsToWrite((DataValueDescriptor[])dvdRow, colsToWritePerRowLocal, rowNumber);
                    }
                    if ((failPosition = this.existingKeyInDependentTables(tc, columnPositions2Index, (DataValueDescriptor[])dvdRow, keyColumns2IndexNumbers, rowNumber, colsToWritePerRowLocal)) == null) continue;
                    long indexNumber = failPosition.getKey();
                    ConglomerateDescriptor indexCD = dd.getConglomerateDescriptor(indexNumber);
                    String constraintName = indexCD.getConglomerateName();
                    ArrayList<String> failure = new ArrayList<String>(4);
                    failure.add(constraintName);
                    failure.add(RowUtil.toString(dvdRow));
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                    this.lastResult(failure, false, true, true);
                    return;
                }
            }
            finally {
                if (lcc != null) {
                    lcc.setPossibleDuplicate(oldPosDup);
                    if (setRowsInLCC) {
                        lcc.setReferencedKeyCheckRows(null);
                    }
                }
                if (tc != null) {
                    tc.resetTXState();
                }
                if (contextSet) {
                    conn.getTR().restoreContextStack();
                }
                if (!wrapper.isClosed() && wrapper.convertToSoftReference(syncVersion)) {
                    this.wrapperForMarkUnused = wrapper;
                }
                this.wrapperForMarkUnused = wrapper;
            }
        }
        this.endMessage();
        this.lastResult(Boolean.TRUE, false, true, true);
    }

    @Override
    protected void endMessage() {
        if (this.wrapperForMarkUnused != null) {
            this.wrapperForMarkUnused.markUnused();
            this.wrapperForMarkUnused = null;
        }
    }

    private int getIndexInLocalDVDRow(int colNum) {
        int posInExecRow = this.refCol2DVDPosMapping != null ? this.refCol2DVDPosMapping[colNum - 1] : colNum - 1;
        return posInExecRow;
    }

    GemFireXDUtils.Pair<Long, RowLocation> existingKeyInDependentTables(GemFireTransaction tc, TIntIntHashMap columnPositions2Index, DataValueDescriptor[] columnValues, HashMap<int[], long[]> keyColumns2IndexNumbers, int rowNum, FormatableBitSet colsToWritePerRowLocal) throws StandardException {
        block0: for (int[] keyColumnPositions : keyColumns2IndexNumbers.keySet()) {
            long[] indexNumbers = keyColumns2IndexNumbers.get(keyColumnPositions);
            int keyLength = keyColumnPositions.length;
            DataValueDescriptor[] startOperand = new DataValueDescriptor[keyLength];
            boolean foundChangedKey = false;
            for (int i = 0; i < keyLength; ++i) {
                byte bitIndex;
                int byteIndex;
                boolean isSet;
                byte[] refColsSameAfterUpdtBit;
                int arrayIndex = columnPositions2Index.get(keyColumnPositions[i]);
                if (arrayIndex == 0 && !columnPositions2Index.containsKey(keyColumnPositions[i])) continue block0;
                if (colsToWritePerRowLocal != null) {
                    boolean shouldWriteValue = colsToWritePerRowLocal.get(arrayIndex);
                    if (shouldWriteValue) {
                        int posInRow = this.isLocallyExecuted() && this.forUpdate ? this.getIndexInLocalDVDRow(keyColumnPositions[i]) : arrayIndex;
                        startOperand[i] = columnValues[posInRow];
                    } else {
                        startOperand[i] = null;
                    }
                } else {
                    int posInRow = this.isLocallyExecuted() && this.forUpdate ? this.getIndexInLocalDVDRow(keyColumnPositions[i]) : arrayIndex;
                    startOperand[i] = columnValues[posInRow];
                }
                if (this.forUpdate && (startOperand[i] == null || startOperand[i].isNull())) {
                    assert (!foundChangedKey);
                    continue block0;
                }
                if (!this.forUpdate || foundChangedKey || !this.refColsUpdtdBits.isSet(arrayIndex)) continue;
                byte[] byArray = refColsSameAfterUpdtBit = this.refColSameAfterModBitsMapping != null ? (byte[])this.refColSameAfterModBitsMapping.get(rowNum) : null;
                if (refColsSameAfterUpdtBit == null) {
                    foundChangedKey = true;
                    continue;
                }
                int pos = this.refColsUpdtdBits.anySetBit();
                int j = -1;
                while (pos != -1) {
                    ++j;
                    if (pos == arrayIndex) break;
                    pos = this.refColsUpdtdBits.anySetBit(pos);
                }
                boolean bl = isSet = (refColsSameAfterUpdtBit[byteIndex = FormatableBitSet.udiv8(j)] & 128 >> (bitIndex = FormatableBitSet.umod8(j))) != 0;
                if (isSet) continue;
                foundChangedKey = true;
            }
            if (this.forUpdate && !foundChangedKey) continue;
            for (int j = 0; j < indexNumbers.length; ++j) {
                long indexNumber = indexNumbers[j];
                MemScanController sc = tc.openScan(indexNumber, false, 0x800000, 7, 0, null, startOperand, 1, null, startOperand, -1, null);
                if (sc.next()) {
                    RowLocation rl = sc.fetchLocation(null);
                    sc.close();
                    return new GemFireXDUtils.Pair<Long, RowLocation>(indexNumber, rl);
                }
                sc.close();
            }
        }
        return null;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.hostedBuckets != null) {
            this.hostedBuckets.clear();
        }
    }

    private TIntIntHashMap buildColumnPosition2ArrayIndex(int[] columns) {
        TIntIntHashMap columnPositions2Index = new TIntIntHashMap();
        for (int index = 0; index < columns.length; ++index) {
            columnPositions2Index.put(columns[index], index);
        }
        return columnPositions2Index;
    }

    public static void referencedKeyCheck(GemFireContainer container, LanguageConnectionContext lcc, ArrayList<DataValueDescriptor[]> keyColumnValues, ArrayList<RowLocation> keyColumnLocations, boolean flushTXPendingOps, boolean forUpdate, int[] referencedImpactedCols, FormatableBitSet refColsUpdtdBits, IntObjectHashMap<TIntHashSet> refColUpdtd2DependentCols, TIntIntHashMap refCol2IndexMap, int[] colNumToDVDMapping) throws StandardException {
        GemFireContainer[] refContainers = container.getExtraTableInfo().getReferencedContainers();
        ReferencedKeyResultCollector rkrc = new ReferencedKeyResultCollector();
        TXStateInterface tx = ReferencedKeyCheckerMessage.getCurrentTXState(lcc);
        ReferencedKeyCheckerMessage checkMsg = new ReferencedKeyCheckerMessage(rkrc, tx, lcc, container, keyColumnValues, keyColumnLocations, refContainers, forUpdate, referencedImpactedCols, refColsUpdtdBits, refColUpdtd2DependentCols, refCol2IndexMap, colNumToDVDMapping);
        Collection result = null;
        try {
            if (tx != null && tx != tx.getProxy()) {
                GemFireXDUtils.throwAssert("ReferencedKeyCheckerMessage#referencedKeyCheck: expected same proxies but got: " + tx + " and " + tx.getProxy());
            }
            result = (Collection)checkMsg.executeFunction(false, lcc.isPossibleDuplicate(), null, false);
        }
        catch (StandardException se) {
            if (!"X0Z04.S".equals(se.getMessageId())) {
                throw Misc.processFunctionException("ReferencedKeyCheckerMessage#referencedKeyCheck", se, null, container.getRegion());
            }
        }
        catch (EmptyRegionFunctionException se) {
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "reference key check on parent " + container.getQualifiedTableName(), true);
        }
        catch (Exception e) {
            throw Misc.processFunctionException("ReferencedKeyCheckerMessage#referencedKeyCheck", e, null, container.getRegion());
        }
        if (result != null && result.size() > 0) {
            assert (rkrc.size() == result.size());
            StandardException topEx = null;
            Throwable currSe = null;
            ArrayList<List<Object>> temp = new ArrayList<List<Object>>();
            temp.addAll(rkrc);
            for (List list : temp) {
                StandardException se = StandardException.newException("23503", list.get(0), (Object)container.getQualifiedTableName(), (Object)(forUpdate ? "UPDATE" : "DELETE"), (Object)(list.get(1) + " on member " + list.get(2)));
                if (topEx == null) {
                    topEx = se;
                    currSe = topEx;
                    continue;
                }
                currSe.initCause(se);
                currSe = se;
            }
            throw topEx;
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataValueDescriptor[] getKeyColumnValues(int listPosition) throws StandardException {
        if (this.keyColumnDVDs != null) {
            return this.keyColumnDVDs.get(listPosition);
        }
        DataValueDescriptor[] keys = null;
        int[] keyPositions = this.forUpdate ? this.refImpactedCols : this.container.getExtraTableInfo().getReferencedKeyColumns();
        RowLocation rowLoc = this.keyColumnLocations.get(listPosition);
        SimpleMemoryAllocatorImpl.skipRefCountTracking();
        Object rowValue = RegionEntryUtils.getByteSource(rowLoc, this.container, false, false);
        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
        if (rowValue != null) {
            keys = new DataValueDescriptor[keyPositions.length];
            Class<?> cls = rowValue.getClass();
            if (cls == byte[].class) {
                byte[] rowBytes = (byte[])rowValue;
                ExtraTableInfo tableInfo = rowLoc.getTableInfo(this.container);
                RowFormatter rf = tableInfo.getRowFormatter(rowBytes);
                rf.getColumns(rowBytes, keys, keyPositions);
            } else if (cls == byte[][].class) {
                byte[][] rowBytes = (byte[][])rowValue;
                ExtraTableInfo tableInfo = rowLoc.getTableInfo(this.container);
                RowFormatter rf = tableInfo.getRowFormatter(rowBytes[0]);
                rf.getColumns(rowBytes, keys, keyPositions);
            } else {
                OffHeapByteSource bs = null;
                try {
                    if (cls == OffHeapRow.class) {
                        OffHeapRow rowBS;
                        bs = rowBS = (OffHeapRow)((Object)rowValue);
                        ExtraTableInfo tableInfo = rowLoc.getTableInfo(this.container);
                        RowFormatter rf = tableInfo.getRowFormatter(rowBS);
                        rf.getColumns(rowBS, keys, keyPositions);
                    } else {
                        OffHeapRowWithLobs rowBS = (OffHeapRowWithLobs)((Object)rowValue);
                        bs = rowBS;
                        ExtraTableInfo tableInfo = rowLoc.getTableInfo(this.container);
                        RowFormatter rf = tableInfo.getRowFormatter(rowBS);
                        rf.getColumns(rowBS, keys, keyPositions);
                    }
                }
                finally {
                    if (bs != null) {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        bs.release();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                }
            }
        }
        return keys;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    protected boolean requiresTXFlushBeforeExecution() {
        return false;
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return this.getLockingPolicy().readOnlyCanStartTX();
    }

    @Override
    public Set<DistributedMember> getMembers() {
        this.hostedBuckets.clear();
        HashSet<DistributedMember> allRecips = new HashSet<DistributedMember>();
        InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
        for (GemFireContainer container : this.refContainers) {
            LocalRegion refRegion = container.getRegion();
            if (refRegion.getPartitionAttributes() != null) {
                PartitionedRegion pr = (PartitionedRegion)refRegion;
                RegionAdvisor advisor = pr.getRegionAdvisor();
                RegionExecutorMessage.HashMapOrSet map = new RegionExecutorMessage.HashMapOrSet(true, (LocalRegion)pr);
                advisor.accept(RegionExecutorMessage.collectPrimaries, (Object)map);
                this.hostedBuckets.put((Object)container, (Object)map);
                allRecips.addAll(map.keySet());
                continue;
            }
            if (refRegion.getScope().isLocal()) continue;
            HashSet<InternalDistributedMember> recips = ((DistributedRegion)refRegion).getCacheDistributionAdvisor().adviseInitializedReplicates();
            if (refRegion.getDataPolicy().withReplication()) {
                if (recips.size() == 0) {
                    recips = new HashSet<InternalDistributedMember>(2);
                }
                recips.add(myId);
            }
            boolean foundMember = false;
            for (Object e : recips) {
                if (!allRecips.contains(e)) continue;
                foundMember = true;
                break;
            }
            if (foundMember) continue;
            if (refRegion.getDataPolicy().withReplication()) {
                allRecips.add((DistributedMember)myId);
                continue;
            }
            Iterator iter = recips.iterator();
            if (iter.hasNext()) {
                allRecips.add((DistributedMember)iter.next());
                continue;
            }
            if (!GemFireXDUtils.isPersistent(refRegion)) continue;
            throw new NoDataStoreAvailableException(LocalizedStrings.DistributedRegion_NO_DATA_STORE_FOUND_FOR_DISTRIBUTION.toLocalizedString(new Object[]{refRegion}));
        }
        return allRecips;
    }

    @Override
    public void postExecutionCallback() {
        this.hostedBuckets.forEachEntry(postExecutionProc);
    }

    @Override
    protected ReferencedKeyCheckerMessage clone() {
        return new ReferencedKeyCheckerMessage(this);
    }

    @Override
    public byte getGfxdID() {
        return 43;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int columns;
        super.fromData(in);
        this.schemaName = DataSerializer.readString((DataInput)in);
        this.tableName = DataSerializer.readString((DataInput)in);
        this.numColumns = columns = InternalDataSerializer.readArrayLength((DataInput)in);
        boolean hasDVDs = in.readBoolean();
        if (hasDVDs) {
            boolean refColSameAfterModFlag;
            this.forUpdate = in.readBoolean();
            if (this.forUpdate) {
                this.refImpactedCols = new int[columns];
                for (int i = 0; i < columns; ++i) {
                    this.refImpactedCols[i] = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
                }
                byte[] refColsUpdtd = new byte[FormatableBitSet.numBytesFromBits(this.refImpactedCols.length)];
                for (int i = 0; i < refColsUpdtd.length; ++i) {
                    refColsUpdtd[i] = in.readByte();
                }
                this.refColsUpdtdBits = new FormatableBitSet(refColsUpdtd);
            }
            int rows = InternalDataSerializer.readArrayLength((DataInput)in);
            this.keyColumnDVDs = new ArrayList(rows);
            for (int i = 0; i < rows; ++i) {
                DataValueDescriptor[] row = new DataValueDescriptor[columns];
                for (int j = 0; j < columns; ++j) {
                    row[j] = DataType.readDVD(in);
                }
                this.keyColumnDVDs.add(row);
            }
            if (this.forUpdate && (refColSameAfterModFlag = in.readBoolean())) {
                int numElements = in.readInt();
                this.refColSameAfterModBitsMapping = IntObjectHashMap.withExpectedSize((int)numElements);
                int byteArraySize = FormatableBitSet.numBytesFromBits(this.refColsUpdtdBits.getNumBitsSet());
                for (int i = 0; i < numElements; ++i) {
                    int rowNum = in.readInt();
                    byte[] bytes = new byte[byteArraySize];
                    for (int j = 0; j < byteArraySize; ++j) {
                        bytes[j] = in.readByte();
                    }
                    this.refColSameAfterModBitsMapping.justPut(rowNum, (Object)bytes);
                }
            }
        } else {
            int rows = InternalDataSerializer.readArrayLength((DataInput)in);
            this.keyRows = new ArrayList(rows);
            this.keyColumnDVDs = null;
            for (int index = 0; index < rows; ++index) {
                this.keyRows.add(DataSerializer.readByteArray((DataInput)in));
            }
        }
        this.connectionId = GemFireXDUtils.readCompressedHighLow(in);
        if (this.timeStatsEnabled) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        this.refColSameAfterModBitsMapping = null;
        long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        DataSerializer.writeString((String)this.schemaName, (DataOutput)out);
        DataSerializer.writeString((String)this.tableName, (DataOutput)out);
        ExtraTableInfo tableInfo = this.container.getExtraTableInfo();
        int[] keyPositions = this.forUpdate ? this.refImpactedCols : tableInfo.getReferencedKeyColumns();
        InternalDataSerializer.writeArrayLength((int)keyPositions.length, (DataOutput)out);
        if (this.keyColumnDVDs != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.forUpdate);
            if (this.forUpdate) {
                for (int refCol : this.refImpactedCols) {
                    InternalDataSerializer.writeUnsignedVL((long)refCol, (DataOutput)out);
                }
                for (byte bits : this.refColsUpdtdBits.getByteArray()) {
                    out.writeByte(bits);
                }
            }
            InternalDataSerializer.writeArrayLength((int)this.keyColumnDVDs.size(), (DataOutput)out);
            if (this.forUpdate) {
                FormatableBitSet formatableBitSet = new FormatableBitSet(this.refImpactedCols.length);
                for (int index = 0; index < this.keyColumnDVDs.size(); ++index) {
                    formatableBitSet.clear();
                    DataValueDescriptor[] dvdArray = this.keyColumnDVDs.get(index);
                    this.identifyUpdatedColsUnchangedAndColsToWrite(dvdArray, formatableBitSet, index);
                    for (int i = 0; i < this.refImpactedCols.length; ++i) {
                        int colNum = this.refImpactedCols[i];
                        boolean shouldWriteValue = formatableBitSet.get(i);
                        int posInExecRow = this.getIndexInLocalDVDRow(colNum);
                        DataValueDescriptor old = dvdArray[posInExecRow];
                        if (shouldWriteValue) {
                            old.toData(out);
                            continue;
                        }
                        old.writeNullDVD(out);
                    }
                }
                if (this.refColSameAfterModBitsMapping != null) {
                    out.writeBoolean(true);
                    out.writeInt(this.refColSameAfterModBitsMapping.size());
                    this.refColSameAfterModBitsMapping.forEachWhile((rowNum, refColSameAfterUpdt) -> {
                        try {
                            out.writeInt(rowNum);
                            for (byte b : refColSameAfterUpdt) {
                                out.writeByte(b);
                            }
                            return true;
                        }
                        catch (IOException ioe) {
                            throw new GemFireIOException(ioe.getMessage(), (Throwable)ioe);
                        }
                    });
                } else {
                    out.writeBoolean(false);
                }
            } else {
                void var6_9;
                boolean bl = false;
                while (var6_9 < this.keyColumnDVDs.size()) {
                    for (DataValueDescriptor dvd : this.keyColumnDVDs.get((int)var6_9)) {
                        dvd.toData(out);
                    }
                    ++var6_9;
                }
            }
        } else {
            out.writeBoolean(false);
            assert (!this.forUpdate);
            RowFormatter rowFormatter = tableInfo.getReferencedKeyRowFormatter();
            int[] fixedPositions = tableInfo.getReferencedKeyFixedColumns();
            int[] varPositions = tableInfo.getReferencedKeyVarColumns();
            int rows = this.keyColumnLocations.size();
            InternalDataSerializer.writeArrayLength((int)rows, (DataOutput)out);
            for (int index = 0; index < rows; ++index) {
                RowLocation rowLoc = this.keyColumnLocations.get(index);
                Object rowValue = RegionEntryUtils.getByteSource(rowLoc, this.container, false, false);
                OffHeapByteSource rowBS = null;
                try {
                    if (rowValue != null && (tableInfo = rowLoc.getTableInfo(this.container)) != null) {
                        RowFormatter rf;
                        byte[] rowBytes;
                        Class<?> cls = rowValue.getClass();
                        if (cls == byte[].class) {
                            rowBytes = (byte[])rowValue;
                            rf = tableInfo.getRowFormatter(rowBytes);
                            rf.serializeColumns(rowBytes, out, fixedPositions, varPositions, rowFormatter.getNumOffsetBytes(), rowFormatter.getOffsetDefaultToken(), rowFormatter);
                            continue;
                        }
                        if (cls == byte[][].class) {
                            rowBytes = ((byte[][])rowValue)[0];
                            rf = tableInfo.getRowFormatter(rowBytes);
                            rf.serializeColumns(rowBytes, out, fixedPositions, varPositions, rowFormatter.getNumOffsetBytes(), rowFormatter.getOffsetDefaultToken(), rowFormatter);
                            continue;
                        }
                        rowBS = (OffHeapByteSource)((Object)rowValue);
                        rf = tableInfo.getRowFormatter(rowBS);
                        rf.serializeColumns(rowBS, out, fixedPositions, varPositions, rowFormatter.getNumOffsetBytes(), rowFormatter.getOffsetDefaultToken(), rowFormatter);
                        continue;
                    }
                    DataSerializer.writeByteArray(null, (DataOutput)out);
                    continue;
                }
                finally {
                    if (rowBS != null) {
                        rowBS.release();
                    }
                }
            }
        }
        GemFireXDUtils.writeCompressedHighLow(out, this.connectionId);
        if (begintime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
        }
    }

    private void identifyUpdatedColsUnchangedAndColsToWrite(DataValueDescriptor[] dvdArray, FormatableBitSet colsToWritePerRow, int rowNum) {
        int pos = this.refColsUpdtdBits.anySetBit();
        int j = 0;
        byte[] refColSameAfterUpdt = null;
        while (pos != -1) {
            DataValueDescriptor modified;
            int colNum = this.refImpactedCols[pos];
            int posInExecRow = this.refCol2DVDPosMapping != null ? this.refCol2DVDPosMapping[colNum - 1] : colNum - 1;
            DataValueDescriptor old = dvdArray[posInExecRow];
            if (old.equals(modified = dvdArray[(dvdArray.length - 1) / 2 + posInExecRow])) {
                if (this.refColSameAfterModBitsMapping == null) {
                    this.refColSameAfterModBitsMapping = IntObjectHashMap.withExpectedSize((int)8);
                }
                if (refColSameAfterUpdt == null) {
                    int numCols = this.refColUpdtd2DependentCols.size();
                    refColSameAfterUpdt = new byte[FormatableBitSet.numBytesFromBits(numCols)];
                    this.refColSameAfterModBitsMapping.justPut(rowNum, (Object)refColSameAfterUpdt);
                }
                int byteIndex = FormatableBitSet.udiv8(j);
                byte bitIndex = FormatableBitSet.umod8(j);
                int n = byteIndex;
                refColSameAfterUpdt[n] = (byte)(refColSameAfterUpdt[n] | 128 >> bitIndex);
            } else {
                TIntHashSet dependentCols = (TIntHashSet)this.refColUpdtd2DependentCols.get(colNum);
                for (int colToWrite : dependentCols) {
                    colsToWritePerRow.set(this.refCol2IndexMap.get(colToWrite));
                }
                colsToWritePerRow.set(this.refCol2IndexMap.get(colNum));
            }
            ++j;
            pos = this.refColsUpdtdBits.anySetBit(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendFields(StringBuilder sb) {
        int index;
        super.appendFields(sb);
        sb.append(";table=").append(this.schemaName).append('.').append(this.tableName);
        sb.append(";connectionId=").append(this.connectionId);
        sb.append(";forUpdate=").append(this.forUpdate);
        if (this.forUpdate) {
            sb.append(";Reference updates cols positions=");
            for (int col : this.refImpactedCols) {
                sb.append("" + col + ",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("RefColsUpdtd flag = " + this.refColsUpdtdBits);
        }
        sb.append(";keys=");
        if (this.keyColumnDVDs != null) {
            int numKeys = this.keyColumnDVDs.size();
            if (numKeys <= 10) {
                for (index = 0; index < numKeys; ++index) {
                    if (index > 0) {
                        sb.append(':');
                    }
                    if (this.forUpdate) {
                        Object[] dvdArray = this.keyColumnDVDs.get(index);
                        String str = this.refCol2DVDPosMapping != null ? this.generateForUpdateString((DataValueDescriptor[])dvdArray) : RowUtil.toString(dvdArray);
                        sb.append(str);
                        continue;
                    }
                    sb.append(RowUtil.toString(this.keyColumnDVDs.get(index)));
                }
            } else {
                sb.append(numKeys).append(" keys");
            }
        } else if (this.keyRows != null) {
            int numKeys = this.keyRows.size();
            if (numKeys <= 10) {
                for (index = 0; index < numKeys; ++index) {
                    byte[] keyRow;
                    if (index > 0) {
                        sb.append("::");
                    }
                    if ((keyRow = this.keyRows.get(index)) != null) {
                        sb.append(ClientSharedUtils.toHexString((byte[])keyRow, (int)0, (int)keyRow.length));
                        continue;
                    }
                    sb.append("null");
                }
            } else {
                sb.append(numKeys).append(" keys");
            }
        } else {
            int numKeys = this.keyColumnLocations.size();
            if (numKeys <= 10) {
                int[] keyPositions = this.forUpdate ? this.refImpactedCols : this.container.getExtraTableInfo().getReferencedKeyColumns();
                Object[] keys = new DataValueDescriptor[keyPositions.length];
                for (int index2 = 0; index2 < this.keyColumnLocations.size(); ++index2) {
                    if (index2 > 0) {
                        sb.append(':');
                    }
                    RowLocation rowLoc = this.keyColumnLocations.get(index2);
                    try {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        Object rowValue = RegionEntryUtils.getByteSource(rowLoc, this.container, false, false);
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                        if (rowValue != null) {
                            RowFormatter rf;
                            ExtraTableInfo tableInfo;
                            Object rowBytes;
                            Class<?> cls = rowValue.getClass();
                            if (cls == byte[].class) {
                                rowBytes = (byte[])rowValue;
                                tableInfo = rowLoc.getTableInfo(this.container);
                                rf = tableInfo.getRowFormatter((byte[])rowBytes);
                                rf.getColumns((byte[])rowBytes, (DataValueDescriptor[])keys, keyPositions);
                                continue;
                            }
                            if (cls == byte[][].class) {
                                rowBytes = (byte[][])rowValue;
                                tableInfo = rowLoc.getTableInfo(this.container);
                                rf = tableInfo.getRowFormatter((byte[])rowBytes[0]);
                                rf.getColumns((byte[][])rowBytes, (DataValueDescriptor[])keys, keyPositions);
                                continue;
                            }
                            OffHeapByteSource bs = null;
                            try {
                                OffHeapByteSource rowBS;
                                if (cls == OffHeapRow.class) {
                                    bs = rowBS = (OffHeapRow)((Object)rowValue);
                                    tableInfo = rowLoc.getTableInfo(this.container);
                                    rf = tableInfo.getRowFormatter(rowBS);
                                    rf.getColumns((OffHeapRow)rowBS, (DataValueDescriptor[])keys, keyPositions);
                                } else {
                                    bs = rowBS = (OffHeapRowWithLobs)((Object)rowValue);
                                    tableInfo = rowLoc.getTableInfo(this.container);
                                    rf = tableInfo.getRowFormatter(rowBS);
                                    rf.getColumns((OffHeapRowWithLobs)rowBS, (DataValueDescriptor[])keys, keyPositions);
                                }
                                sb.append(RowUtil.toString(keys));
                                continue;
                            }
                            finally {
                                if (bs != null) {
                                    SimpleMemoryAllocatorImpl.skipRefCountTracking();
                                    bs.release();
                                    SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                                }
                            }
                        }
                        sb.append("(null)");
                        continue;
                    }
                    catch (StandardException se) {
                        sb.append("(null)");
                    }
                }
            } else {
                sb.append(numKeys).append(" keys");
            }
        }
    }

    private String generateForUpdateString(DataValueDescriptor[] dvdArray) {
        Object[] out = new DataValueDescriptor[this.refImpactedCols.length];
        for (int i = 0; i < this.refImpactedCols.length; ++i) {
            int colNum = this.refImpactedCols[i];
            int posInExecRow = this.refCol2DVDPosMapping[colNum - 1];
            out[i] = dvdArray[posInExecRow];
        }
        return RowUtil.toString(out);
    }

    public static void openReferencedContainersForRead(GemFireTransaction tran, GemFireContainer[] refContainers) throws StandardException {
        for (int index = 0; index < refContainers.length; ++index) {
            refContainers[index].open(tran, 8);
        }
    }

    public static void closeReferencedContainersAfterRead(GemFireTransaction tran, GemFireContainer[] refContainers) throws StandardException {
        for (int index = 0; index < refContainers.length; ++index) {
            refContainers[index].closeForEndTransaction(tran, false);
        }
    }

    public static final class ReferencedKeyReplyMessage
    extends GfxdReplyMessage {
        private boolean success;

        public ReferencedKeyReplyMessage() {
        }

        public ReferencedKeyReplyMessage(boolean success) {
            this.success = success;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, boolean success) {
            Assert.assertTrue((recipient != null ? 1 : 0) != 0, (Object)"Sending a ReplyMessage to ALL");
            ReferencedKeyReplyMessage m = new ReferencedKeyReplyMessage(success);
            m.processorId = processorId;
            m.setRecipient(recipient);
            InternalDistributedMember self = Misc.getMyId();
            if (self.equals(recipient)) {
                m.setSender(self);
                ReplyProcessor21 processor = ReplyProcessor21.getProcessor((int)processorId);
                if (processor != null) {
                    processor.process((DistributionMessage)m);
                } else {
                    SanityManager.THROWASSERT((String)("unexpected null reply processor for processorId=" + processorId));
                }
            } else {
                dm.putOutgoing((DistributionMessage)m);
            }
        }

        @Override
        public byte getGfxdID() {
            return 22;
        }

        @Override
        public GfxdResponseCode getResponseCode() {
            return this.success ? GfxdResponseCode.GRANT(1) : GfxdResponseCode.EXCEPTION;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.success);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.success = in.readBoolean();
        }
    }

    public static final class ReferencedKeyReplyProcessor
    extends ReplyProcessor21 {
        private volatile boolean success;

        public ReferencedKeyReplyProcessor(DM dm, InternalDistributedMember origin) {
            super(dm, origin);
        }

        public void process(DistributionMessage msg) {
            if (msg instanceof ReferencedKeyReplyMessage) {
                this.success = ((ReferencedKeyReplyMessage)msg).getResponseCode().isGrant();
            }
            super.process(msg);
        }

        protected boolean allowReplyFromSender() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForResult() throws StandardException {
            block8: {
                Throwable thr = null;
                try {
                    super.waitForReplies();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    Misc.checkIfCacheClosing(ie);
                    thr = ie;
                    return (boolean)thr;
                }
                catch (Throwable t) {
                    Error err;
                    if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                        SystemFailure.initiateFailure((Error)err);
                        throw err;
                    }
                    SystemFailure.checkFailure();
                    thr = t;
                    return (boolean)thr;
                }
                finally {
                    if (thr == null) break block8;
                    DM dm = this.getDistributionManager();
                    dm.getCancelCriterion().checkCancelInProgress(thr);
                    dm.getLoggerI18n().info(LocalizedStrings.DEBUG, (Object)("ReferencedKeyReplyProcessor: unexpected exception while waiting for reply from " + this.membersToString()), thr);
                    return false;
                }
            }
            return this.success;
        }
    }

    private static class ReferencedKeyResultCollector
    extends ArrayList<List<Object>>
    implements ResultCollector<Object, ArrayList<List<Object>>> {
        private static final long serialVersionUID = -1479391066460153172L;

        private ReferencedKeyResultCollector() {
        }

        public void addResult(DistributedMember memberId, Object resultOfSingleExecution) {
            if (resultOfSingleExecution instanceof List) {
                List failure = (List)resultOfSingleExecution;
                failure.add(memberId.toString());
                this.add(failure);
            }
        }

        public ArrayList<List<Object>> getResult() throws FunctionException {
            return this;
        }

        public ArrayList<List<Object>> getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            throw new AssertionError((Object)"getResult with timeout not expected to be invoked for GemFireXD");
        }

        public void clearResults() {
            this.clear();
        }

        public void endResults() {
        }
    }
}

