/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.callbacks;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.EventErrorHandler;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.callbacks.EventCallback;
import com.pivotal.gemfirexd.callbacks.GatewayEventErrorHandler;
import com.pivotal.gemfirexd.callbacks.RowLoader;
import com.pivotal.gemfirexd.callbacks.impl.GatewayConflictResolverWrapper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheListener;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheWriter;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdAddListenerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdRemoveGatewayConflictResolverMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdRemoveGatewayEventErrorHandlerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdRemoveListenerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdRemoveLoaderMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdRemoveWriterMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdSetGatewayConflictResolverMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdSetGatewayEventErrorHandlerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdSetLoaderMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages.GfxdSetWriterMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.store.EventErrorHandlerWrapper;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;

public class CallbackProcedures {
    private static final ConcurrentHashMap<String, GfxdCacheListener> idListenerMap = new ConcurrentHashMap();

    public static void addGfxdCacheListener(String id, String schemaName, String tableName, String implementation, String initInfo, String serverGroups) throws StandardException {
        InternalDistributedMember myId;
        if (tableName == null || id == null || implementation == null) {
            throw StandardException.newException("XIE06.S");
        }
        GemFireContainer container = CallbackProcedures.getContainerForTable(schemaName, tableName);
        Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
        boolean self = members.remove(myId = Misc.getGemFireCache().getMyId());
        if (self) {
            CallbackProcedures.addGfxdCacheListenerLocally(id, container, implementation, initInfo, serverGroups);
        }
        GfxdAddListenerMessage listenerMsg = new GfxdAddListenerMessage(id, container.getSchemaName(), container.getTableName(), implementation, initInfo, serverGroups);
        try {
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            listenerMsg.setReplayKey(replayKey);
            queue.put(replayKey, listenerMsg);
            listenerMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z25.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void addGfxdCacheListenerLocally(String id, GemFireContainer container, String implementation, String initInfo, String serverGroups) throws StandardException {
        if (CallbackProcedures.skipExecutionForGroupsAndTable(serverGroups, container)) {
            return;
        }
        LocalRegion region = container.getRegion();
        AttributesMutator mutator = region.getAttributesMutator();
        try {
            EventCallback ecb = (EventCallback)ClassPathLoader.getLatest().forName(implementation).newInstance();
            ecb.init(initInfo);
            GfxdCacheListener aListener = new GfxdCacheListener(id, ecb);
            id = Misc.getFullTableName(container.getSchemaName(), id, null);
            GfxdCacheListener prevListener = idListenerMap.putIfAbsent(id, aListener);
            if (prevListener != null) {
                throw Util.newEmbedSQLException("X0Y32.S", new Object[]{"listener", id, "schema", container.getSchemaName()}, null);
            }
            mutator.addCacheListener((CacheListener)aListener);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z25.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void addGfxdCacheWriter(String schemaName, String tableName, String implementation, String initInfo, String serverGroups) throws StandardException {
        InternalDistributedMember myId;
        if (tableName == null || implementation == null) {
            throw StandardException.newException("XIE06.S");
        }
        GemFireContainer container = CallbackProcedures.getContainerForTable(schemaName, tableName);
        GfxdSetWriterMessage writerMsg = new GfxdSetWriterMessage(container.getSchemaName(), container.getTableName(), implementation, initInfo, serverGroups);
        Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
        boolean self = members.remove(myId = Misc.getGemFireCache().getMyId());
        if (self) {
            CallbackProcedures.addGfxdCacheWriterLocally(container, implementation, initInfo, serverGroups);
        }
        try {
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            writerMsg.setReplayKey(replayKey);
            queue.put(replayKey, writerMsg);
            writerMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z24.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void addGfxdCacheWriterLocally(GemFireContainer container, String implementation, String initInfo, String serverGroups) throws StandardException {
        if (CallbackProcedures.skipExecutionForGroupsAndTable(serverGroups, container)) {
            return;
        }
        LocalRegion reg = container.getRegion();
        AttributesMutator mutator = reg.getAttributesMutator();
        try {
            EventCallback ecb = (EventCallback)ClassPathLoader.getLatest().forName(implementation).newInstance();
            ecb.init(initInfo);
            GfxdCacheWriter writer = new GfxdCacheWriter(ecb);
            mutator.setCacheWriter((CacheWriter)writer);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z24.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void addGfxdGatewayConflictResolver(String implementation, String initInfo) throws StandardException {
        if (implementation == null) {
            throw StandardException.newException("XIE06.S");
        }
        try {
            Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
            InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
            boolean self = members.remove(myId);
            if (self) {
                CallbackProcedures.addGfxdGatewayConflictResolverLocally(implementation, initInfo);
            }
            GfxdSetGatewayConflictResolverMessage resolverMsg = new GfxdSetGatewayConflictResolverMessage(implementation, initInfo);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            resolverMsg.setReplayKey(replayKey);
            queue.put(replayKey, resolverMsg);
            resolverMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z28.S", (Throwable)ex, (Object)ex.toString());
        }
    }

    public static void addGfxdGatewayConflictResolverLocally(String implementation, String initInfo) throws StandardException {
        try {
            com.pivotal.gemfirexd.callbacks.impl.GatewayConflictResolver resolver = (com.pivotal.gemfirexd.callbacks.impl.GatewayConflictResolver)ClassPathLoader.getLatest().forName(implementation).newInstance();
            resolver.init(initInfo);
            GatewayConflictResolverWrapper wrapper = new GatewayConflictResolverWrapper(resolver);
            Misc.getGemFireCache().setGatewayConflictResolver((GatewayConflictResolver)wrapper);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z28.S", (Throwable)ex, (Object)ex.toString());
        }
    }

    public static void addGfxdGatewayEventErrorHandler(String implementation, String initInfo) throws StandardException {
        if (implementation == null) {
            throw StandardException.newException("XIE06.S");
        }
        try {
            Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
            InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
            boolean self = members.remove(myId);
            if (self) {
                CallbackProcedures.addGfxdGatewayEventErrorHandlerLocally(implementation, initInfo);
            }
            GfxdSetGatewayEventErrorHandlerMessage handlerMsg = new GfxdSetGatewayEventErrorHandlerMessage(implementation, initInfo);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            handlerMsg.setReplayKey(replayKey);
            queue.put(replayKey, handlerMsg);
            handlerMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z31.S", (Throwable)ex, (Object)ex.toString());
        }
    }

    public static void addGfxdGatewayEventErrorHandlerLocally(String implementation, String initInfo) throws StandardException {
        try {
            GatewayEventErrorHandler handler = (GatewayEventErrorHandler)ClassPathLoader.getLatest().forName(implementation).newInstance();
            handler.init(initInfo);
            EventErrorHandler internalHandler = Misc.getGemFireCache().getEventErrorHandler();
            if (internalHandler instanceof EventErrorHandlerWrapper) {
                EventErrorHandlerWrapper wrapper = (EventErrorHandlerWrapper)internalHandler;
                wrapper.setCustomGatewayEventErrorHandler(handler);
            }
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z31.S", (Throwable)ex, (Object)ex.toString());
        }
    }

    public static void removeGfxdGatewayConflictResolver() throws StandardException {
        try {
            Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
            InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
            boolean self = members.remove(myId);
            if (self) {
                CallbackProcedures.removeGfxdGatewayConflictResolverLocally();
            }
            GfxdRemoveGatewayConflictResolverMessage resolverMsg = new GfxdRemoveGatewayConflictResolverMessage();
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            resolverMsg.setReplayKey(replayKey);
            queue.put(replayKey, resolverMsg);
            resolverMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z28.S", (Throwable)ex, (Object)ex.toString());
        }
    }

    public static void removeGfxdGatewayConflictResolverLocally() throws StandardException {
        Misc.getGemFireCache().setGatewayConflictResolver(null);
    }

    public static void removeGfxdGatewayEventErrorHandler() throws StandardException {
        try {
            Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
            InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
            boolean self = members.remove(myId);
            if (self) {
                CallbackProcedures.removeGfxdGatewayEventErrorHandlerLocally();
            }
            GfxdRemoveGatewayEventErrorHandlerMessage handlerMsg = new GfxdRemoveGatewayEventErrorHandlerMessage();
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            handlerMsg.setReplayKey(replayKey);
            queue.put(replayKey, handlerMsg);
            handlerMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z31.S", (Throwable)ex, (Object)ex.toString());
        }
    }

    public static void removeGfxdGatewayEventErrorHandlerLocally() throws StandardException {
        EventErrorHandler internalHandler = Misc.getGemFireCache().getEventErrorHandler();
        if (internalHandler instanceof EventErrorHandlerWrapper) {
            EventErrorHandlerWrapper wrapper = (EventErrorHandlerWrapper)internalHandler;
            wrapper.setCustomGatewayEventErrorHandler(null);
        }
    }

    public static void addGfxdCacheLoader(String schemaName, String tableName, String implementation, String initInfo) throws StandardException {
        if (tableName == null || implementation == null) {
            throw StandardException.newException("XIE06.S");
        }
        GemFireContainer container = CallbackProcedures.getContainerForTable(schemaName, tableName);
        try {
            Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
            InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
            boolean self = members.remove(myId);
            if (self) {
                CallbackProcedures.addGfxdCacheLoaderLocally(container, implementation, initInfo);
            }
            GfxdSetLoaderMessage loaderMsg = new GfxdSetLoaderMessage(container.getSchemaName(), container.getTableName(), implementation, initInfo);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            loaderMsg.setReplayKey(replayKey);
            queue.put(replayKey, loaderMsg);
            loaderMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z26.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void addGfxdCacheLoaderLocally(GemFireContainer container, String implementation, String initInfo) throws StandardException {
        LocalRegion reg = container.getRegion();
        LogWriter logger = Misc.getCacheLogWriter();
        if (logger.fineEnabled()) {
            logger.fine("CallbackProcedures::addGfxdCacheLoaderLocally: setting loader info as true for container=" + container);
        }
        container.setLoaderInstalled(true);
        if (CallbackProcedures.skipExecutionForGroupsAndTable(null, container)) {
            return;
        }
        try {
            AttributesMutator mutator = reg.getAttributesMutator();
            RowLoader rldr = (RowLoader)ClassPathLoader.getLatest().forName(implementation).newInstance();
            rldr.init(initInfo);
            GfxdCacheLoader loader = new GfxdCacheLoader(container.getSchemaName(), container.getTableName(), rldr);
            TableDescriptor td = container.getTableDescriptor();
            assert (td != null);
            loader.setTableDetails(td);
            mutator.setCacheLoader((CacheLoader)loader);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z26.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void removeGfxdCacheListener(String id, String schemaName, String tableName) throws StandardException {
        if (tableName == null || id == null) {
            throw StandardException.newException("XIE06.S");
        }
        GemFireContainer container = CallbackProcedures.getContainerForTable(schemaName, tableName);
        Set<DistributedMember> members = GfxdMessage.getOtherMembers();
        CallbackProcedures.removeGfxdCacheListenerLocally(id, container);
        GfxdRemoveListenerMessage removeMsg = new GfxdRemoveListenerMessage(id, container.getSchemaName(), container.getTableName());
        try {
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            removeMsg.setReplayKey(replayKey);
            queue.put(replayKey, removeMsg);
            removeMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z25.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void removeGfxdCacheListenerLocally(String id, GemFireContainer container) throws StandardException {
        id = Misc.getFullTableName(container.getSchemaName(), id, null);
        GfxdCacheListener aListener = idListenerMap.remove(id);
        if (aListener == null) {
            return;
        }
        LocalRegion reg = container.getRegion();
        try {
            AttributesMutator mutator = reg.getAttributesMutator();
            mutator.removeCacheListener((CacheListener)aListener);
            aListener.close();
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z25.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void removeGfxdCacheWriter(String schemaName, String tableName) throws StandardException {
        if (tableName == null) {
            throw StandardException.newException("XIE06.S");
        }
        GemFireContainer container = CallbackProcedures.getContainerForTable(schemaName, tableName);
        Set<DistributedMember> members = GfxdMessage.getOtherMembers();
        CallbackProcedures.removeGfxdCacheWriterLocally(container);
        GfxdRemoveWriterMessage removeMsg = new GfxdRemoveWriterMessage(container.getSchemaName(), container.getTableName());
        try {
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            removeMsg.setReplayKey(replayKey);
            queue.put(replayKey, removeMsg);
            removeMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z24.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void removeGfxdCacheWriterLocally(GemFireContainer container) throws StandardException {
        LocalRegion reg = container.getRegion();
        CacheWriter prevWriter = reg.getAttributes().getCacheWriter();
        if (prevWriter == null) {
            return;
        }
        try {
            AttributesMutator mutator = reg.getAttributesMutator();
            mutator.setCacheWriter(null);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z24.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void removeGfxdCacheLoader(String schemaName, String tableName) throws StandardException {
        if (tableName == null) {
            throw StandardException.newException("XIE06.S");
        }
        GemFireContainer container = CallbackProcedures.getContainerForTable(schemaName, tableName);
        Set<DistributedMember> members = GfxdMessage.getOtherMembers();
        CallbackProcedures.removeGfxdCacheLoaderLocally(container);
        GfxdRemoveLoaderMessage removeMsg = new GfxdRemoveLoaderMessage(container.getSchemaName(), container.getTableName());
        try {
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            removeMsg.setReplayKey(replayKey);
            queue.put(replayKey, removeMsg);
            removeMsg.send(Misc.getDistributedSystem(), members);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z26.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void removeGfxdCacheLoaderLocally(GemFireContainer container) throws StandardException {
        LocalRegion reg = container.getRegion();
        CacheLoader prevLoader = reg.getAttributes().getCacheLoader();
        if (prevLoader == null) {
            return;
        }
        try {
            AttributesMutator mutator = reg.getAttributesMutator();
            mutator.setCacheLoader(null);
            container.setLoaderInstalled(false);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z26.S", ex, (Object)container.getQualifiedTableName(), (Object)ex.toString());
        }
    }

    public static void dummy() {
    }

    public static void clearStatics() {
        idListenerMap.clear();
    }

    public static GemFireContainer getContainerForTable(String schemaName, String tableName) throws StandardException {
        GemFireContainer container;
        Region reg;
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = Misc.getDefaultSchemaName(null);
        }
        if ((reg = Misc.getRegionByPath(Misc.getRegionPath(schemaName, tableName, null), false)) == null || (container = (GemFireContainer)reg.getUserAttribute()) == null) {
            if (schemaName != null && schemaName.length() > 0) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if ((reg = Misc.getRegionByPath(Misc.getRegionPath(schemaName, tableName = StringUtil.SQLToUpperCase(tableName), null), false)) == null || (container = (GemFireContainer)reg.getUserAttribute()) == null) {
                throw StandardException.newException("42X05", Misc.getFullTableName(schemaName, tableName, null));
            }
        }
        return container;
    }

    public static boolean skipExecutionForGroupsAndTable(String groups, GemFireContainer container) throws StandardException {
        SortedSet<String> serverGroups;
        if (groups != null && groups.length() > 0 && !ServerGroupUtils.isGroupMember((Set<String>)(serverGroups = SharedUtils.toSortedSet((String)groups, (boolean)false)))) {
            return true;
        }
        if (container != null) {
            TableDescriptor td = container.getTableDescriptor();
            if (td == null || !container.isDataStore()) {
                return true;
            }
            serverGroups = td.getDistributionDescriptor().getServerGroups();
            if (!ServerGroupUtils.isGroupMember(serverGroups)) {
                return true;
            }
        }
        return false;
    }
}

