/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerateController;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexCostController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.ConglomerateUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public abstract class MemIndex
extends DataType
implements MemConglomerate {
    private static final long serialVersionUID = 1L;
    public static final String LOCAL_HASH_INDEX = "Hash1Index";
    public static final String LOCAL_SORTED_MAP_INDEX = "SortedMap2Index";
    public static final String GLOBAL_HASH_INDEX = "GlobalHashIndex";
    public static final String PROPERTY_BASECONGLOMID = "baseConglomerateId";
    public static final String PROPERTY_INDEX_COMPARATOR = "indexComparator";
    public static final String PROPERTY_EXTRA_INDEX_INFO = "extraIndexInfo";
    public static final String PROPERTY_ROWLOCCOLUMN = "rowLocationColumn";
    public static final String PROPERTY_NUNIQUECOLUMNS = "nUniqueColumns";
    public static final String PROPERTY_NKEYFIELDS = "nKeyFields";
    public static final String PROPERTY_UNIQUEWITHDUPLICATENULLS = "uniqueWithDuplicateNulls";
    public static final String PROPERTY_DDINDEX = "ddIndex";
    protected ContainerKey id;
    protected GemFireContainer container;
    protected int[] format_ids;
    protected GemFireContainer baseContainer;
    protected transient Transaction tran;
    protected boolean[] ascDescInfo;
    protected int[] collation_ids;
    protected int keyColumns;
    protected int rowLocationColumn;
    protected boolean unique;
    protected boolean uniqueWithDuplicateNulls;
    protected long estimatedRowsize;
    private boolean ddIndex;

    @Override
    public final void create(GemFireTransaction tran, int segmentId, long containerId, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int tmpFlag) throws StandardException {
        this.tran = tran;
        if (containerId < 0L) {
            throw StandardException.newException("XSCH0.S");
        }
        this.id = ContainerKey.valueOf(segmentId, containerId);
        if (template == null || template.length == 0) {
            throw StandardException.newException("XSCH4.S");
        }
        this.format_ids = ConglomerateUtil.createFormatIds(template);
        this.collation_ids = ConglomerateUtil.createCollationIds(this.format_ids.length, collationIds);
        String property_value = null;
        property_value = properties.getProperty(PROPERTY_BASECONGLOMID);
        if (property_value == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        ContainerKey baseConglomerateId = ContainerKey.valueOf(0L, Long.parseLong(property_value));
        this.baseContainer = Misc.getMemStore().getContainer(baseConglomerateId);
        this.ascDescInfo = new boolean[template.length];
        for (int i = 0; i < this.ascDescInfo.length; ++i) {
            this.ascDescInfo[i] = columnOrder != null && i < columnOrder.length ? columnOrder[i].getIsAscending() : true;
        }
        property_value = properties.getProperty(PROPERTY_NUNIQUECOLUMNS);
        if (property_value == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NUNIQUECOLUMNS);
        }
        int uniqueColumns = Integer.parseInt(property_value);
        property_value = properties.getProperty(PROPERTY_UNIQUEWITHDUPLICATENULLS);
        this.uniqueWithDuplicateNulls = property_value == null ? false : Boolean.parseBoolean(property_value);
        property_value = properties.getProperty(PROPERTY_NKEYFIELDS);
        if (property_value == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NKEYFIELDS);
        }
        int indexColumns = Integer.parseInt(property_value);
        this.unique = this.uniqueWithDuplicateNulls || uniqueColumns != indexColumns;
        this.keyColumns = indexColumns - 1;
        property_value = properties.getProperty(PROPERTY_ROWLOCCOLUMN);
        if (property_value == null) {
            SanityManager.THROWASSERT((String)"rowLocationColumnproperty not passed to index create()");
        }
        if (property_value == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        this.rowLocationColumn = Integer.parseInt(property_value);
        property_value = properties.getProperty(PROPERTY_DDINDEX);
        this.ddIndex = property_value != null ? Boolean.parseBoolean(property_value) : false;
        properties.put("GEMFIRE_TEMPLATE_ROW", template);
        long rowmemory = 0L;
        for (DataValueDescriptor dvd : template) {
            if (dvd instanceof RowLocation) continue;
            rowmemory += (long)dvd.estimateMemoryUsage();
        }
        this.estimatedRowsize = rowmemory;
        this.allocateMemory(properties, tmpFlag);
        this.tran = null;
    }

    protected abstract void allocateMemory(Properties var1, int var2) throws StandardException;

    @Override
    public boolean requiresContainer() {
        return true;
    }

    public abstract String getIndexTypeName();

    public boolean caseSensitive() {
        return true;
    }

    @Override
    public void addColumn(TransactionManager tran, int column_id, Storable template_column, int collation_id) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public void compressConglomerate(TransactionManager tran, Transaction xact) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public MemScanController defragmentConglomerate(TransactionManager tran, Transaction xact, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public void drop(TransactionManager tran) throws StandardException {
        tran.getRawStoreXact().dropContainer(this.id);
    }

    @Override
    public boolean fetchMaxOnBTree(TransactionManager tran, Transaction xact, long conglomId, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        return false;
    }

    @Override
    public final long getContainerid() {
        return this.id.getContainerId();
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final GemFireContainer getBaseContainer() {
        return this.baseContainer;
    }

    @Override
    public final GemFireContainer getGemFireContainer() {
        return this.container;
    }

    @Override
    public final void setGemFireContainer(GemFireContainer container) {
        this.container = container;
    }

    @Override
    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo() throws StandardException {
        return null;
    }

    @Override
    public final ContainerKey getId() {
        return this.id;
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController tc, long conglomId) throws StandardException {
        return this;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long load(TransactionManager tran, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        long num_rows_loaded = 0L;
        try (MemIndexController conglomerateController = this.newMemIndexController();){
            num_rows_loaded = conglomerateController.load((GemFireTransaction)tran, this, createConglom, rowSource);
        }
        return num_rows_loaded;
    }

    @Override
    public final MemConglomerateController open(TransactionManager tran, Transaction xact, boolean hold, int openMode, int lockLevel, LockingPolicy locking, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo) throws StandardException {
        MemIndexController cc = this.newMemIndexController();
        cc.init((GemFireTransaction)tran, this, openMode, lockLevel, locking);
        return cc;
    }

    @Override
    public final MemConglomerateController open(GemFireTransaction tran, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        MemIndexController cc = this.newMemIndexController();
        cc.init(tran, this, openMode, lockLevel, locking);
        return cc;
    }

    @Override
    public final boolean openContainer(GemFireTransaction tran, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        if (this.container != null) {
            return this.container.open(tran, openMode);
        }
        return false;
    }

    protected MemIndexController newMemIndexController() {
        return new MemIndexController();
    }

    @Override
    public final MemScanController openScan(TransactionManager tran, Transaction xact, boolean hold, int openMode, int lockLevel, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo) throws StandardException {
        return this.openScan(tran, xact, hold, openMode, lockLevel, locking_policy, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, staticInfo, dynamicInfo, null);
    }

    @Override
    public final MemScanController openScan(TransactionManager tran, Transaction xact, boolean hold, int openMode, int lockLevel, LockingPolicy locking, int isolationLevel, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo, Activation act) throws StandardException {
        MemIndexScanController scanController = this.newMemIndexScanController();
        scanController.init((GemFireTransaction)tran, this, openMode, lockLevel, locking, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, act);
        return scanController;
    }

    protected abstract MemIndexScanController newMemIndexScanController();

    @Override
    public final StoreCostController openStoreCost(TransactionManager tran, Transaction xact) throws StandardException {
        MemIndexCostController indexCost = this.newMemIndexCostController();
        indexCost.init((GemFireTransaction)tran, this, false, 8, 7);
        return indexCost;
    }

    protected abstract MemIndexCostController newMemIndexCostController();

    @Override
    public void purgeConglomerate(TransactionManager tran, Transaction xact) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public final LocalRegion getUnderlyingRegion() {
        return this.container.getRegion();
    }

    public final Serializable getGlobalHashIndexKey(Serializable keyValue) throws StandardException {
        assert (keyValue != null);
        if (keyValue instanceof DataValueDescriptor[]) {
            if (((DataValueDescriptor[])keyValue).length == 1) {
                return ((DataValueDescriptor[])keyValue)[0];
            }
            return new CompositeRegionKey((DataValueDescriptor[])keyValue);
        }
        return keyValue;
    }

    public final int getKeySize(Object row) throws StandardException {
        int size = 0;
        if (row instanceof CompactCompositeIndexKey) {
            return ((CompactCompositeIndexKey)row).getLength();
        }
        if (row instanceof DataValueDescriptor[]) {
            DataValueDescriptor[] dvdArr = (DataValueDescriptor[])row;
            for (int index = 0; index < dvdArr.length - 1; ++index) {
                size += dvdArr[index].getLength();
            }
        } else {
            size += ((DataValueDescriptor)row).getLength();
        }
        return size;
    }

    @Override
    public void restoreToNull() {
        this.id = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int getTypeFormatId() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int estimateMemoryUsage() {
        return 0;
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        throw new UnsupportedOperationException("Not expected to be invoked for " + this.getClass());
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        throw new UnsupportedOperationException("Not expected to be invoked for " + this.getClass());
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.id + " on base container: " + this.baseContainer + " caseSensitive = " + this.caseSensitive();
    }

    @Override
    public DataValueDescriptor getConglom() {
        return this;
    }

    @Override
    public boolean isNull() {
        return this.id == null;
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        return 0;
    }

    @Override
    public DataValueDescriptor getClone() {
        return null;
    }

    @Override
    public int getLength() throws StandardException {
        return 0;
    }

    public int getHeight() throws StandardException {
        return 1;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return null;
    }

    @Override
    public String getString() throws StandardException {
        return null;
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream ais) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
    }

    public boolean isDDIndex() {
        return this.ddIndex;
    }

    public abstract void dumpIndex(String var1);
}

