/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.IsolationLevel;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.Checkpoint;
import com.gemstone.gemfire.internal.cache.THashMapWithKeyPair;
import com.gemstone.gemfire.internal.cache.TObjectObjectObjectProcedure;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TXStateProxyFactory;
import com.gemstone.gemfire.internal.cache.VMIdAdvisor;
import com.gemstone.gemfire.internal.concurrent.AtomicUpdaterFactory;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.GlobalHashIndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexInsertOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexRefreshIndexKeyOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractDBSynchronizerMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.ExtractingIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.entry.GfxdTXEntryState;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.WrapperRowLocationForTxn;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class GfxdTXStateProxy
extends TXStateProxy {
    private static final TXStateProxyFactory factory = new TXStateProxyFactory(){

        public final TXStateProxy newTXStateProxy(TXManagerImpl txMgr, TXId txId, IsolationLevel isolationLevel, boolean isJTA, EnumSet<TransactionFlag> flags, boolean initLocalTXState) {
            return new GfxdTXStateProxy(txMgr, txId, isolationLevel, isJTA, flags, initLocalTXState);
        }
    };
    private volatile Object trans;
    private static final AtomicReferenceFieldUpdater<GfxdTXStateProxy, Object> transUpdater = AtomicUpdaterFactory.newReferenceFieldUpdater(GfxdTXStateProxy.class, Object.class, (String)"trans");
    final ArrayList<AbstractDBSynchronizerMessage> dbOps = new ArrayList(5);

    public GfxdTXStateProxy(TXManagerImpl txMgr, TXId txId, IsolationLevel isolationLevel, boolean isJTA, EnumSet<TransactionFlag> flags, boolean initLocalTXState) {
        super(txMgr, txId, isolationLevel, isJTA, flags, initLocalTXState);
    }

    public static final TXStateProxyFactory getGfxdFactory() {
        return factory;
    }

    protected Set<InternalDistributedMember> getRollbackTargets(VMIdAdvisor advisor) {
        Set<DistributedMember> stores = GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
        stores.remove(Misc.getMyId());
        return stores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addGemFireTransaction(GemFireTransaction tran) {
        Object trans;
        block12: {
            if (GemFireXDUtils.TraceTran) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("addGemFireTransaction: adding " + tran + " to " + this.toString()), (Throwable)new Exception());
            }
            while (true) {
                if (GemFireXDUtils.TraceTran | GemFireXDUtils.TraceQuery) {
                    this.lock.lock();
                    try {
                        SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("addGemFireTransaction: in loop tran = " + tran + " trans = " + this.trans));
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                if ((trans = this.trans) == tran) {
                    return;
                }
                if (trans == null) {
                    if (!transUpdater.compareAndSet(this, null, tran)) continue;
                    return;
                }
                if (!(trans instanceof GemFireTransaction)) break block12;
                TXState.ArrayListAppend trs = new TXState.ArrayListAppend(5);
                trs.append(trans);
                trs.append((Object)tran);
                if (transUpdater.compareAndSet(this, trans, trs)) break;
            }
            return;
        }
        this.lock.lock();
        try {
            ((TXState.ArrayListAppend)trans).addIfAbsent((Object)tran);
        }
        finally {
            this.lock.unlock();
        }
    }

    final void clearGemFireTransaction(GemFireTransaction tran) {
        Object trans;
        if (GemFireXDUtils.TraceTran | GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("clearGemFireTransaction: removing " + tran + " from " + this.toString()));
        }
        while ((trans = this.trans) == tran) {
            if (!transUpdater.compareAndSet(this, trans, null)) continue;
            return;
        }
        if (trans instanceof TXState.ArrayListAppend) {
            this.lock.lock();
            try {
                ((TXState.ArrayListAppend)trans).removeObj((Object)tran);
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
    }

    final void addDBSynchronizerMessage(AbstractDBSynchronizerMessage dbm) {
        this.lock.lock();
        this.dbOps.add(dbm);
        this.lock.unlock();
    }

    public void preCommit() {
        assert (this.lock.isLocked());
        super.preCommit();
        for (AbstractDBSynchronizerMessage dsm : this.dbOps) {
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("Applying DBSynchronizer op=" + dsm));
            }
            try {
                dsm.applyOperation();
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                    SystemFailure.initiateFailure((Error)err);
                    throw err;
                }
                SystemFailure.checkFailure();
                Misc.checkIfCacheClosing(t);
                SanityManager.DEBUG_PRINT((String)"warning:TraceDBSynchronizer", (String)("Exception in applying DBSynchronizer op=" + dsm), (Throwable)t);
            }
        }
        this.dbOps.clear();
    }

    public boolean hasPreCommitActions() {
        assert (this.lock.isLocked());
        return this.dbOps.size() > 0;
    }

    protected void onCommit(TXState localState, Object callbackArg) {
        this.remoteConnCleanup(false, callbackArg);
    }

    protected void onRollback(TXState localState, Object callbackArg) {
        this.remoteConnCleanup(true, callbackArg);
    }

    public final TXState.ArrayListAppend[] getTSSPendingReadLocks(Object context) {
        if (context != null) {
            return ((LanguageConnectionContext)context).getPendingReadLocks();
        }
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc != null) {
            return lcc.getPendingReadLocks();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXState.ArrayListAppend[] getTSSPendingReadLocks() {
        LanguageConnectionContext lcc;
        GemFireTransaction tran;
        block9: {
            Object trans = this.trans;
            tran = null;
            if (trans != null) {
                if (trans instanceof GemFireTransaction) {
                    tran = (GemFireTransaction)trans;
                } else {
                    this.lock.lock();
                    try {
                        trans = this.trans;
                        if (trans == null) break block9;
                        if (trans instanceof TXState.ArrayListAppend) {
                            TXState.ArrayListAppend trs = (TXState.ArrayListAppend)trans;
                            int sz = trs.size();
                            for (int index = 0; index < sz; ++index) {
                                Object tr = trs.get(index);
                                if (tr == null) continue;
                                tran = (GemFireTransaction)tr;
                                break block9;
                            }
                            break block9;
                        }
                        tran = (GemFireTransaction)trans;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }
        if ((lcc = GemFireTransaction.getLanguageConnectionContext(tran)) != null) {
            return lcc.getPendingReadLocks();
        }
        return null;
    }

    protected void cleanupEmpty(Object callbackArg) {
        this.remoteConnCleanup(false, callbackArg);
    }

    protected final void cleanupIndexEntry(TXRegionState txr, final TXEntryState tx, Operation op) {
        if (op.isUpdate()) {
            THashMapWithKeyPair indexInfoMap = txr.getTransactionalIndexInfoMap();
            if (indexInfoMap != null) {
                indexInfoMap.forEachEntry(new TObjectObjectObjectProcedure(){

                    public final boolean execute(Object k1, Object k2, Object v) {
                        if (k1 == tx) {
                            GfxdTXStateProxy.this.cleanupIndexEntryForInsert((GfxdTXEntryState)k1, (GemFireContainer)k2, v, true);
                        }
                        return true;
                    }
                });
            }
        } else if (op.isDestroy()) {
            THashMapWithKeyPair toBeReinstatedIndexInfo = txr.getToBeReinstatedIndexMap();
            if (toBeReinstatedIndexInfo != null) {
                toBeReinstatedIndexInfo.forEachEntry(new TObjectObjectObjectProcedure(){

                    public final boolean execute(Object k1, Object k2, Object v) {
                        if (k1 == tx) {
                            GfxdTXStateProxy.this.cleanupIndexEntryForDestroy(k2, v, true);
                        }
                        return true;
                    }
                });
            }
        } else {
            SanityManager.THROWASSERT((String)("unexpected op=" + op + " for cleanupIndexEntry"));
        }
    }

    final void cleanupIndexEntryForInsert(GfxdTXEntryState sqle, GemFireContainer container, Object indexValue, boolean rollback) {
        try {
            if (!sqle.isDestroyedOrRemoved()) {
                this.updateIndexAtCommitAbortNoThrow(sqle, container, indexValue, rollback);
            }
        }
        catch (Exception ex) {
            SanityManager.DEBUG_PRINT((String)"error:TraceTran", (String)("Unexpected exception during GemFireXD index cleanup for entry=" + sqle + " in index=" + container), (Throwable)ex);
        }
    }

    final void refreshIndexKeyUnaffectedIndex(GfxdTXEntryState sqle, GemFireContainer container, ExtractingIndexKey indexKey) {
        try {
            if (!sqle.isDestroyedOrRemoved()) {
                if (GemFireXDUtils.TraceIndex) {
                    GfxdIndexManager.traceIndex("GfxdTXStateProxt::refreshIndexKeyUnaffectedIndex Refreshing index key for  key=%s Old row=(%s) , for index container=(%s), old value = %s", indexKey, sqle.getUnderlyingRegionEntry(), container, sqle.getOriginalValue());
                }
                SortedMap2IndexRefreshIndexKeyOperation.doMe(null, container, indexKey, (RowLocation)sqle.getUnderlyingRegionEntry(), sqle.getOriginalValue(), false, true);
            }
        }
        catch (Exception ex) {
            SanityManager.DEBUG_PRINT((String)"error:TraceTran", (String)("Unexpected exception during GemFireXD index cleanup for entry=" + sqle + " in index=" + container), (Throwable)ex);
        }
    }

    final void cleanupIndexEntryForDestroy(Object container, Object indexValue, boolean rollback) {
        GemFireContainer indexContainer = null;
        Object indexKey = null;
        try {
            GfxdTXEntryState sqle;
            boolean deleted;
            indexContainer = (GemFireContainer)container;
            WrapperRowLocationForTxn wrapper = (WrapperRowLocationForTxn)indexValue;
            indexKey = wrapper.getIndexKey();
            if (rollback) {
                RowLocation oldRowLocation = (RowLocation)wrapper.getRegionEntry();
                deleted = SortedMap2IndexInsertOperation.replaceInSkipListMap(indexContainer, indexKey, wrapper, oldRowLocation, false, null, false);
                if (GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery) {
                    GfxdIndexManager.traceIndex("SortedMap2Index cleanup: rolled back key=%s to value=(%s) in %s", indexKey, GemFireXDUtils.TraceIndex ? oldRowLocation : ArrayUtils.objectRefString((Object)oldRowLocation), indexContainer);
                }
            } else {
                sqle = wrapper.getWrappedRowLocation();
                deleted = SortedMap2IndexDeleteOperation.doMe(null, indexContainer, indexKey, wrapper, false, sqle.getOriginalValue());
            }
            if (!deleted) {
                sqle = wrapper.getWrappedRowLocation();
                GfxdIndexManager.handleNotDeleted(false, sqle.getDataRegion(), indexContainer, wrapper, sqle.getUnderlyingRegionEntry(), indexKey, null);
            }
        }
        catch (Exception e) {
            SanityManager.DEBUG_PRINT((String)"error:TraceTran", (String)("Unexpected exception during reinstating indexes for key=" + indexKey + " in index=" + indexContainer), (Throwable)e);
        }
    }

    protected final void updateIndexes(final boolean rollback, THashMapWithKeyPair indexInfoMap, THashMapWithKeyPair toBeReinstatedIndexInfo, THashMapWithKeyPair unaffectedIndexInfo) {
        if (indexInfoMap != null) {
            indexInfoMap.forEachEntry(new TObjectObjectObjectProcedure(){

                public final boolean execute(Object k1, Object k2, Object v) {
                    GfxdTXStateProxy.this.cleanupIndexEntryForInsert((GfxdTXEntryState)k1, (GemFireContainer)k2, v, rollback);
                    return true;
                }
            });
        }
        if (unaffectedIndexInfo != null) {
            unaffectedIndexInfo.forEachEntry(new TObjectObjectObjectProcedure(){

                public final boolean execute(Object k1, Object k2, Object v) {
                    if (!rollback) {
                        GfxdTXStateProxy.this.refreshIndexKeyUnaffectedIndex((GfxdTXEntryState)k1, (GemFireContainer)k2, (ExtractingIndexKey)v);
                    }
                    return true;
                }
            });
        }
        if (toBeReinstatedIndexInfo != null) {
            toBeReinstatedIndexInfo.forEachEntry(new TObjectObjectObjectProcedure(){

                public final boolean execute(Object k1, Object k2, Object v) {
                    GfxdTXStateProxy.this.cleanupIndexEntryForDestroy(k2, v, rollback);
                    return true;
                }
            });
        }
    }

    protected final void cleanup() {
        transUpdater.set(this, null);
        if (!this.dbOps.isEmpty()) {
            this.dbOps.clear();
        }
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void remoteConnCleanup(boolean rollback, Object callbackArg) {
        block20: {
            EmbedConnection conn = null;
            GemFireTransaction tran = null;
            Object trans = this.checkTransForConnCleanup(rollback);
            try {
                if (trans != null) {
                    boolean cleanupDone = false;
                    if (trans instanceof GemFireTransaction) {
                        tran = (GemFireTransaction)trans;
                        if (conn == null) {
                            conn = this.getEmbedConnection(callbackArg, tran);
                        }
                        if (conn != null) {
                            Object object = conn.getConnectionSynchronization();
                            synchronized (object) {
                                tran.postTxCompletionOnDataStore(rollback);
                                cleanupDone = true;
                            }
                        }
                    } else {
                        Object[] transArr;
                        for (Object t : transArr = (Object[])trans) {
                            if (t == null) break;
                            tran = (GemFireTransaction)t;
                            if (conn == null) {
                                conn = this.getEmbedConnection(callbackArg, tran);
                            }
                            if (conn == null) continue;
                            Object object = conn.getConnectionSynchronization();
                            synchronized (object) {
                                tran.postTxCompletionOnDataStore(rollback);
                                cleanupDone = true;
                            }
                        }
                    }
                    if (cleanupDone) {
                        return;
                    }
                }
                if (conn == null) {
                    conn = this.getEmbedConnection(callbackArg, tran);
                }
                if (conn == null) break block20;
                Object cleanupDone = conn.getConnectionSynchronization();
                synchronized (cleanupDone) {
                    tran = (GemFireTransaction)conn.getLanguageConnection().getTransactionExecute();
                    tran.postTxCompletionOnDataStore(rollback);
                }
            }
            catch (SQLException sqle) {
                LogWriterI18n logger = Misc.getI18NLogWriter();
                if (!GemFireXDUtils.TraceTran && !logger.fineEnabled()) break block20;
                logger.fine("Unexpected exception in remote GemFireXD transaction cleanup", (Throwable)sqle);
            }
        }
    }

    private EmbedConnection getEmbedConnection(Object callbackArg, GemFireTransaction tran) throws SQLException {
        GfxdConnectionWrapper wrapper;
        Long connId;
        EmbedConnection conn;
        if (callbackArg instanceof EmbedConnection) {
            EmbedConnection conn2 = (EmbedConnection)callbackArg;
            if (GemFireXDUtils.TraceTran) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GfxdConnectionHolder: commonCleanup: using callbackArg connection: " + conn2 + ", for transaction " + (Object)((Object)this)));
            }
            return conn2;
        }
        if (tran != null && (conn = EmbedConnectionContext.getEmbedConnection(tran.getContextManager())) != null) {
            return conn;
        }
        if (GemFireXDUtils.TraceTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GfxdConnectionHolder: commonCleanup: connectionID=" + callbackArg + " for transaction " + (Object)((Object)this)));
        }
        if ((connId = (Long)callbackArg) != null && (wrapper = GfxdConnectionHolder.getHolder().getExistingWrapper(connId)) != null) {
            return wrapper.getConnectionForSynchronization(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkTransForConnCleanup(boolean rollback) {
        Object tr = this.trans;
        if (tr instanceof GemFireTransaction) {
            transUpdater.set(this, null);
            return tr;
        }
        if (tr != null) {
            int index = 0;
            Object[] trans = null;
            Object[] stran = null;
            this.lock.lock();
            try {
                TXState.ArrayListAppend trs = (TXState.ArrayListAppend)tr;
                int sz = trs.size();
                for (int i = 0; i < sz; ++i) {
                    Object[] tran = trs.get(i);
                    if (tran == null) continue;
                    if (stran == null) {
                        stran = tran;
                        continue;
                    }
                    if (trans == null) {
                        trans = new Object[sz];
                        trans[index++] = stran;
                    }
                    trans[index++] = tran;
                }
            }
            finally {
                this.lock.unlock();
            }
            transUpdater.set(this, null);
            return index > 0 ? trans : stran;
        }
        return null;
    }

    private void updateIndexAtCommitAbortNoThrow(GfxdTXEntryState sqle, GemFireContainer indexContainer, Object indexKey, boolean rollback) throws StandardException {
        block3: {
            Object valueBytesBeingReplaced = sqle.getPendingValue();
            try {
                boolean deleted = rollback ? (!indexContainer.isGlobalIndex() ? SortedMap2IndexDeleteOperation.doMe(null, indexContainer, indexKey, sqle, false, valueBytesBeingReplaced) : true) : (!indexContainer.isGlobalIndex() ? (sqle.getUnderlyingRegionEntry().isDestroyedOrRemoved() ? SortedMap2IndexDeleteOperation.doMe(null, indexContainer, indexKey, sqle, false, valueBytesBeingReplaced) : SortedMap2IndexInsertOperation.replaceInSkipListMap(indexContainer, indexKey, sqle, (RowLocation)sqle.getUnderlyingRegionEntry(), false, valueBytesBeingReplaced, false)) : (sqle.getUnderlyingRegionEntry().isDestroyedOrRemoved() ? GlobalHashIndexDeleteOperation.doMe(null, null, indexContainer, indexKey, true) : true));
                if (!deleted) {
                    GfxdIndexManager.handleNotDeleted(false, sqle.getDataRegion(), indexContainer, sqle, sqle.getUnderlyingRegionEntry(), indexKey, null);
                }
            }
            catch (StandardException e) {
                if (!GemFireXDUtils.TraceIndex) break block3;
                GfxdIndexManager.traceIndex("GfxdTXEntryState: unexpected exception when updating index=%s for key=%s", indexContainer, indexKey);
            }
        }
    }

    public Checkpoint getACheckPoint() {
        return this.regions.checkpoint(null);
    }
}

