/*

   Derby - Class org.apache.derby.impl.tools.planexporter.TreeNode

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

/*
 * Changes for GemFireXD distributed data platform (some marked by "GemStone changes")
 *
 * Portions Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

package com.pivotal.gemfirexd.tools.planexporter;

/**
 * This class is used by PlanExporter tool (DERBY-4587)
 * as a data structure to keep the values retrieved
 * after querying XPLAIN tables and few other properties
 * of a plan node in a query plan.
 */
public class TreeNode{

    private String parentId = "";//PARENT_RS_ID
    private String id = "";//RS_ID
    private String nodeType = "";//OP_IDENTIFIER
    private String noOfOpens = "";//NO_OPENS
    private String inputRows = "";//INPUT_ROWS
    private String returnedRows = "";//RETURNED_ROWS
    private String visitedPages = "";//NO_VISITED_PAGES
    private String scanQualifiers = "";//SCAN_QUALIFIERS
    private String nextQualifiers = "";//NEXT_QUALIFIERS
    private String scannedObject = "";//SCAN_OBJECT_NAME
    private String scanType = "";//SCAN_TYPE
    private String sortType = "";//SORT_TYPE
    private String sorterOutput = "";//NO_OUTPUT_ROWS
    //GemStone changes BEGIN
    private String execTime = "";//EXECUTE_TIME
    private String percentExecTime = ""; // PERCENT_EXEC_TIME
    private String nodeDetails = ""; // NODE_DETAILS
    
    //distribution related
    private String memberNode; //PRUNED_MEMBERS_LIST or TARGET_MEMBER
    //GemStone changes END
    private int depth ;
    private String rank;


    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }
    /**
     * @return the id
     */
    public String getId() {
        return id;
    }
    /**
     * @param parentId the parentId to set
     */
    public void setParent(String parentId) {
        this.parentId = parentId;
    }
    /**
     * @return the parentId
     */
    public String getParent() {
        return parentId;
    }
    /**
     * @param nodeType the nodeType to set
     */
    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }
    /**
     * @return the nodeType
     */
    public String getNodeType() {
        return nodeType;
    }
    /**
     * @param noOfOpens the noOfOpens to set
     */
    public void setNoOfOpens(String noOfOpens) {
        this.noOfOpens = noOfOpens;
    }
    /**
     * @return the noOfOpens
     */
    public String getNoOfOpens() {
        return noOfOpens;
    }
    /**
     * @param inputRows the inputRows to set
     */
    public void setInputRows(String inputRows) {
        this.inputRows = inputRows;
    }
    /**
     * @return the inputRows
     */
    public String getInputRows() {
        return inputRows;
    }
    /**
     * @param returnedRows the returnedRows to set
     */
    public void setReturnedRows(String returnedRows) {
        this.returnedRows = returnedRows;
    }
    /**
     * @return the returnedRows
     */
    public String getReturnedRows() {
        return returnedRows;
    }
    /**
     * @param visitedPages the visitedPages to set
     */
    public void setVisitedPages(String visitedPages) {
        this.visitedPages = visitedPages;
    }
    /**
     * @return the visitedPages
     */
    public String getVisitedPages() {
        return visitedPages;
    }
    /**
     * @param depth the depth to set
     */
    public void setDepth(int depth) {
        this.depth = depth;
    }
    /**
     * @return the depth
     */
    public int getDepth() {
        return depth;
    }
    /**
     * @param scanQualifiers the scanQualifiers to set
     */
    public void setScanQualifiers(String scanQualifiers) {
        this.scanQualifiers = scanQualifiers;
    }
    /**
     * @return the scanQualifiers
     */
    public String getScanQualifiers() {
        return scanQualifiers;
    }
    /**
     * @param nextQualifiers the nextQualifiers to set
     */
    public void setNextQualifiers(String nextQualifiers) {
        this.nextQualifiers = nextQualifiers;
    }
    /**
     * @return the nextQualifiers
     */
    public String getNextQualifiers() {
        return nextQualifiers;
    }
    /**
     * @param scannedObject the scannedObject to set
     */
    public void setScannedObject(String scannedObject) {
        this.scannedObject = scannedObject;
    }
    /**
     * @return the scannedObject
     */
    public String getScannedObject() {
        return scannedObject;
    }
    /**
     * @param scanType the scanType to set
     */
    public void setScanType(String scanType) {
        this.scanType = scanType;
    }
    /**
     * @return the scanType
     */
    public String getScanType() {
        return scanType;
    }
    /**
     * @param sortType the sortType to set
     */
    public void setSortType(String sortType) {
        this.sortType = sortType;
    }
    /**
     * @return the sortType
     */
    public String getSortType() {
        return sortType;
    }
    /**
     * @param sorterOutput the sorterOutput to set
     */
    public void setSorterOutput(String sorterOutput) {
        this.sorterOutput = sorterOutput;
    }
    /**
     * @return the sorterOutput
     */
    public String getSorterOutput() {
        return sorterOutput;
    }

    //GemStone changes BEGIN
    /**
     * @param executeTime the execution time to set
     */
    public void setExecTime(String executeTime) {
        this.execTime = executeTime;
    }

    /**
     * @return the execution time
     */
    public String getExecTime() {
        return execTime;
    }

    // The percentage of the total execute time for the node
    public void setPercentExecTime(String percentExecuteTime) {
      this.percentExecTime = percentExecuteTime;
    }
    
    public String getPercentExecTime() {
      return percentExecTime;
    }

    // The percentage of the total execute time for the node
    public void setNodeDetails(String nodeDetails) {
      this.nodeDetails = nodeDetails;
    }
    
    public String getNodeDetails() {
      return nodeDetails;
    }
    
    //distribution related
    public void setMemberNode(String membernode) {
      this.memberNode = membernode;
    }
    
    public String getMemberNode() {
      return this.memberNode == null ? "" : this.memberNode;
    }
    
    public void setRank(String rank) {
      this.rank = rank;
    }
    
    private String getRank() {
      return rank;
    }
    
    //GemStone changes END
    /**
     * @return XML fragment for this TreeNode object
     */
    public String toString(){
        String details = "<node ";
        details += getNodeType();
        details += getRank();
        details += getInputRows();
        details += getReturnedRows();
        details += getNoOfOpens();
        details += getVisitedPages();
        details += getScanQualifiers();
        details += getNextQualifiers();
        details += getScannedObject();
        details += getScanType();
        details += getSortType();
        details += getSorterOutput();
        //GemStone changes BEGIN
        details += getExecTime();
        details += getPercentExecTime();
        details += getMemberNode();
        details += getNodeDetails();
        //GemStone changes END
        details += " depth=\"" + getDepth() + "\"";

        return details+">\n";
    }
}
