/*

   Derby - Class com.pivotal.gemfirexd.internal.iapi.service.io.DerbyIOException

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

package com.pivotal.gemfirexd.internal.iapi.services.io;

import java.io.IOException;

/**
 * A subclass of <code>IOException</code> that carries a SQL state.
 *
 * The original reason for adding it was to separate between
 * <code>IOException</code>s generated by the application stream and the ones
 * generated by the Derby wrapper streams, see for instance
 * <code>RawToBinaryFormatStream</code>. Without this distinction, the user
 * would not be able to easily write <code>catch</code>-blocks to handle
 * specific errors happening when reading streams.
 */
public final class DerbyIOException
    extends IOException {

    /** A Derby SQLState. */
    private final String sqlState;

    /**
     * Create a new Derby IO exception.
     *
     * @param msg a string describing the error
     * @param sqlState a Derby SQLState describing the error
     */
    public DerbyIOException(String msg, String sqlState) {
        super(msg);
        this.sqlState = sqlState;
    }

    public String getSQLState() {
        return sqlState;
    }
} // End class DerbyIOException
