/*
 
 Derby - Class com.pivotal.gemfirexd.internal.iapi.jdbc.EnginePreparedStatement
 
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to you under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 */
package com.pivotal.gemfirexd.internal.iapi.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.PreparedStatement;

/**
 * Additional methods the embedded engine exposes on its 
 * PreparedStatement object implementations. An internal api only, mainly 
 * for the network server. Allows consistent interaction between embedded 
 * PreparedStatement and Brokered PreparedStatements.
 * (DERBY-1015)
 */
public interface EnginePreparedStatement extends PreparedStatement {
    
    public void setBinaryStream(int parameterIndex, InputStream x)
        throws SQLException; 
    
    public void setCharacterStream(int parameterIndex, Reader reader)
        throws SQLException;
    
    /**
     * Get the version of the prepared statement. If this has not been changed,
     * the caller may assume that a recompilation has not taken place, i.e.
     * meta-data are (also) unchanged.
     * @return version counter
     */
    public long getVersionCounter() throws SQLException;

    /**
     * Get the type of statement, one of the
     * {@link com.pivotal.gemfirexd.internal.iapi.sql.StatementType}s
     */
    public int getStatementType() throws SQLException;
}
