/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.LocatorService;
import io.snappydata.thrift.ServerType;
import io.snappydata.thrift.SnappyException;
import io.snappydata.thrift.SnappyExceptionData;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import io.snappydata.thrift.common.ThriftUtils;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorServiceImpl
implements LocatorService.Iface {
    protected final String hostAddress;
    protected final int hostPort;
    private volatile boolean isActive;
    private final CancelCriterion stopper;
    final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public LocatorServiceImpl(String address, int port) {
        this.hostAddress = address;
        this.hostPort = port;
        this.isActive = true;
        final GemFireStore store = Misc.getMemStoreBooting();
        this.stopper = new CancelCriterion(){

            public RuntimeException generateCancelledException(Throwable t) {
                RuntimeException ce = store.getAdvisee().getCancelCriterion().generateCancelledException(t);
                if (ce != null) {
                    return ce;
                }
                return new CacheClosedException(MessageService.getCompleteMessage("XJ015.M", null), t);
            }

            public String cancelInProgress() {
                String cancel = store.getAdvisee().getCancelCriterion().cancelInProgress();
                if (cancel != null) {
                    return cancel;
                }
                if (LocatorServiceImpl.this.isActive()) {
                    return null;
                }
                return MessageService.getCompleteMessage("XJ015.M", null);
            }
        };
    }

    public final HostAddress getPreferredServer(Set<ServerType> serverTypes, Set<String> serverGroups, Set<HostAddress> failedServers) throws SnappyException {
        ServerLocation prefServer;
        THashSet intersectGroups;
        int ntypes;
        if (failedServers == null) {
            failedServers = Collections.emptySet();
        }
        if (serverTypes != null && (ntypes = serverTypes.size()) > 0) {
            if (ntypes == 1) {
                intersectGroups = Collections.singleton(serverTypes.iterator().next().getServerGroupName());
            } else {
                THashSet igroups;
                intersectGroups = igroups = new THashSet(ntypes);
                for (ServerType serverType : serverTypes) {
                    intersectGroups.add(serverType.getServerGroupName());
                }
            }
        } else {
            intersectGroups = null;
        }
        if (SanityManager.TraceClientHA) {
            this.logger.info("getPreferredServer(): getting preferred server for typeGroups=" + intersectGroups + (serverGroups != null ? " serverGroups=" + serverGroups : ""));
        }
        try {
            prefServer = GemFireXDUtils.getPreferredServer(serverGroups, intersectGroups, failedServers, null, true);
        }
        catch (Throwable t) {
            throw this.SnappyException(t);
        }
        HostAddress prefHost = prefServer != null && prefServer.getPort() > 0 ? ThriftUtils.getHostAddress((String)prefServer.getHostName(), (int)prefServer.getPort()) : HostAddress.NULL_ADDRESS;
        return prefHost;
    }

    public final List<HostAddress> getAllServersWithPreferredServer(Set<ServerType> serverTypes, Set<String> serverGroups, Set<HostAddress> failedServers) throws SnappyException {
        THashSet allTypes;
        HostAddress prefServer = this.getPreferredServer(serverTypes, serverGroups, failedServers);
        ArrayList<HostAddress> prefAndAllServers = new ArrayList<HostAddress>();
        if (serverTypes == null || serverTypes.isEmpty()) {
            allTypes = null;
        } else {
            THashSet types;
            allTypes = types = new THashSet(serverTypes.size() * 2);
            allTypes.addAll(serverTypes);
            for (ServerType serverType : serverTypes) {
                ServerType locatorType;
                if (!serverType.isThriftSnappy() || serverTypes.contains(locatorType = serverType.getCorrespondingLocatorType())) continue;
                allTypes.add(locatorType);
            }
        }
        prefAndAllServers.add(prefServer);
        try {
            GemFireXDUtils.getGfxdAdvisor().getAllThriftServers((Set<ServerType>)allTypes, (Collection<HostAddress>)prefAndAllServers);
        }
        catch (Throwable t) {
            throw this.SnappyException(t);
        }
        if (SanityManager.TraceClientHA) {
            this.logger.info("getAllServersWithPreferredServer(): returning preferred server and all hosts " + prefAndAllServers);
        }
        return prefAndAllServers;
    }

    public final CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    protected SnappyException SnappyException(Throwable t) {
        SQLException sqle;
        if (t instanceof SQLException) {
            sqle = (SQLException)t;
        } else {
            if (t instanceof SnappyException) {
                return (SnappyException)t;
            }
            if (t instanceof XAException) {
                XAException xae = (XAException)t;
                sqle = new SQLException(xae.getMessage(), null, xae.errorCode);
                if (xae.getCause() != null) {
                    sqle.setNextException(TransactionResourceImpl.wrapInSQLException(xae.getCause()));
                }
            } else {
                String nodeFailure;
                if (t instanceof Error) {
                    Error err = (Error)t;
                    if (SystemFailure.isJVMFailureError((Error)err)) {
                        SystemFailure.initiateFailure((Error)err);
                        throw err;
                    }
                    SystemFailure.checkFailure();
                }
                if ((nodeFailure = this.getCancelCriterion().cancelInProgress()) != null) {
                    if (!GemFireXDUtils.nodeFailureException(t)) {
                        t = this.getCancelCriterion().generateCancelledException(t);
                    }
                } else {
                    this.logger.warn("Unexpected error in execution", t);
                }
                sqle = TransactionResourceImpl.wrapInSQLException(t);
            }
        }
        SnappyExceptionData exData = new SnappyExceptionData(sqle.getMessage(), sqle.getErrorCode()).setSqlState(sqle.getSQLState());
        if (sqle instanceof BatchUpdateException) {
            List updateCounts;
            int[] updates = ((BatchUpdateException)sqle).getUpdateCounts();
            if (updates != null && updates.length > 0) {
                updateCounts = new ArrayList(updates.length);
                for (int update : updates) {
                    updateCounts.add(update);
                }
            } else {
                updateCounts = Collections.emptyList();
            }
            exData.setUpdateCounts(updateCounts);
        }
        ArrayList<SnappyExceptionData> nextExceptions = new ArrayList<SnappyExceptionData>(4);
        SQLException next = sqle.getNextException();
        if (next != null) {
            nextExceptions = new ArrayList();
            do {
                nextExceptions.add(new SnappyExceptionData(next.getMessage(), next.getErrorCode()).setSqlState(next.getSQLState()));
            } while ((next = next.getNextException()) != null);
        }
        SnappyException se = new SnappyException(exData, this.getServerInfo());
        StringBuilder stack = t instanceof TException ? new StringBuilder("Cause: ").append(ThriftExceptionUtil.getExceptionString((Throwable)t)).append("; Server STACK: ") : new StringBuilder("Server STACK: ");
        SanityManager.getStackTrace((Throwable)t, (StringBuilder)stack);
        nextExceptions.add(new SnappyExceptionData(stack.toString(), 20000).setSqlState("X0Z35"));
        se.setNextExceptions(nextExceptions);
        return se;
    }

    public SnappyException newSnappyException(String messageId, Object ... args) {
        SnappyExceptionData exData = new SnappyExceptionData();
        exData.setSqlState(StandardException.getSQLStateFromIdentifier(messageId));
        exData.setErrorCode(StandardException.getSeverityFromIdentifier(messageId));
        exData.setReason(MessageService.getCompleteMessage(messageId, args));
        return new SnappyException(exData, this.getServerInfo());
    }

    protected String getServerInfo() {
        return "Locator=" + this.hostAddress + '[' + this.hostPort + "] Thread=" + Thread.currentThread().getName();
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public void stop() {
        this.isActive = false;
    }
}

