/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.pxf.plugins.gemfirexd;

import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.pxf.api.OneField;
import com.pivotal.pxf.api.OneRow;
import com.pivotal.pxf.api.ReadResolver;
import com.pivotal.pxf.api.UnsupportedTypeException;
import com.pivotal.pxf.api.io.DataType;
import com.pivotal.pxf.api.utilities.ColumnDescriptor;
import com.pivotal.pxf.api.utilities.InputData;
import com.pivotal.pxf.api.utilities.Plugin;
import com.pivotal.pxf.plugins.gemfirexd.GemFireXDAccessor;
import com.pivotal.pxf.plugins.gemfirexd.util.GemFireXDManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class GemFireXDResolver
extends Plugin
implements ReadResolver {
    private String regionName = "";
    private final boolean isBinaryFormat;
    private boolean processMetaData = true;
    private int[] columnIndexMapping = null;
    private final DataType[] columnTypeMapping;
    private ByteArrayDataOutput buffer = new ByteArrayDataOutput();
    private int timestampColumnIndex = -1;
    private int eventTypeColumnIndex = -1;

    public GemFireXDResolver(InputData metaData) {
        super(metaData);
        this.isBinaryFormat = !"TEXT".equalsIgnoreCase(metaData.getUserProperty("FORMAT"));
        String table = GemFireXDAccessor.tableName.get();
        if (table != null) {
            int idx = table.indexOf(".");
            this.regionName = table.substring(idx + 1);
        }
        int cols = this.inputData.getColumns();
        this.columnTypeMapping = new DataType[cols];
        for (int i = 0; i < cols; ++i) {
            this.columnTypeMapping[i] = DataType.get((int)this.inputData.getColumn(i).columnTypeCode());
        }
    }

    public final String getRegionName() {
        return this.regionName;
    }

    public List<OneField> getFields(OneRow row) throws Exception {
        try {
            return this.isBinaryFormat ? this.parseData(row) : this.parseDataText(row);
        }
        catch (Exception e) {
            GemFireXDAccessor.resetLonerRefCount(GemFireXDAccessor.tableName.get());
            throw e;
        }
    }

    private final void writeColumnsAsUTF8PXFBytes(ByteArrayDataOutput buffer, AbstractCompactExecRow compactRow, int[] positions, int obj1Index, String obj1, int obj2Index, String obj2) throws StandardException {
        RowFormatter formatter = compactRow.getRowFormatter();
        Object source = compactRow.getBaseByteSource();
        if (source != null) {
            int npos = positions.length;
            byte[] bytes = null;
            byte[][] byteArrays = null;
            OffHeapRow offHeapBytes = null;
            OffHeapRowWithLobs offHeapByteArrays = null;
            int firstBytesLen = 0;
            long firstBSAddr = 0L;
            Class<?> sclass = source.getClass();
            if (sclass == byte[].class) {
                bytes = (byte[])source;
            } else if (sclass == byte[][].class) {
                byteArrays = (byte[][])source;
            } else if (sclass == OffHeapRow.class) {
                offHeapBytes = (OffHeapRow)((Object)source);
                firstBytesLen = offHeapBytes.getLength();
                firstBSAddr = offHeapBytes.getUnsafeAddress(0, firstBytesLen);
            } else {
                offHeapByteArrays = (OffHeapRowWithLobs)((Object)source);
                firstBytesLen = offHeapByteArrays.getLength();
                firstBSAddr = offHeapByteArrays.getUnsafeAddress(0, firstBytesLen);
            }
            for (int i = 0; i < npos; ++i) {
                if (i != 0) {
                    buffer.write(44);
                }
                if (i != obj1Index) {
                    if (i != obj2Index) {
                        int index;
                        int position = positions[i];
                        if (bytes != null) {
                            formatter.writeAsUTF8BytesForPXF(position, bytes, buffer);
                            continue;
                        }
                        if (byteArrays != null) {
                            formatter.writeAsUTF8BytesForPXF(position, byteArrays, buffer);
                            continue;
                        }
                        if (offHeapBytes != null) {
                            index = position - 1;
                            formatter.writeAsUTF8BytesForPXF(index, formatter.getColumnDescriptor(index), UnsafeMemoryChunk.getUnsafeWrapper(), firstBSAddr, firstBytesLen, offHeapBytes, buffer);
                            continue;
                        }
                        index = position - 1;
                        formatter.writeAsUTF8BytesForPXF(index, formatter.getColumnDescriptor(index), UnsafeMemoryChunk.getUnsafeWrapper(), firstBSAddr, firstBytesLen, offHeapByteArrays, buffer);
                        continue;
                    }
                    buffer.writeBytes(obj2);
                    continue;
                }
                buffer.writeBytes(obj1);
            }
        }
    }

    private List<OneField> parseData(OneRow row) throws Exception {
        Row gfxdRow;
        EmbedResultSet ers;
        if (this.processMetaData) {
            this.mapColumnIndexes(row);
        }
        ResultSet rs = (ers = (gfxdRow = (Row)row.getData()).getEmbedResultSet()) != null ? ers : gfxdRow.getRowAsResultSet();
        int extColumns = this.inputData.getColumns();
        ArrayList<OneField> result = new ArrayList<OneField>(extColumns);
        int timestampColumnIndex = this.timestampColumnIndex;
        int eventTypeColumnIndex = this.eventTypeColumnIndex;
        for (int i = 0; i < extColumns; ++i) {
            if (i == timestampColumnIndex) {
                result.add(new OneField(DataType.TIMESTAMP.getOID(), (Object)new Timestamp(gfxdRow.getTimestamp())));
                continue;
            }
            if (i == eventTypeColumnIndex) {
                Event.Type op = gfxdRow.getEventType();
                result.add(new OneField(DataType.VARCHAR.getOID(), (Object)(op == null ? "" : op.toString())));
                continue;
            }
            result.add(this.parseField(rs, i));
        }
        return result;
    }

    private List<OneField> parseDataText(OneRow row) throws Exception {
        if (this.processMetaData) {
            this.mapColumnIndexes(row);
        }
        Row gfxdRow = (Row)row.getData();
        EmbedResultSet ers = gfxdRow.getEmbedResultSet();
        int extColumns = this.inputData.getColumns();
        ArrayList<OneField> result = new ArrayList<OneField>(extColumns);
        int timestampColumnIndex = this.timestampColumnIndex;
        int eventTypeColumnIndex = this.eventTypeColumnIndex;
        if (ers != null && ers.getCurrentRow() instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow compactRow = (AbstractCompactExecRow)ers.getCurrentRow();
            PersistedEventImpl event = null;
            String timestampColumn = null;
            String eventTypeColumn = null;
            if (timestampColumnIndex >= 0 && timestampColumnIndex < extColumns) {
                event = Row.getEvent(ers);
                timestampColumn = new Timestamp(event != null ? event.getTimstamp() : gfxdRow.getTimestamp()).toString();
            }
            if (eventTypeColumnIndex >= 0 && eventTypeColumnIndex < extColumns) {
                if (event == null) {
                    event = Row.getEvent(ers);
                }
                Event.Type op = event != null ? Row.getEventType(event) : gfxdRow.getEventType();
                eventTypeColumn = op != null ? op.toString() : "";
            }
            ByteArrayDataOutput buffer = this.buffer;
            this.writeColumnsAsUTF8PXFBytes(buffer, compactRow, this.columnIndexMapping, timestampColumnIndex, timestampColumn, eventTypeColumnIndex, eventTypeColumn);
            buffer.write(10);
            result.add(new OneField(DataType.BYTEA.getOID(), (Object)buffer.toByteArray()));
            buffer.clearForReuse();
            return result;
        }
        ResultSet rs = ers != null ? ers : gfxdRow.getRowAsResultSet();
        for (int i = 0; i < extColumns; ++i) {
            if (i == timestampColumnIndex) {
                result.add(new OneField(DataType.TIMESTAMP.getOID(), (Object)new Timestamp(gfxdRow.getTimestamp())));
                continue;
            }
            if (i == eventTypeColumnIndex) {
                Event.Type op = gfxdRow.getEventType();
                result.add(new OneField(DataType.VARCHAR.getOID(), (Object)(op == null ? "" : op.toString())));
                continue;
            }
            result.add(this.parseField(rs, i));
        }
        return result;
    }

    private OneField parseField(ResultSet rs, int i) throws Exception {
        DataType type = this.columnTypeMapping[i];
        switch (type) {
            case SMALLINT: {
                return new OneField(DataType.SMALLINT.getOID(), (Object)rs.getShort(this.columnIndexMapping[i]));
            }
            case INTEGER: {
                return new OneField(DataType.INTEGER.getOID(), (Object)rs.getInt(this.columnIndexMapping[i]));
            }
            case BIGINT: {
                return new OneField(DataType.BIGINT.getOID(), (Object)rs.getLong(this.columnIndexMapping[i]));
            }
            case REAL: {
                return new OneField(DataType.REAL.getOID(), (Object)Float.valueOf(rs.getFloat(this.columnIndexMapping[i])));
            }
            case FLOAT8: {
                return new OneField(DataType.FLOAT8.getOID(), (Object)rs.getDouble(this.columnIndexMapping[i]));
            }
            case VARCHAR: {
                return new OneField(DataType.VARCHAR.getOID(), (Object)rs.getString(this.columnIndexMapping[i]));
            }
            case BOOLEAN: {
                return new OneField(DataType.BOOLEAN.getOID(), (Object)rs.getBoolean(this.columnIndexMapping[i]));
            }
            case NUMERIC: {
                return new OneField(DataType.NUMERIC.getOID(), (Object)rs.getBigDecimal(this.columnIndexMapping[i]));
            }
            case TIMESTAMP: {
                return new OneField(DataType.TIMESTAMP.getOID(), (Object)rs.getTimestamp(this.columnIndexMapping[i]));
            }
            case DATE: {
                return new OneField(DataType.DATE.getOID(), (Object)rs.getDate(this.columnIndexMapping[i]));
            }
            case TIME: {
                return new OneField(DataType.TIME.getOID(), (Object)rs.getTime(this.columnIndexMapping[i]));
            }
            case CHAR: {
                return new OneField(DataType.CHAR.getOID(), (Object)rs.getString(this.columnIndexMapping[i]));
            }
            case BPCHAR: {
                return new OneField(DataType.BPCHAR.getOID(), (Object)rs.getString(this.columnIndexMapping[i]));
            }
            case BYTEA: {
                return new OneField(DataType.BYTEA.getOID(), (Object)rs.getBytes(this.columnIndexMapping[i]));
            }
            case TEXT: {
                return new OneField(DataType.TEXT.getOID(), (Object)rs.getString(this.columnIndexMapping[i]));
            }
        }
        throw new Exception("Column type " + type + " is not supported.");
    }

    private void mapColumnIndexes(OneRow row) throws Exception {
        this.processMetaData = false;
        ResultSet rs = ((Row)row.getData()).getRowAsResultSet();
        ResultSetMetaData gfxdMetadata = rs.getMetaData();
        int gfxdCols = gfxdMetadata.getColumnCount();
        int extCols = this.inputData.getColumns();
        this.columnIndexMapping = new int[extCols];
        for (int i = 0; i < extCols; ++i) {
            ColumnDescriptor extColumn = this.inputData.getColumn(i);
            String extColName = extColumn.columnName();
            if (extColName.equalsIgnoreCase("GFXD_PXF_TS")) {
                if (extColumn.columnTypeCode() != DataType.TIMESTAMP.getOID()) {
                    throw new UnsupportedTypeException("External table schema is invalid. Column " + extColName + " must be of type 'TIMESTAMP', if defined.");
                }
                this.timestampColumnIndex = i;
                continue;
            }
            if (extColName.equalsIgnoreCase("GFXD_PXF_EVENTTYPE")) {
                if (extColumn.columnTypeCode() != DataType.VARCHAR.getOID()) {
                    throw new UnsupportedTypeException("External table schema is invalid. Column " + extColName + " must be of type 'VARCHAR', if defined.");
                }
                this.eventTypeColumnIndex = i;
                continue;
            }
            for (int j = 1; j <= gfxdCols; ++j) {
                if (!extColName.equalsIgnoreCase(gfxdMetadata.getColumnName(j))) continue;
                if (!GemFireXDManager.matchColumnTypes(gfxdMetadata.getColumnType(j), extColumn.columnTypeCode())) {
                    throw new UnsupportedTypeException("External table schema is invalid. Column " + extColName + "(" + extColumn.columnTypeName() + ") does not match with the one in GemFireXD table.");
                }
                this.columnIndexMapping[i] = j;
                break;
            }
            if (this.columnIndexMapping[i] != 0) continue;
            throw new SQLException("External table schema is invalid. Column " + extColName + "(" + extColumn.columnTypeName() + ") is undefined in GemFireXD table.");
        }
    }
}

