/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.planexporter;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.services.uuid.BasicUUID;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.tools.planexporter.AbstractCreatePlan;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.ExecutionPlanMessage;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class CreateXML
extends AbstractCreatePlan {
    public static final String defaultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    static final String comment = "<!-- GemFireXD Query Plan -->\n";
    static final String rootTagStart = "<root>\n";
    static final String rootTagEnd = "</root>\n";
    static final String parentTagStart = "<plan>\n";
    static final String parentTagEnd = "</plan>\n";
    static final String childTagStart = "<details>\n";
    static final String childTagEnd = "</details>\n";

    public CreateXML(AccessDistributedSystem access, boolean isRemote, XPLAINUtil.XMLForms xmlForm, String embedXslFileName) {
        super(access, isRemote, xmlForm, embedXslFileName);
    }

    private void writeToStream(Writer out, String stmt, String time, String begin_end_exe_time, boolean isLocalPlanExtracted) throws IOException {
        if (!isLocalPlanExtracted) {
            if (this.xmlForm == XPLAINUtil.XMLForms.none) {
                this.writeXMLHeader(out, false);
            }
            out.write(parentTagStart);
        } else {
            out.write("<local>\n");
        }
        out.write(this.ds.indent(0));
        out.write(this.ds.member());
        out.write(this.ds.indent(0));
        out.write(stmt);
        out.write(this.ds.indent(0));
        out.write(time);
        out.write(this.ds.indent(0));
        out.write(begin_end_exe_time);
        out.write(this.ds.indent(0));
        out.write(this.ds.stmt_id());
        out.write(this.ds.indent(0));
        out.write(childTagStart);
        out.write(this.ds.getXmlString());
        out.write(this.ds.indent(0));
        out.write(childTagEnd);
        if (isLocalPlanExtracted) {
            out.write("</local>\n");
        }
    }

    public void writeXMLHeader(Writer out, boolean withRoot) throws IOException {
        out.write(defaultXML);
        if (this.embedXslFileName != null) {
            String embedXSL = "<?xml-stylesheet type=\"text/xsl\" href=\"" + this.embedXslFileName + "\"?>\n";
            out.write(embedXSL);
        }
        out.write(comment);
        if (withRoot) {
            out.write(rootTagStart);
        }
    }

    public static boolean testXML(StringBuilder xmlFragment) {
        Element e;
        StringBuilder xmlForm = new StringBuilder();
        xmlForm.append(defaultXML);
        String embedXSL = "<?xml-stylesheet type=\"text/xsl\" href=\"com/pivotal/gemfirexd/tools/planexporter/resources/vanilla_text.xsl\"?>\n";
        xmlForm.append("<?xml-stylesheet type=\"text/xsl\" href=\"com/pivotal/gemfirexd/tools/planexporter/resources/vanilla_text.xsl\"?>\n");
        xmlForm.append(comment);
        xmlForm.append(parentTagStart);
        xmlForm.append(childTagStart);
        xmlForm.append((CharSequence)xmlFragment);
        xmlForm.append(childTagEnd);
        xmlForm.append(parentTagEnd);
        char[] planCharArray = new char[xmlForm.length()];
        xmlForm.getChars(0, xmlForm.length(), planCharArray, 0);
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("transforming plan : " + new String(planCharArray)));
            System.out.println(new String(planCharArray));
        }
        return (e = CreateXML.transformToXML(planCharArray)) != null;
    }

    public List<char[]> getPlan() throws SQLException {
        boolean createSingleXML = this.xmlForm == XPLAINUtil.XMLForms.asXML;
        CharArrayWriter singleXML = createSingleXML ? new CharArrayWriter() : null;
        char[] planCharArray = null;
        try {
            ExecutionPlanMessage msg = this.sendMessage();
            List<char[]> listOfPlans = msg.getResults();
            if (!createSingleXML) {
                if (GemFireXDUtils.TracePlanGeneration) {
                    for (int i = 0; i < listOfPlans.size(); ++i) {
                        planCharArray = listOfPlans.get(i);
                        SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("received plan " + new String(planCharArray) + " from " + msg.getSender()));
                    }
                }
                return listOfPlans;
            }
            for (int i = 0; i < listOfPlans.size(); ++i) {
                Element e;
                planCharArray = listOfPlans.get(i);
                if (GemFireXDUtils.TracePlanAssertion && (e = CreateXML.transformToXML(planCharArray)) == null) {
                    SanityManager.DEBUG_PRINT((String)"warning:TracePlanGeneration", (String)(" ALERT!!!!, unsucessful XML transformation for '" + this.ds.getQueryID() + "' userQuery='" + this.ds.getUserQueryStr() + "'"));
                }
                if (i == 0) {
                    this.writeXMLHeader(singleXML, true);
                }
                singleXML.write(planCharArray);
            }
            if (createSingleXML) {
                Element e;
                singleXML.write(rootTagEnd);
                if (GemFireXDUtils.TracePlanGeneration && (e = CreateXML.transformToXML(singleXML.toCharArray())) == null) {
                    SanityManager.DEBUG_PRINT((String)"warning:TracePlanGeneration", (String)(" ALERT!!!!, unsucessful XML transformation for '" + this.ds.getQueryID() + "' userQuery='" + this.ds.getUserQueryStr() + "' CharXML=" + singleXML.toString()));
                }
            }
        }
        catch (SQLException ex) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("CreateXML:getPlan processing error " + ex + " for " + (planCharArray != null ? String.valueOf(planCharArray) : "NULL")), (Throwable)ex);
            }
            throw ex;
        }
        catch (Throwable t) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("CreateXML:getPlan processing error " + t + " for " + (planCharArray != null ? String.valueOf(planCharArray) : "NULL")), (Throwable)t);
            }
            throw Util.javaException(t);
        }
        ArrayList<char[]> xmlChars = new ArrayList<char[]>();
        xmlChars.add(singleXML.toCharArray());
        return xmlChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPlan(CharArrayWriter out, boolean isLocalPlanExtracted) throws SQLException, IOException {
        boolean current = this.ds.setRuntimeStatisticsMode(false);
        try {
            BasicUUID locallyExecutedId;
            if (!this.ds.verifySchemaExistance()) {
                throw GemFireXDRuntimeException.newRuntimeException("CreateXML: specified Schema does not exist", null);
            }
            if (!this.ds.initializeDataArray()) {
                if (this.ds.isRemote()) {
                    return;
                }
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("No statistics were captured in this distributed member for " + this.ds.getQueryID()));
                }
                return;
            }
            this.ds.createXMLFragment();
            this.writeToStream(out, this.ds.statement(), this.ds.time(), this.ds.begin_end_exe_time(), isLocalPlanExtracted);
            if (!isLocalPlanExtracted) {
                locallyExecutedId = new BasicUUID(this.ds.getQueryID());
                locallyExecutedId.setLocallyExecuted(1);
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Now determining locally Executed Plan if any for " + this.ds.getQueryID() + " with local stmtUUID=" + locallyExecutedId.toString()));
                }
            } else {
                return;
            }
            new CreateXML(this.ds.getClone(locallyExecutedId.toString()), true, this.xmlForm, this.embedXslFileName).processPlan(out, true);
            out.write(parentTagEnd);
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Returning  " + out.toString()));
            }
        }
        finally {
            this.ds.closeConnection();
            this.ds.setRuntimeStatisticsMode(current);
        }
    }

    public static Element transformToXML(char[] plan) {
        block6: {
            try {
                InputSource is = new InputSource(new CharArrayReader(plan));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document d = builder.parse(is);
                return d.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"error:TracePlanGeneration", (String)("CreateXML#transformToXML XML Parsing exception " + String.valueOf(plan)), (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"error:TracePlanGeneration", (String)("CreateXML#transformToXML XML Parsing exception " + String.valueOf(plan)), (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!GemFireXDUtils.TracePlanGeneration) break block6;
                SanityManager.DEBUG_PRINT((String)"error:TracePlanGeneration", (String)("CreateXML#transformToXML XML Parsing exception " + String.valueOf(plan)), (Throwable)e);
            }
        }
        return null;
    }

    public String toString() {
        return "CreateXML:isRemote=" + this.ds.isRemote();
    }
}

