/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.loader;

import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.utils.ExtractorUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class GemFireXDDataExtractorLoaderImpl
extends GemFireXDDataExtractorImpl {
    private static final String DRIVER_STRING = "io.snappydata.jdbc.ClientDriver";
    private static final String LOADER_OUTPUT_DIR = "EXTRACTED_LOADER";
    private String stringDelimiter = "\"";
    private String columnDelimiter = ",";
    private String RECOMMENDED_FILE_ARG = "recommended";
    private String HOST_ARG = "host";
    private String PORT_ARG = "port";
    private String host;
    private String port;

    public GemFireXDDataExtractorLoaderImpl() throws Exception {
        this.extractorProperties.setProperty(this.RECOMMENDED_FILE_ARG, "");
        this.extractorProperties.setProperty(this.HOST_ARG, "localhost");
        this.extractorProperties.setProperty(this.PORT_ARG, "1527");
        this.extractorProperties.setProperty("--string-delimiter", "\"");
    }

    public static void main(String[] args) throws Exception {
        GemFireXDDataExtractorLoaderImpl loader = new GemFireXDDataExtractorLoaderImpl();
        try {
            loader.processArgs(args);
            loader.consumeProperties();
            loader.configureLogger();
            loader.loadDriver(DRIVER_STRING);
            loader.playFile();
        }
        finally {
            if (logFileHandler != null) {
                logFileHandler.flush();
                logFileHandler.close();
            }
        }
    }

    @Override
    public String getSalvageDirName() {
        return LOADER_OUTPUT_DIR;
    }

    @Override
    public void consumeProperties() throws IOException {
        super.consumeProperties();
        this.host = this.extractorProperties.getProperty(this.HOST_ARG);
        this.port = this.extractorProperties.getProperty(this.PORT_ARG);
    }

    private void setupConnection() throws SQLException {
        Properties properties = this.createConnectionProperties(false);
        properties.put("skip-constraint-checks", "true");
        super.getConnection("jdbc:gemfirexd://" + this.host + ":" + this.port, properties);
    }

    void playFile() throws FileNotFoundException, IOException, SQLException {
        String fileName = this.extractorProperties.getProperty(this.RECOMMENDED_FILE_ARG);
        if (fileName.equals("")) {
            GemFireXDDataExtractorLoaderImpl.logSevere("Please provide the recommended file from the salvager tool");
            return;
        }
        this.playFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playFile(File file) throws FileNotFoundException, IOException, SQLException {
        if (!file.exists()) {
            GemFireXDDataExtractorLoaderImpl.logSevere("The specified Recommended.txt file: " + file.getAbsolutePath() + " does not exist");
            return;
        }
        this.setupConnection();
        this.stringDelimiter = this.extractorProperties.getProperty("--string-delimiter");
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            if (line != null) {
                try {
                    GemFireXDDataExtractorLoaderImpl.logInfo("Loading .sql file: " + line);
                    this.loadDDL(line);
                }
                catch (Exception e) {
                    GemFireXDDataExtractorLoaderImpl.logSevere("Unable to load sql file: " + line, e);
                }
            } else {
                GemFireXDDataExtractorLoaderImpl.logSevere("No ddl or possibly empty Recommended.txt located at: " + file.getAbsolutePath());
                return;
            }
            line = reader.readLine();
            while (line != null) {
                try {
                    this.loadCSV(line);
                }
                catch (Exception e) {
                    GemFireXDDataExtractorLoaderImpl.logSevere("Unable to load csv file: " + line, e);
                }
                line = reader.readLine();
            }
        }
    }

    private void loadDDL(String ddlFileName) throws IOException, SQLException {
        List<String> ddlStatements = ExtractorUtils.readSqlStatements(ddlFileName);
        ExtractorUtils.executeDdlFromSqlFile(this.jdbcConn, ddlStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void loadCSV(String csvFileName) throws SQLException {
        try (Statement statement = null;){
            String[] path = csvFileName.split(Pattern.quote("" + File.separatorChar));
            String shortName = path[path.length - 1];
            String[] splitShortName = shortName.split("-");
            String schema = splitShortName[1];
            String tableName = splitShortName[2];
            String callString = "CALL SYSCS_UTIL.IMPORT_TABLE_EX ('" + schema + "', '" + tableName + "', '" + csvFileName + "' , '" + this.columnDelimiter + "', '" + this.stringDelimiter + "', null, 0, 0, 6, 0, null, null)";
            GemFireXDDataExtractorLoaderImpl.logInfo("Executing :" + callString);
            statement = this.jdbcConn.prepareStatement(callString);
            statement.execute();
        }
    }

    @Override
    public void processArgs(String[] args) throws Exception {
        for (String arg : args) {
            if (arg.equals("--help")) {
                this.extractorProperties.setProperty("--help", Boolean.toString(Boolean.TRUE));
                continue;
            }
            String[] tokens = arg.split("=");
            if (tokens.length < 2) {
                throw new Exception("Invalid argument : " + arg);
            }
            String key = tokens[0].trim();
            String value = tokens[1].trim();
            if (this.extractorProperties.containsKey(key)) {
                this.extractorProperties.setProperty(key, value);
                continue;
            }
            throw new Exception("Invalid option : " + key);
        }
    }
}

