/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter;
import com.pivotal.gemfirexd.internal.iapi.services.info.JVMInfo;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.xa.XAXactId;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.jdbc.EmbedPooledConnection;
import com.pivotal.gemfirexd.internal.jdbc.XATransactionState;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class EmbedXAResource
implements XAResource {
    private EmbedPooledConnection con;
    private ResourceAdapter ra;
    private XAXactId currentXid;
    private int timeoutSeconds;

    EmbedXAResource(EmbedPooledConnection con, ResourceAdapter ra) {
        this.con = con;
        this.ra = ra;
        this.timeoutSeconds = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        this.checkXAActive();
        XAXactId xid_im = new XAXactId(xid);
        XATransactionState tranState = this.getTransactionState(xid_im);
        if (tranState == null) {
            throw new XAException(-4);
        }
        XATransactionState xATransactionState = tranState;
        synchronized (xATransactionState) {
            this.checkUserCredentials(tranState.creatingResource);
            switch (tranState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(tranState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (tranState.suspendedList != null && tranState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (tranState.isPrepared == onePhase) {
                throw new XAException(-6);
            }
            try {
                tranState.xa_commit(onePhase);
            }
            catch (SQLException sqle) {
                throw EmbedXAResource.wrapInXAException(sqle);
            }
            finally {
                this.returnConnectionToResource(tranState, xid_im);
            }
        }
    }

    @Override
    public final synchronized void end(Xid xid, int flags) throws XAException {
        XATransactionState tranState;
        this.checkXAActive();
        try {
            if (this.con.currentConnectionHandle != null) {
                this.con.currentConnectionHandle.getIsolationUptoDate();
            }
        }
        catch (SQLException sqle) {
            throw EmbedXAResource.wrapInXAException(sqle);
        }
        XAXactId xid_im = new XAXactId(xid);
        boolean endingCurrentXid = false;
        if (this.currentXid != null) {
            if (!this.currentXid.equals(xid_im)) {
                throw new XAException(-6);
            }
            endingCurrentXid = true;
        }
        if ((tranState = this.getTransactionState(xid_im)) == null) {
            throw new XAException(-4);
        }
        boolean rollbackOnly = tranState.end(this, flags, endingCurrentXid);
        if (endingCurrentXid) {
            this.currentXid = null;
            this.con.realConnection = null;
        }
        if (rollbackOnly) {
            throw new XAException(tranState.rollbackOnlyCode);
        }
    }

    @Override
    public final synchronized int prepare(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xid_im = new XAXactId(xid);
        XATransactionState tranState = this.getTransactionState(xid_im);
        if (tranState == null) {
            throw new XAException(-4);
        }
        XATransactionState xATransactionState = tranState;
        synchronized (xATransactionState) {
            this.checkUserCredentials(tranState.creatingResource);
            switch (tranState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(tranState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (tranState.suspendedList != null && tranState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (tranState.isPrepared) {
                throw new XAException(-6);
            }
            try {
                int ret = tranState.xa_prepare();
                if (ret == 2) {
                    tranState.isPrepared = true;
                    return 0;
                }
                this.returnConnectionToResource(tranState, xid_im);
                return 3;
            }
            catch (SQLException sqle) {
                throw EmbedXAResource.wrapInXAException(sqle);
            }
        }
    }

    @Override
    public synchronized int getTransactionTimeout() {
        return this.timeoutSeconds;
    }

    @Override
    public final synchronized boolean isSameRM(XAResource xares) throws XAException {
        this.checkXAActive();
        if (xares instanceof EmbedXAResource) {
            return this.ra == ((EmbedXAResource)xares).ra;
        }
        return false;
    }

    @Override
    public final synchronized Xid[] recover(int flag) throws XAException {
        this.checkXAActive();
        try {
            return this.ra.recover(flag);
        }
        catch (StandardException se) {
            throw EmbedXAResource.wrapInXAException(se);
        }
    }

    @Override
    public final synchronized void forget(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xid_im = new XAXactId(xid);
        XATransactionState tranState = this.getTransactionState(xid_im);
        if (tranState == null) {
            throw new XAException(-4);
        }
        throw new XAException(tranState.isPrepared ? -4 : -6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void rollback(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xid_im = new XAXactId(xid);
        XATransactionState tranState = this.getTransactionState(xid_im);
        if (tranState == null) {
            throw new XAException(-4);
        }
        XATransactionState xATransactionState = tranState;
        synchronized (xATransactionState) {
            switch (tranState.associationState) {
                case -1: 
                case 0: {
                    break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (tranState.suspendedList != null && tranState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            this.checkUserCredentials(tranState.creatingResource);
            try {
                tranState.xa_rollback();
            }
            catch (SQLException sqle) {
                throw EmbedXAResource.wrapInXAException(sqle);
            }
            finally {
                this.returnConnectionToResource(tranState, xid_im);
            }
        }
    }

    @Override
    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.timeoutSeconds = seconds;
        return true;
    }

    private long getDefaultXATransactionTimeout() throws XAException {
        try {
            LanguageConnectionContext lcc = this.con.getLanguageConnection();
            TransactionController tc = lcc.getTransactionExecute();
            long timeoutMillis = 1000L * (long)PropertyUtil.getServiceInt(tc, "gemfirexd.jdbc.xaTransactionTimeout", 0, Integer.MAX_VALUE, 0);
            return timeoutMillis;
        }
        catch (SQLException sqle) {
            throw EmbedXAResource.wrapInXAException(sqle);
        }
        catch (StandardException se) {
            throw EmbedXAResource.wrapInXAException(se);
        }
    }

    @Override
    public final synchronized void start(Xid xid, int flags) throws XAException {
        this.checkXAActive();
        if (this.currentXid != null) {
            throw new XAException(-6);
        }
        XAXactId xid_im = new XAXactId(xid);
        XATransactionState tranState = this.getTransactionState(xid_im);
        switch (flags) {
            case 0: {
                long timeoutMillis;
                if (tranState != null) {
                    throw new XAException(-8);
                }
                try {
                    if (this.con.realConnection == null) {
                        this.con.openRealConnection();
                        if (this.con.currentConnectionHandle != null) {
                            this.con.currentConnectionHandle.setState(true);
                            this.con.realConnection.setApplicationConnection(this.con.currentConnectionHandle);
                        }
                    } else {
                        if (this.con.currentConnectionHandle != null && this.con.currentConnectionHandle.getAutoCommit()) {
                            this.con.currentConnectionHandle.rollback();
                        }
                        if (!this.con.realConnection.transactionIsIdle()) {
                            throw new XAException(-9);
                        }
                        if (this.con.currentConnectionHandle != null) {
                            this.con.currentConnectionHandle.getIsolationUptoDate();
                            this.con.currentConnectionHandle.setState(true);
                            this.con.realConnection.rollback();
                        } else {
                            this.con.resetRealConnection();
                        }
                    }
                    this.con.realConnection.setAutoCommit(false);
                    this.con.realConnection.setHoldability(2);
                    this.con.realConnection.getLanguageConnection().getTransactionExecute().createXATransactionFromLocalTransaction(xid_im.getFormatId(), xid_im.getGlobalTransactionId(), xid_im.getBranchQualifier());
                }
                catch (StandardException se) {
                    throw EmbedXAResource.wrapInXAException(se);
                }
                catch (SQLException sqle) {
                    throw EmbedXAResource.wrapInXAException(sqle);
                }
                tranState = new XATransactionState(this.con.realConnection.getContextManager(), this.con.realConnection, this, xid_im);
                if (!this.ra.addConnection(xid_im, tranState)) {
                    throw new XAException(-8);
                }
                this.currentXid = xid_im;
                if (this.timeoutSeconds == Integer.MAX_VALUE || (timeoutMillis = this.timeoutSeconds > 0 ? (long)(1000 * this.timeoutSeconds) : this.getDefaultXATransactionTimeout()) <= 0L) break;
                tranState.scheduleTimeoutTask(timeoutMillis);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                if (tranState == null) {
                    throw new XAException(-4);
                }
                tranState.start(this, flags);
                if (tranState.conn == this.con.realConnection) break;
                if (this.con.realConnection != null) {
                    if (!this.con.realConnection.transactionIsIdle()) {
                        throw new XAException(-9);
                    }
                    try {
                        if (this.con.currentConnectionHandle != null) {
                            this.con.currentConnectionHandle.getIsolationUptoDate();
                        }
                    }
                    catch (SQLException sqle) {
                        throw EmbedXAResource.wrapInXAException(sqle);
                    }
                    EmbedXAResource.closeUnusedConnection(this.con.realConnection);
                }
                this.con.realConnection = tranState.conn;
                if (this.con.currentConnectionHandle == null) break;
                try {
                    this.con.currentConnectionHandle.setState(false);
                    this.con.realConnection.setApplicationConnection(this.con.currentConnectionHandle);
                    break;
                }
                catch (SQLException sqle) {
                    throw EmbedXAResource.wrapInXAException(sqle);
                }
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.currentXid = xid_im;
    }

    Xid getCurrentXid() {
        return this.currentXid;
    }

    private XATransactionState getTransactionState(XAXactId xid_im) {
        return (XATransactionState)this.ra.findConnection(xid_im);
    }

    private void checkUserCredentials(EmbedXAResource original) throws XAException {
        if (original == this) {
            return;
        }
        if (original.con.getPassword().equals(this.con.getPassword()) && original.con.getUsername().equals(this.con.getUsername())) {
            return;
        }
        throw new XAException(103);
    }

    private void checkXAActive() throws XAException {
        try {
            this.con.checkActive();
        }
        catch (SQLException sqle) {
            throw EmbedXAResource.wrapInXAException(sqle);
        }
    }

    private static XAException wrapInXAException(SQLException se) {
        String sqlstate = se.getSQLState();
        String message = se.getMessage();
        XAException xae = sqlstate == null ? (message != null ? new XAException(message) : new XAException(-3)) : (sqlstate.equals(StandardException.getSQLStateFromIdentifier("XSAX1.S")) ? new XAException(-8) : (sqlstate.equals(StandardException.getSQLStateFromIdentifier("XSAX0.S")) ? new XAException(105) : (sqlstate.equals("40001") ? new XAException(102) : (sqlstate.equals("40XL1") ? new XAException(106) : (message != null ? new XAException(message) : new XAException(-3))))));
        if (JVMInfo.JDK_ID >= 4) {
            xae.initCause(se);
        }
        return xae;
    }

    private static XAException wrapInXAException(StandardException se) {
        return EmbedXAResource.wrapInXAException(TransactionResourceImpl.wrapInSQLException(se));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnConnectionToResource(XATransactionState tranState, XAXactId xid_im) {
        this.removeXATransaction(xid_im);
        XATransactionState xATransactionState = tranState;
        synchronized (xATransactionState) {
            tranState.associationState = 3;
            tranState.notifyAll();
            EmbedConnection conn = tranState.conn;
            if (tranState.creatingResource.con.realConnection == conn || tranState.creatingResource.con.realConnection == null) {
                tranState.creatingResource.con.realConnection = conn;
                BrokeredConnection handle = tranState.creatingResource.con.currentConnectionHandle;
                conn.setApplicationConnection(handle);
                if (handle != null) {
                    try {
                        handle.setState(true);
                    }
                    catch (SQLException sqle) {
                        EmbedXAResource.closeUnusedConnection(tranState.conn);
                        tranState.creatingResource.con.realConnection = null;
                    }
                }
                return;
            }
        }
        EmbedXAResource.closeUnusedConnection(tranState.conn);
    }

    private static void closeUnusedConnection(EmbedConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void removeXATransaction(XAXactId xid_im) {
        XATransactionState tranState = (XATransactionState)this.ra.removeConnection(xid_im);
        if (tranState != null) {
            tranState.popMe();
        }
    }

    void setCurrentXid(XAXactId aCurrentXid) {
        this.currentXid = aCurrentXid;
    }
}

