/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Undoable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoveFileOperation
implements Undoable {
    private String name;
    private long generationId;
    private boolean removeAtOnce;
    private transient StorageFile fileToGo;

    public RemoveFileOperation() {
    }

    RemoveFileOperation(String name, long generationId, boolean removeAtOnce) {
        this.name = name;
        this.generationId = generationId;
        this.removeAtOnce = removeAtOnce;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.generationId);
        out.writeBoolean(this.removeAtOnce);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.generationId = in.readLong();
        this.removeAtOnce = in.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 291;
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void releaseResource(Transaction tran) {
    }

    @Override
    public int group() {
        return 1280;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException {
        if (this.fileToGo == null) {
            return;
        }
        BaseDataFileFactory bdff = (BaseDataFileFactory)((RawTransaction)xact).getDataFactory();
        bdff.fileToRemove(this.fileToGo, true);
    }

    @Override
    public boolean needsRedo(Transaction xact) throws StandardException {
        if (!this.removeAtOnce) {
            return false;
        }
        FileResource fr = ((RawTransaction)xact).getDataFactory().getFileHandler();
        this.fileToGo = fr.getAsFile(this.name, this.generationId);
        if (this.fileToGo == null) {
            return false;
        }
        return this.fileToGo.exists();
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.fileToGo != null) {
            BaseDataFileFactory bdff = (BaseDataFileFactory)((RawTransaction)xact).getDataFactory();
            bdff.fileToRemove(this.fileToGo, false);
        }
        return null;
    }
}

