/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ContainerOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ReclaimSpace;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.StoredPage;

public class ReclaimSpaceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reclaimSpace(BaseDataFileFactory dataFactory, RawTransaction tran, ReclaimSpace work) throws StandardException {
        if (work.reclaimWhat() == 1) {
            return ReclaimSpaceHelper.reclaimContainer(dataFactory, tran, work);
        }
        LockingPolicy container_rlock = tran.newLockingPolicy(1, 5, true);
        SanityManager.ASSERT((container_rlock != null ? 1 : 0) != 0);
        ContainerHandle containerHdl = ReclaimSpaceHelper.openContainerNW(tran, container_rlock, work.getContainerId());
        if (containerHdl == null) {
            tran.abort();
            if (SanityManager.DEBUG_ON((String)DaemonService.DaemonTrace)) {
                SanityManager.DEBUG((String)DaemonService.DaemonTrace, (String)(" aborted " + work + " because container is locked or dropped"));
            }
            if (work.incrAttempts() < 3) {
                return 2;
            }
            return 1;
        }
        if (work.reclaimWhat() == 2) {
            Page p = containerHdl.getPageNoWait(work.getPageId().getPageNumber());
            if (p != null) {
                containerHdl.removePage(p);
            }
            tran.commit();
            return 1;
        }
        RecordHandle headRecord = work.getHeadRowHandle();
        if (!container_rlock.lockRecordForWrite(tran, headRecord, false, false)) {
            tran.abort();
            if (work.incrAttempts() < 3) {
                return 2;
            }
            return 1;
        }
        if (work.reclaimWhat() == 3) {
            containerHdl.compactRecord(headRecord);
            tran.commitNoSync(1);
            return 1;
        }
        SanityManager.ASSERT((work.reclaimWhat() == 4 ? 1 : 0) != 0);
        long headPageId = ((PageKey)headRecord.getPageId()).getPageNumber();
        StoredPage headRowPage = (StoredPage)containerHdl.getPageNoWait(headPageId);
        if (headRowPage == null) {
            tran.abort();
            if (work.incrAttempts() < 3) {
                return 2;
            }
            return 1;
        }
        try {
            headRowPage.removeOrphanedColumnChain(work, containerHdl);
        }
        finally {
            headRowPage.unlatch();
        }
        tran.commitNoSync(1);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reclaimContainer(BaseDataFileFactory dataFactory, RawTransaction tran, ReclaimSpace work) throws StandardException {
        LockingPolicy container_xlock = tran.newLockingPolicy(2, 5, true);
        SanityManager.ASSERT((container_xlock != null ? 1 : 0) != 0);
        RawContainerHandle containerHdl = tran.openDroppedContainer(work.getContainerId(), container_xlock);
        if (containerHdl == null || containerHdl.getContainerStatus() == 1 || containerHdl.getContainerStatus() == 4) {
            if (containerHdl != null) {
                containerHdl.close();
            }
            tran.abort();
            if (SanityManager.DEBUG_ON((String)DaemonService.DaemonTrace)) {
                SanityManager.DEBUG((String)DaemonService.DaemonTrace, (String)("  aborted " + work));
            }
        } else {
            ContainerOperation lop = new ContainerOperation(containerHdl, 4);
            containerHdl.preDirty(true);
            try {
                tran.logAndDo(lop);
            }
            finally {
                containerHdl.preDirty(false);
            }
            containerHdl.close();
            tran.commit();
            if (SanityManager.DEBUG_ON((String)DaemonService.DaemonTrace)) {
                SanityManager.DEBUG((String)DaemonService.DaemonTrace, (String)("  committed " + work));
            }
        }
        return 1;
    }

    private static ContainerHandle openContainerNW(Transaction tran, LockingPolicy rlock, ContainerKey containerId) throws StandardException {
        ContainerHandle containerHdl = tran.openContainer(containerId, rlock, 132);
        return containerHdl;
    }
}

