/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseContainerHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BufferedByteHolderInputStream;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ByteHolder;
import java.io.IOException;

public class OverflowInputStream
extends BufferedByteHolderInputStream
implements Resetable {
    protected BaseContainerHandle owner;
    protected long overflowPage;
    protected int overflowId;
    protected long firstOverflowPage;
    protected int firstOverflowId;
    protected RecordHandle recordToLock;
    private boolean initialized = false;

    public OverflowInputStream(ByteHolder bh, BaseContainerHandle owner, long overflowPage, int overflowId, RecordHandle recordToLock) throws IOException, StandardException {
        super(bh);
        this.owner = owner;
        this.overflowPage = overflowPage;
        this.overflowId = overflowId;
        this.firstOverflowPage = overflowPage;
        this.firstOverflowId = overflowId;
        this.recordToLock = recordToLock;
        this.fillByteHolder();
    }

    @Override
    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0 && this.overflowPage != -1L) {
            this.bh.clear();
            try {
                BasePage columnOverflowPage = (BasePage)this.owner.getPage(this.overflowPage);
                if (columnOverflowPage != null) {
                    columnOverflowPage.restorePortionLongColumn(this);
                    columnOverflowPage.unlatch();
                    columnOverflowPage = null;
                }
            }
            catch (StandardException se) {
                throw new IOException(se.toString());
            }
            this.bh.startReading();
        }
    }

    public long getOverflowPage() {
        return this.overflowPage;
    }

    public int getOverflowId() {
        return this.overflowId;
    }

    public void setOverflowPage(long overflowPage) {
        this.overflowPage = overflowPage;
    }

    public void setOverflowId(int overflowId) {
        this.overflowId = overflowId;
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        this.owner.checkOpen();
        this.overflowPage = this.firstOverflowPage;
        this.overflowId = this.firstOverflowId;
        this.bh.clear();
        this.bh.startReading();
        this.fillByteHolder();
    }

    @Override
    public void initStream() throws StandardException {
        if (this.initialized) {
            return;
        }
        if (this.owner.getTransaction() == null) {
            throw StandardException.newException("40XD0", (Object)GemFireStore.getMyId(), (Object)"");
        }
        LockingPolicy lp = this.owner.getTransaction().newLockingPolicy(1, 2, true);
        this.owner = (BaseContainerHandle)this.owner.getTransaction().openContainer(this.owner.getId(), lp, this.owner.getMode());
        this.owner.getLockingPolicy().lockRecordForRead(this.owner.getTransaction(), this.owner, this.recordToLock, true, false);
        this.initialized = true;
    }

    @Override
    public void closeStream() {
        this.owner.close();
        this.initialized = false;
    }
}

