/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLPreprocess;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GfxdRemoteJarUtil;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.io.StorageRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;

public final class GfxdJarMessage
extends AbstractGfxdReplayableMessage
implements StorageFile,
GfxdDDLPreprocess {
    private static final long serialVersionUID = 8648222850391801895L;
    public static final int JAR_INSTALL = 1;
    public static final int JAR_REMOVE = 2;
    public static final int JAR_REPLACE = 4;
    private long id;
    private long oldId;
    private int type;
    private byte[] jar_bytes;
    private volatile boolean sendBytes = true;
    private String schemaName;
    private String sqlName;
    private String fullName;
    static final String REGION_FOR_CONFLATION = "__GFXD_INTERNAL_JAR";

    public GfxdJarMessage() {
    }

    public GfxdJarMessage(String alias, int type, byte[] bytes, LanguageConnectionContext lcc) throws StandardException {
        this.type = type;
        this.jar_bytes = bytes;
        String[] ret = GfxdJarMessage.getSchemaName(alias, lcc);
        this.schemaName = ret[0];
        this.sqlName = ret[1];
        this.fullName = this.schemaName + '.' + this.sqlName;
    }

    public void setOldId(long oldId) {
        this.oldId = oldId;
    }

    public void setCurrId(long currId) {
        this.id = currId;
    }

    public final long getId() {
        return this.id;
    }

    @Override
    public final void appendFields(StringBuilder sb) {
        sb.append(", ID=").append(this.getId()).append(", oldID=").append(this.oldId).append(", type=").append(this.type).append(", name=").append(this.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws StandardException {
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            conn = GemFireXDUtils.getTSSConnection(true, true, false);
            conn.getTR().setupContextStack();
            contextSet = true;
            LanguageConnectionContext lcc = conn.getLanguageConnection();
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("this.schemaName: " + this.schemaName + " schema name from alias is " + this.schemaName));
            }
            switch (this.type) {
                case 1: {
                    try {
                        GfxdRemoteJarUtil.install(lcc, this.schemaName, this.sqlName, this.getId());
                        return;
                    }
                    catch (StandardException se) {
                        if (this.oldId == 0L || !"X0Y32.S".equals(se.getMessageId())) throw se;
                        GfxdRemoteJarUtil.replace(lcc, this.schemaName, this.sqlName, this.getId(), this.oldId);
                        return;
                    }
                }
                case 2: {
                    GfxdRemoteJarUtil.drop(lcc, this.schemaName, this.sqlName, this.getId());
                    return;
                }
                case 4: {
                    try {
                        GfxdRemoteJarUtil.replace(lcc, this.schemaName, this.sqlName, this.getId(), this.oldId);
                        return;
                    }
                    catch (StandardException se) {
                        if (!"X0X13.S".equals(se.getMessageId())) throw se;
                        GfxdRemoteJarUtil.install(lcc, this.schemaName, this.sqlName, this.getId());
                        return;
                    }
                }
                default: {
                    throw new IllegalStateException("GfxdJarMessage#exception: could not handle type " + this.type);
                }
            }
        }
        catch (Exception ex) {
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)"GfxdJarMessage#execute: exception encountered", (Throwable)ex);
            }
            if (!GemFireXDUtils.retryToBeDone(ex)) throw new FunctionExecutionException(ex);
            throw new InternalFunctionInvocationTargetException((Throwable)ex);
        }
        finally {
            if (contextSet) {
                block21: {
                    try {
                        conn.internalCommit();
                    }
                    catch (SQLException ex) {
                        if (!GemFireXDUtils.TraceApplicationJars) break block21;
                        SanityManager.DEBUG_PRINT((String)"TraceJars", (String)"GfxdJarMessage#execute: exception encountered in commit", (Throwable)ex);
                    }
                }
                conn.getTR().restoreContextStack();
            }
        }
    }

    public static String[] getSchemaName(String alias, LanguageConnectionContext lcc) throws StandardException {
        String sqlName;
        String schemaName;
        String[] st = IdUtil.parseMultiPartSQLIdentifier(alias);
        if (st.length == 1) {
            schemaName = lcc.getCurrentSchemaName();
            sqlName = st[0];
            st = new String[2];
        } else {
            schemaName = st[0];
            sqlName = st[1];
        }
        SystemProcedures.checkJarSQLName(sqlName);
        st[0] = schemaName;
        st[1] = sqlName;
        return st;
    }

    public boolean shouldBeConflated() {
        return this.type == 2;
    }

    @Override
    public boolean shouldBeMerged() {
        return this.type == 4 || this.type == 1;
    }

    @Override
    public boolean merge(Conflatable existing) {
        if (existing instanceof GfxdJarMessage && ((GfxdJarMessage)existing).type != 2) {
            this.type = 1;
            return true;
        }
        return false;
    }

    public String getRegionToConflate() {
        return this.schemaName + '.' + REGION_FOR_CONFLATION;
    }

    public Object getKeyToConflate() {
        return this.sqlName;
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public boolean preprocess() {
        return true;
    }

    @Override
    public String getSQLStatement() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 1: {
                return sb.append("CALL SQLJ.INSTALL_JAR_BYTES(x'").append(ClientSharedUtils.toHexString((byte[])this.jar_bytes, (int)0, (int)this.jar_bytes.length)).append("','").append(this.getName()).append("')").toString();
            }
            case 4: {
                return sb.append("CALL SQLJ.REPLACE_JAR_BYTES(x'").append(ClientSharedUtils.toHexString((byte[])this.jar_bytes, (int)0, (int)this.jar_bytes.length)).append("','").append(this.getName()).append("')").toString();
            }
            case 2: {
                return sb.append("CALL SQLJ.REMOVE_JAR('").append(this.getName()).append("', 0)").toString();
            }
        }
        throw new IllegalStateException("GfxdJarMessage#getSQLStatement: could not handle type " + this.type);
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public byte getGfxdID() {
        return 39;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarMessage#toData: this.sendBytes " + this.sendBytes + " and jar bytes " + Arrays.toString(this.jar_bytes)));
        }
        out.writeLong(this.id);
        DataSerializer.writeString((String)this.schemaName, (DataOutput)out);
        DataSerializer.writeString((String)this.sqlName, (DataOutput)out);
        DataSerializer.writeByte((Byte)((byte)this.type), (DataOutput)out);
        if (this.type != 2) {
            if (this.sendBytes) {
                if (GemFireXDUtils.TraceApplicationJars) {
                    SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarMessage#toData: writing byte array " + Arrays.toString(this.jar_bytes)));
                }
                DataSerializer.writeByteArray((byte[])this.jar_bytes, (DataOutput)out);
            } else {
                if (GemFireXDUtils.TraceApplicationJars) {
                    SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdJarMessage#toData: sending null jar bytes " + Arrays.toString(this.jar_bytes)));
                }
                DataSerializer.writeByteArray(null, (DataOutput)out);
            }
            DataSerializer.writeLong((Long)this.oldId, (DataOutput)out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int dotIndex;
        boolean isVer11;
        super.fromData(in);
        this.id = in.readLong();
        this.schemaName = DataSerializer.readString((DataInput)in);
        this.sqlName = DataSerializer.readString((DataInput)in);
        Version v = InternalDataSerializer.getVersionForDataStream((DataInput)in);
        boolean bl = isVer11 = Version.SQLF_1099.compareTo(v) <= 0;
        if (isVer11 || (dotIndex = this.sqlName.indexOf(46)) < 0) {
            this.fullName = this.schemaName + '.' + this.sqlName;
        } else {
            this.fullName = this.sqlName;
            this.sqlName = this.sqlName.substring(dotIndex + 1);
        }
        this.type = DataSerializer.readByte((DataInput)in).byteValue();
        if (this.type != 2) {
            this.jar_bytes = DataSerializer.readByteArray((DataInput)in);
            if (isVer11 || this.type == 4) {
                this.oldId = DataSerializer.readLong((DataInput)in);
            }
        } else {
            this.jar_bytes = null;
        }
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean deleteAll() {
        return false;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return null;
    }

    @Override
    public final String getName() {
        return this.fullName;
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return null;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return false;
    }

    @Override
    public boolean renameTo(StorageFile newName) {
        return false;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean mkdirs() {
        return false;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public StorageFile getParentDir() {
        return null;
    }

    @Override
    public boolean setReadOnly() {
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return null;
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.jar_bytes);
        return bis;
    }

    @Override
    public int getExclusiveFileLock() {
        return 0;
    }

    @Override
    public void releaseExclusiveFileLock() {
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        return null;
    }

    public void sendByteArray(boolean b) {
        this.sendBytes = b;
    }
}

