/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticUtil;
import com.pivotal.gemfirexd.internal.iapi.services.diag.Diagnosticable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;

public class D_DiagnosticUtil {
    private static Object getModuleFromDbName(String db_name) throws StandardException {
        Object store_module = null;
        Object db = Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", db_name);
        store_module = db == null ? Monitor.findService("com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory", db_name) : Monitor.findServiceModule(db, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        return store_module;
    }

    public static String diag_conglomid_print(String db_name, long conglomid) throws StandardException {
        try {
            System.out.println(D_DiagnosticUtil.diag_conglomid(db_name, conglomid));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return "";
    }

    public static String diag_conglomid(String db_name, long conglomid) throws StandardException {
        String ret_string = null;
        AccessFactory store_module = null;
        store_module = (AccessFactory)D_DiagnosticUtil.getModuleFromDbName(db_name);
        if (store_module != null) {
            TransactionController tc = store_module.getTransaction(ContextService.getFactory().getCurrentContextManager());
            ConglomerateController open_table = tc.openConglomerate(conglomid, false, 0, 7, 5);
            open_table.debugConglomerate();
            Diagnosticable diag_obj = DiagnosticUtil.findDiagnostic(open_table);
            ret_string = diag_obj.diag();
            open_table.close();
        } else {
            System.out.println("Could not find module for database: " + db_name);
        }
        return ret_string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void diag_dump_page(String db_name, long segmentid, long containerid, long pagenumber) {
        Transaction xact = null;
        try {
            Object module = D_DiagnosticUtil.getModuleFromDbName(db_name);
            RawStoreFactory store_module = (RawStoreFactory)Monitor.findServiceModule(module, "com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory");
            xact = store_module.startInternalTransaction(ContextService.getFactory().getCurrentContextManager());
            ContainerKey id = new ContainerKey(segmentid, containerid);
            ContainerHandle container = xact.openContainer(id, 8);
            Page page = container.getPage(pagenumber);
            if (page != null) {
                System.out.println(page.toString());
                page.unlatch();
            } else {
                System.out.println("page " + pagenumber + " not found");
            }
            xact.abort();
            xact.close();
            xact = null;
        }
        catch (StandardException se) {
            se.printStackTrace();
        }
        finally {
            if (xact != null) {
                try {
                    xact.abort();
                    xact.close();
                }
                catch (StandardException standardException) {}
            }
        }
    }

    public static long diag_containerid_to_conglomid(String db_name, long containerid) throws StandardException {
        Object store_module = D_DiagnosticUtil.getModuleFromDbName(db_name);
        return D_DiagnosticUtil.diag_containerid_to_conglomid(store_module, containerid);
    }

    public static long diag_containerid_to_conglomid(Object module, long containerid) {
        Object ret_string = null;
        AccessFactory store_module = null;
        long conglom_id = Long.MIN_VALUE;
        store_module = (AccessFactory)Monitor.getServiceModule(module, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        if (store_module != null) {
            try {
                TransactionController tc = store_module.getTransaction(ContextService.getFactory().getCurrentContextManager());
                conglom_id = tc.findConglomid(containerid);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return conglom_id;
    }

    public static long diag_conglomid_to_containerid(String db_name, long conglomid) throws StandardException {
        Object ret_string = null;
        Object store_module = null;
        long conglom_id = Long.MIN_VALUE;
        store_module = D_DiagnosticUtil.getModuleFromDbName(db_name);
        return D_DiagnosticUtil.diag_conglomid_to_containerid(store_module, conglomid);
    }

    public static long diag_conglomid_to_containerid(Object module, long conglomid) {
        Object ret_string = null;
        AccessFactory store_module = null;
        long container_id = Long.MIN_VALUE;
        store_module = (AccessFactory)Monitor.getServiceModule(module, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory");
        if (store_module != null) {
            try {
                TransactionController tc = store_module.getTransaction(ContextService.getFactory().getCurrentContextManager());
                container_id = tc.findContainerid(conglomid);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return container_id;
    }
}

