/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.AllocPage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.CompressSpacePageOperation10_2;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PhysicalPageOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CompressSpacePageOperation
extends PhysicalPageOperation {
    protected int newHighestPage;
    protected int num_pages_truncated;

    public CompressSpacePageOperation(AllocPage allocPage, int highest_page, int num_truncated) throws StandardException {
        super(allocPage);
        this.newHighestPage = highest_page;
        this.num_pages_truncated = num_truncated;
    }

    public CompressSpacePageOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (!(this instanceof CompressSpacePageOperation10_2)) {
            out.writeInt(this.newHighestPage);
            CompressedNumber.writeInt(out, this.num_pages_truncated);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (!(this instanceof CompressSpacePageOperation10_2)) {
            this.newHighestPage = in.readInt();
            this.num_pages_truncated = CompressedNumber.readInt(in);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 465;
    }

    @Override
    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT((boolean)(this.page instanceof AllocPage));
        ((AllocPage)this.page).compressSpace(instant, this.newHighestPage, this.num_pages_truncated);
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT((undoPage != null ? 1 : 0) != 0, (String)"undo Page null");
        SanityManager.ASSERT((boolean)(undoPage instanceof AllocPage), (String)"undo Page is not an allocPage");
        ((AllocPage)undoPage).undoCompressSpace(CLRInstant, this.newHighestPage, this.num_pages_truncated);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT((String)"cannot call restoreMe on CompressSpaceOperation.");
    }

    @Override
    public String toString() {
        String str = super.toString();
        str = str + " CompressSpaceOperation: newHighestPage = " + this.newHighestPage + ";num_pages_truncated = " + this.num_pages_truncated + " to " + this.getPageId();
        return str;
    }
}

