/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Latch;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.SpaceInfo;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseContainerHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import java.util.Hashtable;
import java.util.Properties;

abstract class BaseContainer
implements Lockable {
    protected ContainerKey identity;
    protected boolean isDropped;
    protected boolean isCommittedDrop;
    protected boolean isReusableRecordId = false;

    BaseContainer() {
    }

    protected void fillInIdentity(ContainerKey key) {
        SanityManager.ASSERT((this.identity == null || this.identity == key ? 1 : 0) != 0);
        this.identity = key;
    }

    public void clearIdentity() {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
        this.identity = null;
    }

    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public void lockEvent(Latch lockInfo) {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
    }

    @Override
    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
        return false;
    }

    @Override
    public boolean lockerAlwaysCompatible() {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
        return false;
    }

    @Override
    public void unlockEvent(Latch lockInfo) {
        SanityManager.ASSERT((this.identity != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressContainer(BaseContainerHandle handle) throws StandardException {
        BaseContainerHandle allocHandle;
        RawTransaction ntt = handle.getTransaction().startNestedTopTransaction();
        int mode = handle.getMode();
        SanityManager.ASSERT(((mode & 4) == 4 ? 1 : 0) != 0, (String)"addPage handle not for update");
        if ((mode & 2) == 0 && (mode & 1) == 1) {
            mode &= 0xFFFFFFFE;
        }
        if ((allocHandle = (BaseContainerHandle)ntt.openContainer(this.identity, null, mode)) == null) {
            throw StandardException.newException("XSDAG.S", (Object)new Long(this.getSegmentId()), (Object)new Long(this.getContainerId()));
        }
        CompatibilitySpace cs = ntt.getCompatibilitySpace();
        ntt.getLockFactory().lockObject(cs, ntt, this, null, -1);
        try {
            this.incrementReusableRecordIdSequenceNumber();
            this.compressContainer(ntt, allocHandle);
        }
        finally {
            ntt.commit();
            ntt.close();
        }
    }

    public abstract long getReusableRecordIdSequenceNumber();

    protected abstract void incrementReusableRecordIdSequenceNumber();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page addPage(BaseContainerHandle handle, boolean isOverflow) throws StandardException {
        BaseContainerHandle allocHandle;
        RawTransaction ntt = handle.getTransaction().startNestedTopTransaction();
        int mode = handle.getMode();
        SanityManager.ASSERT(((mode & 4) == 4 ? 1 : 0) != 0, (String)"addPage handle not for update");
        if ((mode & 2) == 0 && (mode & 1) == 1) {
            mode &= 0xFFFFFFFE;
        }
        if ((allocHandle = (BaseContainerHandle)ntt.openContainer(this.identity, null, mode)) == null) {
            throw StandardException.newException("XSDAG.S", (Object)new Long(this.getSegmentId()), (Object)new Long(this.getContainerId()));
        }
        CompatibilitySpace cs = ntt.getCompatibilitySpace();
        ntt.getLockFactory().lockObject(cs, ntt, this, null, -1);
        BasePage newPage = null;
        try {
            newPage = this.newPage(handle, ntt, allocHandle, isOverflow);
        }
        finally {
            if (newPage != null) {
                ntt.commitNoSync(1);
            } else {
                ntt.abort();
            }
            ntt.close();
        }
        SanityManager.ASSERT((boolean)newPage.isLatched());
        if (!this.identity.equals(newPage.getPageId().getContainerId())) {
            SanityManager.THROWASSERT((String)("BaseContainer.addPage(), just got a new page from a different container\n this.identity = " + this.identity + "\n newPage.getPageId().getContainerId() = " + newPage.getPageId().getContainerId() + "\n handle is: " + handle + "\n allocHandle is: " + allocHandle + "\n this container is: " + this));
            throw StandardException.newException("XSDAC.S", (Object)this.identity, (Object)newPage.getPageId().getContainerId());
        }
        return newPage;
    }

    public abstract void getContainerProperties(Properties var1) throws StandardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePage(BaseContainerHandle handle, BasePage page) throws StandardException {
        try {
            SanityManager.ASSERT((boolean)page.isLatched(), (String)"page is not latched");
            RecordHandle deallocLock = page.makeRecordHandle(2);
            if (!this.getDeallocLock(handle, deallocLock, false, false)) {
                throw StandardException.newException("XSDAI.S", page.getIdentity());
            }
            this.deallocatePage(handle, page);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
        }
    }

    protected boolean getDeallocLock(BaseContainerHandle handle, RecordHandle deallocLock, boolean wait, boolean zeroDuration) throws StandardException {
        RawTransaction tran = handle.getTransaction();
        LockingPolicy lp = tran.newLockingPolicy(1, 4, true);
        PageKey pkey = new PageKey(this.identity, deallocLock.getPageNumber());
        if (lp != null) {
            if (zeroDuration) {
                return lp.zeroDurationLockRecordForWrite(tran, deallocLock, false, wait);
            }
            return lp.lockRecordForWrite(tran, deallocLock, false, wait);
        }
        throw StandardException.newException("XSDAI.S", pkey);
    }

    protected Page getAllocPage(BaseContainerHandle handle, long pageNumber, boolean wait) throws StandardException {
        return this.latchPage(handle, this.getAllocPage(pageNumber), wait);
    }

    protected Page getAnyPage(BaseContainerHandle handle, long pageNumber, boolean wait) throws StandardException {
        return this.latchPage(handle, this.getAnyPage(handle, pageNumber), wait);
    }

    protected Page getFirstPage(BaseContainerHandle handle) throws StandardException {
        return this.getFirstHeadPage(handle, true);
    }

    protected Page getNextPage(BaseContainerHandle handle, long pageNumber) throws StandardException {
        return this.getNextHeadPage(handle, pageNumber, true);
    }

    protected BasePage latchPage(BaseContainerHandle handle, BasePage foundPage, boolean wait) throws StandardException {
        if (foundPage != null) {
            if (wait) {
                foundPage.setExclusive(handle);
            } else if (!foundPage.setExclusiveNoWait(handle)) {
                return null;
            }
        }
        SanityManager.ASSERT((foundPage == null || foundPage.isLatched() ? 1 : 0) != 0);
        return foundPage;
    }

    protected boolean use(BaseContainerHandle handle, boolean forUpdate, boolean droppedOK) throws StandardException {
        if (forUpdate && !this.canUpdate()) {
            throw StandardException.newException("40XD1");
        }
        return droppedOK || !this.getDroppedState() && !this.getCommittedDropState();
    }

    protected void letGo(BaseContainerHandle handle) {
        RawTransaction t = handle.getTransaction();
        handle.getLockingPolicy().unlockContainer(t, handle);
    }

    protected boolean getDroppedState() {
        return this.isDropped;
    }

    protected boolean getCommittedDropState() {
        return this.isCommittedDrop;
    }

    protected boolean isReusableRecordId() {
        return this.isReusableRecordId;
    }

    public int getContainerStatus() {
        if (this.getCommittedDropState()) {
            return 4;
        }
        if (this.getDroppedState()) {
            return 2;
        }
        return 1;
    }

    public long getContainerId() {
        return this.identity.getContainerId();
    }

    public long getSegmentId() {
        return this.identity.getSegmentId();
    }

    protected abstract SpaceInfo getSpaceInfo(BaseContainerHandle var1) throws StandardException;

    protected abstract boolean canUpdate();

    protected abstract void preDirty(boolean var1);

    protected abstract BasePage getPage(BaseContainerHandle var1, long var2, boolean var4) throws StandardException;

    protected abstract BasePage getAllocPage(long var1) throws StandardException;

    protected abstract BasePage getAnyPage(BaseContainerHandle var1, long var2) throws StandardException;

    protected abstract BasePage reCreatePageForRedoRecovery(BaseContainerHandle var1, int var2, long var3, long var5) throws StandardException;

    protected abstract ByteArray logCreateContainerInfo() throws StandardException;

    protected abstract BasePage getHeadPage(BaseContainerHandle var1, long var2, boolean var4) throws StandardException;

    protected abstract BasePage getFirstHeadPage(BaseContainerHandle var1, boolean var2) throws StandardException;

    protected abstract BasePage getNextHeadPage(BaseContainerHandle var1, long var2, boolean var4) throws StandardException;

    protected abstract BasePage getPageForInsert(BaseContainerHandle var1, int var2) throws StandardException;

    protected abstract BasePage getPageForCompress(BaseContainerHandle var1, int var2, long var3) throws StandardException;

    protected abstract void truncatePages(long var1) throws StandardException;

    protected abstract BasePage newPage(BaseContainerHandle var1, RawTransaction var2, BaseContainerHandle var3, boolean var4) throws StandardException;

    protected abstract void compressContainer(RawTransaction var1, BaseContainerHandle var2) throws StandardException;

    protected abstract void deallocatePage(BaseContainerHandle var1, BasePage var2) throws StandardException;

    protected void truncate(BaseContainerHandle handle) throws StandardException {
        SanityManager.THROWASSERT((String)"truncate not supported");
    }

    protected abstract void dropContainer(LogInstant var1, boolean var2);

    protected abstract void removeContainer(LogInstant var1, boolean var2) throws StandardException;

    protected abstract long getContainerVersion() throws StandardException;

    protected abstract void flushAll() throws StandardException;

    protected abstract void prepareForBulkLoad(BaseContainerHandle var1, int var2);

    protected abstract void clearPreallocThreshold();

    public abstract long getEstimatedRowCount(int var1) throws StandardException;

    public abstract void setEstimatedRowCount(long var1, int var3) throws StandardException;

    public abstract long getEstimatedPageCount(BaseContainerHandle var1, int var2) throws StandardException;

    protected abstract void backupContainer(BaseContainerHandle var1, String var2) throws StandardException;

    protected abstract void encryptContainer(BaseContainerHandle var1, String var2) throws StandardException;

    protected void setDroppedState(boolean isDropped) {
        this.isDropped = isDropped;
    }

    protected void setCommittedDropState(boolean isCommittedDrop) {
        this.isCommittedDrop = isCommittedDrop;
    }

    protected void setReusableRecordIdState(boolean isReusableRecordId) {
        this.isReusableRecordId = isReusableRecordId;
    }

    @Override
    public boolean lockAttributes(int flag, Hashtable attributes) {
        return false;
    }
}

