/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeInserter;
import java.util.Properties;

class MergeSortInfo
implements SortInfo {
    private String stat_sortType;
    private int stat_numRowsInput;
    private int stat_numRowsOutput;
    private int stat_numMergeRuns;
    private TIntArrayList stat_mergeRunsSize;
    private int stat_numComparisons;

    MergeSortInfo(MergeInserter sort) {
        this.stat_sortType = sort.stat_sortType;
        this.stat_numRowsInput = sort.stat_numRowsInput;
        this.stat_numRowsOutput = sort.stat_numRowsOutput;
        this.stat_numMergeRuns = sort.stat_numMergeRuns;
        this.stat_mergeRunsSize = sort.stat_mergeRunsSize;
    }

    public MergeSortInfo(String sortType, int numRowsInput, int numRowsOutput, int numMergeRuns, TIntArrayList mergeRunsSize, int numComparisons) {
        this.stat_sortType = sortType;
        this.stat_numRowsInput = numRowsInput;
        this.stat_numRowsOutput = numRowsOutput;
        this.stat_numMergeRuns = numMergeRuns;
        this.stat_mergeRunsSize = mergeRunsSize;
        this.stat_numComparisons = numComparisons;
    }

    @Override
    public Properties getAllSortInfo(Properties prop) throws StandardException {
        if (prop == null) {
            prop = new Properties();
        }
        prop.put(MessageService.getTextMessage("XSAJ8.U"), "external".equals(this.stat_sortType) ? MessageService.getTextMessage("XSAJI.U") : MessageService.getTextMessage("XSAJJ.U"));
        prop.put(MessageService.getTextMessage("XSAJA.U"), Integer.toString(this.stat_numRowsInput));
        prop.put(MessageService.getTextMessage("XSAJB.U"), Integer.toString(this.stat_numRowsOutput));
        if (this.stat_sortType == "external") {
            prop.put(MessageService.getTextMessage("XSAJC.U"), Integer.toString(this.stat_numMergeRuns));
            prop.put(MessageService.getTextMessage("XSAJD.U"), this.stat_mergeRunsSize.toString());
        }
        prop.put(MessageService.getTextMessage("XSAJK.U"), Integer.toString(this.stat_numComparisons));
        return prop;
    }
}

