/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.GenericConglomerateController;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.RowPosition;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.Heap;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapPostCommit;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapRowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.OpenHeap;

public class HeapController
extends GenericConglomerateController
implements ConglomerateController {
    @Override
    protected final void getRowPositionFromRowLocation(RowLocation row_loc, RowPosition pos) throws StandardException {
        SanityManager.ASSERT((boolean)(row_loc instanceof HeapRowLocation));
        pos.current_rh = ((HeapRowLocation)row_loc).getRecordHandle(this.open_conglom.getContainer());
        pos.current_rh_qualified = true;
    }

    @Override
    protected void queueDeletePostCommitWork(RowPosition pos) throws StandardException {
        TransactionManager xact_mgr = this.open_conglom.getXactMgr();
        xact_mgr.addPostCommitWork(new HeapPostCommit(xact_mgr.getAccessManager(), (Heap)this.open_conglom.getConglomerate(), pos.current_page.getPageNumber()));
    }

    protected final boolean purgeCommittedDeletes(Page page) throws StandardException {
        boolean purgingDone = false;
        int num_possible_commit_delete = page.recordCount() - page.nonDeletedRecordCount();
        if (num_possible_commit_delete > 0) {
            for (int slot_no = page.recordCount() - 1; slot_no >= 0; --slot_no) {
                RecordHandle rh;
                boolean row_is_committed_delete = page.isDeletedAtSlot(slot_no);
                if (!row_is_committed_delete || !(row_is_committed_delete = this.lockRowAtSlotNoWaitExclusive(rh = page.fetchFromSlot(null, slot_no, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                purgingDone = true;
                page.purgeAtSlot(slot_no, 1, false);
            }
        }
        if (page.recordCount() == 0) {
            this.removePage(page);
            purgingDone = true;
        }
        return purgingDone;
    }

    private RecordHandle doInsert(DataValueDescriptor[] row) throws StandardException {
        RecordHandle rh;
        byte insert_mode;
        Page page = null;
        Heap heap = (Heap)this.open_conglom.getConglomerate();
        int invalidColumn = RowUtil.columnOutOfRange(row, null, heap.format_ids.length);
        if (invalidColumn >= 0) {
            throw StandardException.newException("XSCH5.S", (Object)new Long(invalidColumn), (Object)new Long(heap.format_ids.length));
        }
        page = this.open_conglom.getContainer().getPageForInsert(0);
        if (page != null) {
            insert_mode = page.recordCount() == 0 ? (byte)8 : 1;
            rh = page.insert(row, null, insert_mode, 100);
            page.unlatch();
            page = null;
            if (rh != null) {
                return rh;
            }
        }
        if ((page = this.open_conglom.getContainer().getPageForInsert(1)) != null) {
            insert_mode = page.recordCount() == 0 ? (byte)8 : 1;
            rh = page.insert(row, null, insert_mode, 100);
            page.unlatch();
            page = null;
            if (rh != null) {
                return rh;
            }
        }
        page = this.open_conglom.getContainer().addPage();
        rh = page.insert(row, null, (byte)8, 100);
        page.unlatch();
        page = null;
        SanityManager.ASSERT((rh != null ? 1 : 0) != 0);
        return rh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long load(TransactionManager xact_manager, Heap heap, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        OpenHeap open_conglom;
        long num_rows_loaded = 0L;
        SanityManager.ASSERT((this.open_conglom == null ? 1 : 0) != 0, (String)"load expects container handle to be closed on entry.");
        int mode = 5;
        if (createConglom) {
            mode |= 2;
        }
        if ((open_conglom = new OpenHeap()).init(null, heap, heap.format_ids, heap.collation_ids, xact_manager, xact_manager.getRawStoreXact(), false, mode, 7, xact_manager.getRawStoreXact().newLockingPolicy(2, 5, true), null) == null) {
            throw StandardException.newException("XSCH1.S", new Long(heap.getId().getContainerId()));
        }
        this.init(open_conglom);
        Page page = open_conglom.getContainer().addPage();
        boolean callbackWithRowLocation = rowSource.needsRowLocation();
        HeapRowLocation rowlocation = callbackWithRowLocation ? new HeapRowLocation() : null;
        FormatableBitSet validColumns = rowSource.getValidColumns();
        try {
            Object[] row;
            while ((row = rowSource.getNextRowFromRowSource().getRowArray()) != null) {
                ++num_rows_loaded;
                int invalidColumn = RowUtil.columnOutOfRange((DataValueDescriptor[])row, validColumns, heap.format_ids.length);
                if (invalidColumn >= 0) {
                    throw StandardException.newException("XSCH5.S", (Object)new Long(invalidColumn), (Object)new Long(heap.format_ids.length));
                }
                RecordHandle rh = page.insert(row, validColumns, (byte)1, 100);
                if (rh == null) {
                    page.unlatch();
                    page = null;
                    page = open_conglom.getContainer().addPage();
                    rh = page.insert(row, validColumns, (byte)8, 100);
                }
                if (!callbackWithRowLocation) continue;
                rowlocation.setFrom(rh);
                rowSource.rowLocation(rowlocation);
            }
            page.unlatch();
            page = null;
            if (!heap.isTemporary()) {
                open_conglom.getContainer().flushContainer();
            }
        }
        finally {
            this.close();
        }
        return num_rows_loaded;
    }

    protected boolean lockRow(RecordHandle rh, int lock_oper, boolean wait, int lock_duration) throws StandardException {
        boolean ret_val;
        boolean forUpdateLock;
        boolean forUpdate = (1 & lock_oper) != 0;
        boolean bl = forUpdateLock = (8 & lock_oper) != 0;
        if (forUpdate && !forUpdateLock) {
            boolean forInsert = (2 & lock_oper) != 0;
            boolean forInsertPrevKey = (4 & lock_oper) != 0;
            SanityManager.ASSERT((!forInsertPrevKey || !forInsert ? 1 : 0) != 0);
            ret_val = lock_duration == 1 ? this.open_conglom.getContainer().getLockingPolicy().zeroDurationLockRecordForWrite(this.open_conglom.getRawTran(), rh, forInsertPrevKey, wait) : this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), rh, forInsert, wait);
        } else {
            SanityManager.ASSERT(((2 & lock_oper) == 0 ? 1 : 0) != 0);
            SanityManager.ASSERT(((4 & lock_oper) == 0 ? 1 : 0) != 0);
            ret_val = this.open_conglom.getContainer().getLockingPolicy().lockRecordForRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), rh, wait, forUpdate);
        }
        return ret_val;
    }

    protected Page getUserPageNoWait(long pageno) throws StandardException {
        return this.open_conglom.getContainer().getUserPageNoWait(pageno);
    }

    protected Page getUserPageWait(long pageno) throws StandardException {
        return this.open_conglom.getContainer().getUserPageWait(pageno);
    }

    protected boolean lockRowAtSlotNoWaitExclusive(RecordHandle rh) throws StandardException {
        return this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), rh, false, false);
    }

    protected void removePage(Page page) throws StandardException {
        this.open_conglom.getContainer().removePage(page);
    }

    @Override
    public int insert(DataValueDescriptor[] row) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        this.doInsert(row);
        return 0;
    }

    @Override
    public RowLocation insertAndFetchLocation(DataValueDescriptor[] row, RowLocation templateRowLocation) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RecordHandle rh = this.doInsert(row);
        SanityManager.ASSERT((boolean)(templateRowLocation instanceof HeapRowLocation));
        HeapRowLocation hrl = (HeapRowLocation)templateRowLocation;
        hrl.setFrom(rh);
        return hrl;
    }

    @Override
    public boolean lockRow(RowLocation loc, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        RecordHandle rh = ((HeapRowLocation)loc).getRecordHandle(this.open_conglom.getContainer());
        return this.lockRow(rh, lock_operation, wait, lock_duration);
    }

    @Override
    public void unlockRowAfterRead(RowLocation loc, boolean forUpdate, boolean row_qualified) throws StandardException {
        RecordHandle rh = ((HeapRowLocation)loc).getRecordHandle(this.open_conglom.getContainer());
        this.open_conglom.getContainer().getLockingPolicy().unlockRecordAfterRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), rh, this.open_conglom.isForUpdate(), row_qualified);
    }

    @Override
    public boolean lockRow(long page_num, int record_id, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        RecordHandle rh = this.open_conglom.getContainer().makeRecordHandle(page_num, record_id);
        return this.lockRow(rh, lock_operation, wait, lock_duration);
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        return new HeapRowLocation();
    }
}

